/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.gradle;

import aQute.bnd.build.Run;
import aQute.bnd.build.Workspace;
import aQute.bnd.build.model.EE;
import aQute.bnd.exceptions.FunctionWithException;
import aQute.bnd.gradle.BeanProperties;
import aQute.bnd.gradle.BndPluginExtension;
import aQute.bnd.gradle.BndUtils;
import aQute.bnd.gradle.FileSetRepositoryConvention;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Processor;
import aQute.bnd.repository.fileset.FileSetRepository;
import aQute.bnd.service.RepositoryPlugin;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.work.NormalizeLineEndings;

public abstract class AbstractBndrun<WORKER extends aQute.bnd.build.Project, RUN extends WORKER>
extends DefaultTask {
    private final RegularFileProperty bndrun;
    private final ConfigurableFileCollection bundles;
    private boolean ignoreFailures = false;
    private final DirectoryProperty workingDirectory;
    private final String projectName;
    private final Provider<String> targetVersion;
    private final FileCollection artifacts;

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NormalizeLineEndings
    public RegularFileProperty getBndrun() {
        return this.bndrun;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public ConfigurableFileCollection getBundles() {
        return this.bundles;
    }

    @Input
    public boolean isIgnoreFailures() {
        return this.ignoreFailures;
    }

    @Internal
    public boolean getIgnoreFailures() {
        return this.isIgnoreFailures();
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Internal
    public DirectoryProperty getWorkingDirectory() {
        return this.workingDirectory;
    }

    public AbstractBndrun() {
        Project project = this.getProject();
        this.projectName = project.getName();
        ObjectFactory objects = project.getObjects();
        this.bndrun = objects.fileProperty();
        DirectoryProperty temporaryDirProperty = objects.directoryProperty().fileValue(this.getTemporaryDir());
        this.workingDirectory = objects.directoryProperty().convention((Provider)temporaryDirProperty);
        this.bundles = objects.fileCollection();
        SourceSet mainSourceSet = (SourceSet)BndUtils.sourceSets(project).getByName("main");
        this.targetVersion = project.getTasks().named(mainSourceSet.getCompileJavaTaskName(), JavaCompile.class).map(t -> (String)t.getOptions().getRelease().map(r -> r.toString()).getOrElse((Object)t.getTargetCompatibility()));
        Configuration archivesConfiguration = project.getConfigurations().getByName("archives");
        this.artifacts = archivesConfiguration.getArtifacts().getFiles();
        if (project.hasProperty("bndWorkspace")) {
            this.bundles.disallowChanges();
        } else {
            this.bundles(mainSourceSet.getRuntimeClasspath());
            this.bundles(this.artifacts);
            this.getConvention().getPlugins().put("bundles", new FileSetRepositoryConvention((Task)this));
        }
    }

    public ConfigurableFileCollection bundles(Object ... paths) {
        return BndUtils.builtBy(this.getBundles().from(paths), paths);
    }

    public void setBundles(Object path) {
        this.getBundles().setFrom(Collections.emptyList());
        this.getBundles().setBuiltBy(Collections.emptyList());
        this.bundles(path);
    }

    @TaskAction
    public void bndrunAction() throws Exception {
        BndPluginExtension extension;
        Workspace workspace = (Workspace)this.getProject().findProperty("bndWorkspace");
        File bndrunFile = BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)this.getBndrun());
        File workingDirFile = BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)this.getWorkingDirectory());
        if (Objects.nonNull(workspace) && this.getProject().getPlugins().hasPlugin("biz.aQute.bnd") && Objects.equals(bndrunFile, (extension = (BndPluginExtension)this.getProject().getExtensions().getByType(BndPluginExtension.class)).getProject().getPropertiesFile())) {
            aQute.bnd.build.Project worker = extension.getProject();
            this.worker(worker);
            return;
        }
        try (RUN run = this.createRun(workspace, bndrunFile);){
            Workspace runWorkspace = run.getWorkspace();
            IO.mkdirs((File)workingDirFile);
            if (Objects.isNull(workspace)) {
                BeanProperties gradleProperties = new BeanProperties(runWorkspace.getProperties());
                gradleProperties.put("task", (Object)this);
                gradleProperties.put("project", this.getProject());
                run.setParent(new Processor((Processor)runWorkspace, (Properties)gradleProperties, false));
            }
            run.setBase(workingDirFile);
            if (run.isStandalone()) {
                runWorkspace.setOffline(Objects.nonNull(workspace) ? workspace.isOffline() : this.getProject().getGradle().getStartParameter().isOffline());
                File cnf = new File(workingDirFile, "cnf");
                IO.mkdirs((File)cnf);
                runWorkspace.setBuildDir(cnf);
                if (Objects.isNull(workspace)) {
                    FileSetRepository fileSetRepository = new FileSetRepository(this.getName(), (Collection)this.getBundles().getFiles());
                    runWorkspace.addBasicPlugin((Object)fileSetRepository);
                    for (RepositoryPlugin repo : runWorkspace.getRepositories()) {
                        repo.list(null);
                    }
                }
            }
            run.getInfo((Reporter)runWorkspace);
            this.inferRunEE(run);
            this.inferRunRequires(run);
            BndUtils.logReport(run, this.getLogger());
            if (!run.isOk()) {
                throw new GradleException(String.format("%s workspace errors", run.getPropertiesFile()));
            }
            this.worker(run);
        }
    }

    protected RUN createRun(Workspace workspace, File bndrunFile) throws Exception {
        Run run = Run.createRun((Workspace)workspace, (File)bndrunFile);
        return (RUN)run;
    }

    protected abstract void worker(WORKER var1) throws Exception;

    protected void inferRunEE(RUN run) {
        String runee = run.getProperty("-runee");
        if (Objects.isNull(runee)) {
            runee = Optional.ofNullable(this.targetVersion.getOrElse((Object)System.getProperty("java.specification.version"))).flatMap(EE::highestFromTargetVersion).orElse(EE.JavaSE_1_8).getEEName();
            run.setProperty("-runee", runee);
            this.getLogger().info("Bnd inferred {}: {}", (Object)"-runee", (Object)run.getProperty("-runee"));
        }
    }

    protected void inferRunRequires(RUN run) {
        String runrequires = run.getProperty("-runrequires");
        if (Objects.isNull(runrequires) && !this.artifacts.isEmpty() && !(runrequires = (String)this.artifacts.getFiles().stream().filter(File::isFile).map(file -> Optional.of(file).map(FunctionWithException.asFunctionOrElse(Domain::domain, null)).map(Domain::getBundleSymbolicName).map(Map.Entry::getKey).orElse(this.projectName)).distinct().map(bsn -> String.format("osgi.identity;filter:='(osgi.identity=%s)'", bsn)).collect(Strings.joining())).isEmpty()) {
            run.setProperty("-runrequires", runrequires);
            this.getLogger().info("Bnd inferred {}: {}", (Object)"-runrequires", (Object)run.getProperty("-runrequires"));
        }
    }
}

