/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.gradle;

import aQute.bnd.build.Project;
import aQute.bnd.build.Run;
import aQute.bnd.gradle.AbstractBndrun;
import aQute.bnd.gradle.BndUtils;
import aQute.bnd.osgi.JarResource;
import aQute.bnd.osgi.Resource;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.service.reporter.Report;
import java.io.File;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.model.ReplacedBy;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;

public class Export
extends AbstractBndrun<Project, Run> {
    private boolean bundlesOnly = false;
    private final DirectoryProperty destinationDirectory;
    private final Property<String> exporter;

    @ReplacedBy(value="exporter")
    @Deprecated
    public boolean isBundlesOnly() {
        return this.bundlesOnly;
    }

    @Internal
    @Deprecated
    public boolean getBundlesOnly() {
        return this.isBundlesOnly();
    }

    @Deprecated
    public void setBundlesOnly(boolean bundlesOnly) {
        this.bundlesOnly = bundlesOnly;
    }

    @OutputDirectory
    public DirectoryProperty getDestinationDirectory() {
        return this.destinationDirectory;
    }

    @Input
    public Property<String> getExporter() {
        return this.exporter;
    }

    public Export() {
        ObjectFactory objects = this.getProject().getObjects();
        this.exporter = objects.property(String.class).convention(this.getProject().provider(() -> this.getBundlesOnly() ? "bnd.runbundles" : "bnd.executablejar"));
        DirectoryProperty distsDirectory = BndUtils.distDirectory(this.getProject());
        this.destinationDirectory = objects.directoryProperty().convention(distsDirectory.flatMap(distsDir -> distsDir.dir(this.getExporter().map(exporterName -> {
            switch (exporterName) {
                case "bnd.executablejar": {
                    return "executable";
                }
                case "bnd.runbundles": {
                    File bndrunFile = BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)this.getBndrun());
                    String[] parts = Strings.extension((String)bndrunFile.getName());
                    return String.format("runbundles/%s", parts != null ? parts[0] : bndrunFile.getName());
                }
            }
            return exporterName;
        }))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void worker(Project run) throws Exception {
        block41: {
            String exporterName = BndUtils.unwrap(this.getExporter());
            File destinationDirFile = BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)this.getDestinationDirectory());
            this.getLogger().info("Exporting {} to {} with exporter {}", new Object[]{run.getPropertiesFile(), destinationDirFile, exporterName});
            this.getLogger().debug("Run properties: {}", (Object)run.getProperties());
            try {
                Map.Entry export = run.export(exporterName, Collections.emptyMap());
                if (!Objects.nonNull(export)) break block41;
                if (Objects.equals(exporterName, "bnd.runbundles")) {
                    try (JarResource jr = (JarResource)export.getValue();){
                        jr.getJar().writeFolder(destinationDirFile);
                        break block41;
                    }
                }
                try (Resource r = (Resource)export.getValue();){
                    File exported = IO.getBasedFile((File)destinationDirFile, (String)((String)export.getKey()));
                    try (OutputStream out = IO.outputStream((File)exported);){
                        r.write(out);
                    }
                    exported.setLastModified(r.lastModified());
                }
            }
            finally {
                BndUtils.logReport((Report)run, this.getLogger());
            }
        }
        if (!this.isIgnoreFailures() && !run.isOk()) {
            throw new GradleException(String.format("%s export failure", run.getPropertiesFile()));
        }
    }
}

