/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.gradle;

import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.gradle.BeanProperties;
import aQute.bnd.gradle.BndUtils;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.stream.MapStream;
import aQute.bnd.unmodifiable.Maps;
import aQute.bnd.version.MavenVersion;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.service.reporter.Report;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.jar.Attributes;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.internal.DefaultManifest;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskInputFilePropertyBuilder;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.work.NormalizeLineEndings;

public class BundleTaskExtension {
    public static final String NAME = "bundle";
    private final RegularFileProperty bndfile;
    private final ConfigurableFileCollection classpath;
    private final Provider<String> bnd;
    private final MapProperty<String, Object> properties;
    private final Provider<String> defaultBundleSymbolicName;
    private final Provider<String> defaultBundleVersion;
    private final ConfigurableFileCollection allSource;
    private final Jar task;
    private final ProjectLayout layout;
    private final File buildFile;
    private final ListProperty<CharSequence> instructions;
    private final DirectoryProperty outputDirectory;

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NormalizeLineEndings
    @Optional
    public RegularFileProperty getBndfile() {
        return this.bndfile;
    }

    @InputFiles
    @Classpath
    public ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @Input
    @Optional
    public Provider<String> getBnd() {
        return this.bnd;
    }

    @Input
    public MapProperty<String, Object> getProperties() {
        return this.properties;
    }

    public BundleTaskExtension(Jar task) {
        this.task = task;
        Project project = task.getProject();
        this.layout = project.getLayout();
        ObjectFactory objects = project.getObjects();
        this.buildFile = project.getBuildFile();
        this.bndfile = objects.fileProperty();
        this.instructions = objects.listProperty(CharSequence.class).empty();
        this.bnd = this.instructions.map(list -> Strings.join((String)"\n", (Iterable)list));
        this.classpath = objects.fileCollection();
        this.allSource = objects.fileCollection();
        this.outputDirectory = objects.directoryProperty();
        SourceSet mainSourceSet = (SourceSet)BndUtils.sourceSets(project).getByName("main");
        this.setSourceSet(mainSourceSet);
        this.classpath(mainSourceSet.getCompileClasspath());
        this.properties = objects.mapProperty(String.class, Object.class).convention(Maps.of((Object)"project", (Object)"__convention__"));
        this.defaultBundleSymbolicName = task.getArchiveBaseName().zip((Provider)task.getArchiveClassifier(), (baseName, classifier) -> classifier.isEmpty() ? baseName : baseName + "-" + classifier);
        this.defaultBundleVersion = task.getArchiveVersion().orElse((Object)"0").map(version -> MavenVersion.parseMavenString((String)version).getOSGiVersion().toString());
        task.getInputs().files(new Object[]{this.getClasspath()}).withNormalizer(ClasspathNormalizer.class).withPropertyName("classpath");
        TaskInputFilePropertyBuilder bndfileInput = task.getInputs().file((Object)this.getBndfile()).optional().withPathSensitivity(PathSensitivity.RELATIVE).withPropertyName("bndfile");
        if (BndUtils.isGradleCompatible("7.2")) {
            bndfileInput.normalizeLineEndings();
        }
        task.getInputs().property("bnd", this.getBnd());
        task.getInputs().property("properties", this.getProperties());
        task.getInputs().property("default Bundle-SymbolicName", this.getDefaultBundleSymbolicName());
        task.getInputs().property("default Bundle-Version", this.getDefaultBundleVersion());
    }

    public void setBnd(CharSequence line) {
        this.instructions.empty();
        this.bnd(line);
    }

    public void bnd(CharSequence ... lines) {
        this.instructions.addAll((Object[])lines);
    }

    public void setBnd(Provider<? extends CharSequence> lines) {
        this.instructions.empty();
        this.bnd(lines);
    }

    public void bnd(Provider<? extends CharSequence> lines) {
        this.instructions.add(lines);
    }

    public void setBnd(Map<String, ?> map) {
        this.instructions.empty();
        this.bnd(map);
    }

    public void bnd(Map<String, ?> map) {
        map.forEach((key, value) -> this.instructions.add((Object)(key + "=" + value)));
    }

    public ConfigurableFileCollection classpath(Object ... paths) {
        return BndUtils.builtBy(this.getClasspath().from(paths), paths);
    }

    public void setClasspath(Object path) {
        this.getClasspath().setFrom(Collections.emptyList());
        this.getClasspath().setBuiltBy(Collections.emptyList());
        this.classpath(path);
    }

    public void setSourceSet(SourceSet sourceSet) {
        this.getAllSource().setFrom((Iterable)sourceSet.getAllSource().getSourceDirectories());
        this.getOutputDirectory().value(this.getTask().getProject().getTasks().named(sourceSet.getCompileJavaTaskName(), AbstractCompile.class).flatMap(AbstractCompile::getDestinationDirectory));
        BndUtils.jarLibraryElements((Task)this.getTask(), sourceSet.getCompileClasspathConfigurationName());
    }

    ConfigurableFileCollection getAllSource() {
        return this.allSource;
    }

    File getBuildFile() {
        return this.buildFile;
    }

    DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    Provider<String> getDefaultBundleSymbolicName() {
        return this.defaultBundleSymbolicName;
    }

    Provider<String> getDefaultBundleVersion() {
        return this.defaultBundleVersion;
    }

    ProjectLayout getLayout() {
        return this.layout;
    }

    Jar getTask() {
        return this.task;
    }

    public Action<Task> buildAction() {
        return new BuildAction();
    }

    private class BuildAction
    implements Action<Task> {
        private BuildAction() {
        }

        public void execute(Task t) {
            try {
                File projectDir = BndUtils.unwrapFile((FileSystemLocation)BundleTaskExtension.this.getLayout().getProjectDirectory());
                File outputDir = BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)BundleTaskExtension.this.getOutputDirectory());
                File buildFile = BundleTaskExtension.this.getBuildFile();
                FileCollection sourcepath = BundleTaskExtension.this.getAllSource().filter(File::exists);
                java.util.Optional<Manifest> taskManifest = java.util.Optional.ofNullable(BundleTaskExtension.this.getTask().getManifest());
                BeanProperties gradleProperties = new BeanProperties();
                gradleProperties.putAll((Map<?, ?>)((Map)BndUtils.unwrap(BundleTaskExtension.this.getProperties())));
                gradleProperties.computeIfPresent("project", (BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(k, v) -> "__convention__".equals(v) ? BundleTaskExtension.this.getTask().getProject() : v));
                gradleProperties.putIfAbsent("task", BundleTaskExtension.this.getTask());
                try (Builder builder = new Builder(new Processor((Properties)gradleProperties, false));){
                    String bundleVersion;
                    String compression;
                    File temporaryBndFile = File.createTempFile("bnd", ".bnd", BundleTaskExtension.this.getTask().getTemporaryDir());
                    try (PrintWriter writer = IO.writer((File)temporaryBndFile);){
                        java.util.Optional<File> bndfile;
                        java.util.Optional<UTF8Properties> properties = taskManifest.map(manifest -> (UTF8Properties)MapStream.ofNullable((Map)manifest.getEffectiveManifest().getAttributes()).filterKey(key -> !Objects.equals(key, "Manifest-Version")).mapValue(this::unwrapAttributeValue).collect(MapStream.toMap((k1, k2) -> {
                            throw new IllegalStateException("Duplicate key " + k1);
                        }, UTF8Properties::new)));
                        if (properties.isPresent()) {
                            properties.get().replaceHere(projectDir).store((Writer)writer, null);
                        }
                        if ((bndfile = BndUtils.unwrapFileOptional((Provider<? extends FileSystemLocation>)BundleTaskExtension.this.getBndfile()).filter(File::isFile)).isPresent()) {
                            builder.loadProperties(bndfile.get()).store(writer, null);
                        } else {
                            String bnd = BndUtils.unwrap(BundleTaskExtension.this.getBnd());
                            if (!bnd.isEmpty()) {
                                UTF8Properties props = new UTF8Properties();
                                props.load(bnd, buildFile, (Reporter)builder);
                                props.replaceHere(projectDir).store((Writer)writer, null);
                            }
                        }
                    }
                    builder.setProperties(temporaryBndFile, projectDir);
                    builder.setProperty("project.output", outputDir.getCanonicalPath());
                    if (builder.is("-nobundles")) {
                        return;
                    }
                    if (!Objects.equals(builder.getSubBuilders(), Collections.singletonList(builder))) {
                        throw new GradleException("Sub-bundles are not supported by this task");
                    }
                    File archiveFile = BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)BundleTaskExtension.this.getTask().getArchiveFile());
                    String archiveFileName = (String)BndUtils.unwrap(BundleTaskExtension.this.getTask().getArchiveFileName());
                    File archiveCopyFile = new File(BundleTaskExtension.this.getTask().getTemporaryDir(), archiveFileName);
                    IO.copy((File)archiveFile, (File)archiveCopyFile);
                    aQute.bnd.osgi.Jar bundleJar = new aQute.bnd.osgi.Jar(archiveFileName, archiveCopyFile);
                    String reproducible = builder.getProperty("-reproducible");
                    if (Objects.isNull(reproducible) && !BundleTaskExtension.this.getTask().isPreserveFileTimestamps()) {
                        builder.setProperty("-reproducible", Boolean.TRUE.toString());
                    }
                    if (Objects.isNull(compression = builder.getProperty("-compression"))) {
                        switch (BundleTaskExtension.this.getTask().getEntryCompression()) {
                            case STORED: {
                                builder.setProperty("-compression", Jar.Compression.STORE.name());
                                break;
                            }
                        }
                    }
                    bundleJar.updateModified(archiveFile.lastModified(), "time of Jar task generated jar");
                    bundleJar.setManifest(new java.util.jar.Manifest());
                    builder.setJar(bundleJar);
                    FileCollection buildpath = BundleTaskExtension.this.getClasspath().filter(file -> {
                        if (!file.exists()) {
                            return false;
                        }
                        if (file.isDirectory()) {
                            return true;
                        }
                        try (ZipFile zip = new ZipFile((File)file);){
                            zip.entries();
                        }
                        catch (IOException e) {
                            return false;
                        }
                        return true;
                    });
                    builder.setProperty("project.buildpath", buildpath.getAsPath());
                    builder.setClasspath(buildpath.getFiles().toArray(new File[0]));
                    BundleTaskExtension.this.getTask().getLogger().debug("builder classpath: {}", builder.getClasspath().stream().map(aQute.bnd.osgi.Jar::getSource).collect(Collectors.toList()));
                    builder.setProperty("project.sourcepath", sourcepath.getAsPath());
                    builder.setSourcepath(sourcepath.getFiles().toArray(new File[0]));
                    BundleTaskExtension.this.getTask().getLogger().debug("builder sourcepath: {}", (Object)builder.getSourcePath());
                    String bundleSymbolicName = builder.getProperty("Bundle-SymbolicName");
                    if (this.isEmpty(bundleSymbolicName)) {
                        bundleSymbolicName = BndUtils.unwrap(BundleTaskExtension.this.getDefaultBundleSymbolicName());
                        builder.setProperty("Bundle-SymbolicName", bundleSymbolicName);
                    }
                    if (this.isEmpty(bundleVersion = builder.getProperty("Bundle-Version"))) {
                        bundleVersion = BndUtils.unwrap(BundleTaskExtension.this.getDefaultBundleVersion());
                        builder.setProperty("Bundle-Version", bundleVersion);
                    }
                    BundleTaskExtension.this.getTask().getLogger().debug("builder properties: {}", (Object)builder.getProperties());
                    aQute.bnd.osgi.Jar builtJar = builder.build();
                    if (!builder.isOk()) {
                        BndUtils.logReport((Report)builder, BundleTaskExtension.this.getTask().getLogger());
                        this.failTask("Bundle " + archiveFileName + " has errors", archiveFile);
                    }
                    builtJar.write(archiveFile);
                    long now = System.currentTimeMillis();
                    archiveFile.setLastModified(now);
                    java.util.jar.Manifest builtManifest = builtJar.getManifest();
                    taskManifest.ifPresent(manifest -> manifest.from((Object)this.mergeManifest(builtManifest), merge -> merge.eachEntry(details -> {
                        if (details.getMergeValue() == null) {
                            details.exclude();
                        }
                    })));
                    BndUtils.logReport((Report)builder, BundleTaskExtension.this.getTask().getLogger());
                    if (!builder.isOk()) {
                        this.failTask("Bundle " + archiveFileName + " has errors", archiveFile);
                    }
                }
            }
            catch (Exception e) {
                throw Exceptions.duck((Throwable)e);
            }
        }

        private Manifest mergeManifest(java.util.jar.Manifest builtManifest) {
            DefaultManifest mergeManifest = new DefaultManifest(null);
            mergeManifest.attributes((Map)new AttributesMap(builtManifest.getMainAttributes()));
            builtManifest.getEntries().forEach((arg_0, arg_1) -> BuildAction.lambda$mergeManifest$8((Manifest)mergeManifest, arg_0, arg_1));
            return mergeManifest;
        }

        private String unwrapAttributeValue(Object value) {
            while (value instanceof Provider) {
                value = ((Provider)value).getOrNull();
            }
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        private void failTask(String msg, File archiveFile) {
            IO.delete((File)archiveFile);
            throw new GradleException(msg);
        }

        private boolean isEmpty(String header) {
            return Objects.isNull(header) || header.trim().isEmpty() || "<<EMPTY>>".equals(header);
        }

        private static /* synthetic */ void lambda$mergeManifest$8(Manifest mergeManifest, String section, Attributes attrs) {
            mergeManifest.attributes((Map)new AttributesMap(attrs), section);
        }
    }

    static final class AttributesMap
    extends AbstractMap<String, Object> {
        final Attributes source;

        AttributesMap(Attributes source) {
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            final Set<Map.Entry<Object, Object>> entrySet = this.source.entrySet();
            return new AbstractSet<Map.Entry<String, Object>>(){

                @Override
                public Iterator<Map.Entry<String, Object>> iterator() {
                    final Iterator iterator = entrySet.iterator();
                    return new Iterator<Map.Entry<String, Object>>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        @Override
                        public Map.Entry<String, Object> next() {
                            Map.Entry next = (Map.Entry)iterator.next();
                            return new AbstractMap.SimpleImmutableEntry<String, Object>(next.getKey().toString(), next.getValue());
                        }
                    };
                }

                @Override
                public int size() {
                    return entrySet.size();
                }
            };
        }
    }
}

