/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.swt.os;

import com.diffplug.common.swt.os.OS;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SwtPlatform {
    private final String ws;
    private final String os;
    private final String arch;

    private SwtPlatform(String ws, String os, String arch) {
        this.ws = ws;
        this.os = os;
        this.arch = arch;
    }

    public String getWs() {
        return this.ws;
    }

    public String getOs() {
        return this.os;
    }

    public String getArch() {
        return this.arch;
    }

    public boolean equals(Object otherRaw) {
        if (otherRaw instanceof SwtPlatform) {
            SwtPlatform other = (SwtPlatform)otherRaw;
            return this.ws.equals(other.ws) && this.os.equals(other.os) && this.arch.equals(other.arch);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.ws, this.os, this.arch);
    }

    public String toString() {
        return this.ws + "." + this.os + "." + this.arch;
    }

    public String platformFilter() {
        return "(& (osgi.ws=" + this.ws + ") (osgi.os=" + this.os + ") (osgi.arch=" + this.arch + ") )";
    }

    public Map<String, String> platformProperties() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("osgi.ws", this.ws);
        map.put("osgi.os", this.os);
        map.put("osgi.arch", this.arch);
        return map;
    }

    public String getWuffString() {
        HashMap<SwtPlatform, String> wuffMap = new HashMap<SwtPlatform, String>();
        wuffMap.put(SwtPlatform.parseWsOsArch("cocoa.macosx.x86_64"), "macosx-x86_64");
        wuffMap.put(SwtPlatform.parseWsOsArch("gtk.linux.x86"), "linux-x86_32");
        wuffMap.put(SwtPlatform.parseWsOsArch("gtk.linux.x86_64"), "linux-x86_64");
        wuffMap.put(SwtPlatform.parseWsOsArch("win32.win32.x86"), "windows-x86_32");
        wuffMap.put(SwtPlatform.parseWsOsArch("win32.win32.x86_64"), "windows-x86_64");
        return Objects.requireNonNull((String)wuffMap.get(this));
    }

    public static SwtPlatform parseWsOsArch(String unparsed) {
        String[] pieces = unparsed.split("\\.", -1);
        if (pieces.length != 3) {
            throw new IllegalArgumentException(unparsed + " should have the form 'ws.os.arch'.");
        }
        String ws = pieces[0];
        String os = pieces[1];
        String arch = pieces[2];
        return new SwtPlatform(ws, os, arch);
    }

    public static SwtPlatform getNative() {
        return SwtPlatform.fromOS(OS.getNative());
    }

    public static SwtPlatform getRunning() {
        return SwtPlatform.fromOS(OS.getRunning());
    }

    public static SwtPlatform fromOS(OS raw) {
        String ws = raw.winMacLinux("win32", "cocoa", "gtk");
        String os = raw.winMacLinux("win32", "macosx", "linux");
        String arch = raw.getArch().x86x64arm64unknown("x86", "x86_64", "aarch64", "unknown");
        return new SwtPlatform(ws, os, arch);
    }

    public OS toOS() {
        for (OS os : OS.values()) {
            if (!SwtPlatform.fromOS(os).equals(this)) continue;
            return os;
        }
        throw new IllegalArgumentException("No known OS matches this platform: " + this);
    }

    public static List<SwtPlatform> getAll() {
        return Arrays.asList(OS.values()).stream().map(SwtPlatform::fromOS).collect(Collectors.toList());
    }
}

