/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FormatterFunc;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class Jvm {
    private static final int VERSION;

    public static int version() {
        return VERSION;
    }

    public static <V> Support<V> support(String formatterName) {
        Objects.requireNonNull(formatterName);
        return new Support(formatterName);
    }

    static {
        String jre = System.getProperty("java.version");
        if (jre.startsWith("1.8")) {
            VERSION = 8;
        } else {
            Matcher matcher = Pattern.compile("(\\d+)").matcher(jre);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Expected " + jre + " to start with an integer");
            }
            VERSION = Integer.parseInt(matcher.group(1));
            if (VERSION <= 8) {
                throw new IllegalArgumentException("Expected " + jre + " to start with an integer greater than 8");
            }
        }
    }

    public static class Support<V> {
        private final String fmtName;
        private final Comparator<? super V> fmtVersionComparator;
        private final NavigableMap<Integer, V> jvm2fmtVersion;
        private final NavigableMap<V, Integer> fmt2jvmVersion;

        private Support(String fromatterName) {
            this(fromatterName, new SemanticVersionComparator());
        }

        private Support(String formatterName, Comparator<? super V> formatterVersionComparator) {
            this.fmtName = formatterName;
            this.fmtVersionComparator = formatterVersionComparator;
            this.jvm2fmtVersion = new TreeMap<Integer, V>();
            this.fmt2jvmVersion = new TreeMap<Integer, Integer>(formatterVersionComparator);
        }

        public Support<V> add(int minimumJvmVersion, V maxFormatterVersion) {
            Objects.requireNonNull(maxFormatterVersion);
            if (null != this.jvm2fmtVersion.put(minimumJvmVersion, maxFormatterVersion)) {
                throw new IllegalArgumentException(String.format("Added duplicate entry for JVM %d+.", minimumJvmVersion));
            }
            if (null != this.fmt2jvmVersion.put((Integer)maxFormatterVersion, minimumJvmVersion)) {
                throw new IllegalArgumentException(String.format("Added duplicate entry for formatter version %s.", maxFormatterVersion));
            }
            Map.Entry<Integer, V> lower = this.jvm2fmtVersion.lowerEntry(minimumJvmVersion);
            if (null != lower && this.fmtVersionComparator.compare(maxFormatterVersion, lower.getValue()) <= 0) {
                throw new IllegalArgumentException(String.format("%d/%s should be lower than %d/%s", minimumJvmVersion, maxFormatterVersion, lower.getKey(), lower.getValue()));
            }
            Map.Entry<Integer, V> higher = this.jvm2fmtVersion.higherEntry(minimumJvmVersion);
            if (null != higher && this.fmtVersionComparator.compare(maxFormatterVersion, higher.getValue()) >= 0) {
                throw new IllegalArgumentException(String.format("%d/%s should be higher than %d/%s", minimumJvmVersion, maxFormatterVersion, higher.getKey(), higher.getValue()));
            }
            return this;
        }

        @Nullable
        public V getRecommendedFormatterVersion() {
            Integer configuredJvmVersionOrNull = this.jvm2fmtVersion.floorKey(Jvm.version());
            return null == configuredJvmVersionOrNull ? null : (V)this.jvm2fmtVersion.get(configuredJvmVersionOrNull);
        }

        public void assertFormatterSupported(V formatterVersion) {
            Objects.requireNonNull(formatterVersion);
            String error = this.buildUnsupportedFormatterMessage(formatterVersion);
            if (!error.isEmpty()) {
                throw new IllegalArgumentException(error);
            }
        }

        private String buildUnsupportedFormatterMessage(V fmtVersion) {
            int requiredJvmVersion = this.getRequiredJvmVersion(fmtVersion);
            if (Jvm.version() < requiredJvmVersion) {
                return this.buildUpgradeJvmMessage(fmtVersion) + "Upgrade your JVM or try " + this.toString();
            }
            return "";
        }

        private String buildUpgradeJvmMessage(V fmtVersion) {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("You are running Spotless on JVM %d", Jvm.version()));
            V recommendedFmtVersionOrNull = this.getRecommendedFormatterVersion();
            if (null != recommendedFmtVersionOrNull) {
                builder.append(String.format(", which limits you to %s %s.%n", this.fmtName, recommendedFmtVersionOrNull));
            } else {
                Map.Entry<V, Integer> nextFmtVersionOrNull = this.fmt2jvmVersion.ceilingEntry(fmtVersion);
                if (null != nextFmtVersionOrNull) {
                    builder.append(String.format(". %s %s requires JVM %d+", this.fmtName, fmtVersion, nextFmtVersionOrNull.getValue()));
                }
                builder.append(String.format(".%n", new Object[0]));
            }
            return builder.toString();
        }

        private int getRequiredJvmVersion(V fmtVersion) {
            Object maxKnownFmtVersion;
            Map.Entry<V, Integer> entry = this.fmt2jvmVersion.ceilingEntry(fmtVersion);
            if (null == entry) {
                entry = this.fmt2jvmVersion.lastEntry();
            }
            if (null != entry && this.fmtVersionComparator.compare(fmtVersion, maxKnownFmtVersion = this.jvm2fmtVersion.get(entry.getValue())) <= 0) {
                return entry.getValue();
            }
            return 0;
        }

        public FormatterFunc suggestLaterVersionOnError(V formatterVersion, final FormatterFunc originalFunc) {
            Objects.requireNonNull(formatterVersion);
            Objects.requireNonNull(originalFunc);
            String hintUnsupportedProblem = this.buildUnsupportedFormatterMessage(formatterVersion);
            final String proposeDiffererntFormatter = hintUnsupportedProblem.isEmpty() ? this.buildUpgradeFormatterMessage(formatterVersion) : hintUnsupportedProblem;
            return proposeDiffererntFormatter.isEmpty() ? originalFunc : new FormatterFunc(){

                @Override
                public String apply(String unix, File file) throws Exception {
                    try {
                        return originalFunc.apply(unix, file);
                    }
                    catch (Exception e) {
                        throw new Exception(proposeDiffererntFormatter, e);
                    }
                }

                @Override
                public String apply(String input) throws Exception {
                    try {
                        return originalFunc.apply(input);
                    }
                    catch (Exception e) {
                        throw new Exception(proposeDiffererntFormatter, e);
                    }
                }
            };
        }

        private String buildUpgradeFormatterMessage(V fmtVersion) {
            StringBuilder builder = new StringBuilder();
            V recommendedFmtVersionOrNull = this.getRecommendedFormatterVersion();
            if (null != recommendedFmtVersionOrNull && this.fmtVersionComparator.compare(fmtVersion, recommendedFmtVersionOrNull) < 0) {
                builder.append(String.format("You are not using latest version on JVM %d+.%n", this.getRequiredJvmVersion(recommendedFmtVersionOrNull)));
                builder.append(String.format("Try to upgrade to %s %s, which may have fixed this problem.", this.fmtName, this.getRecommendedFormatterVersion()));
            } else {
                V higherFormatterVersionOrNull = this.fmt2jvmVersion.higherKey(fmtVersion);
                if (null != higherFormatterVersionOrNull) {
                    builder.append(this.buildUpgradeJvmMessage(fmtVersion));
                    Integer higherJvmVersion = (Integer)this.fmt2jvmVersion.get(higherFormatterVersionOrNull);
                    builder.append(String.format("If you upgrade your JVM to %d+, then you can use %s %s, which may have fixed this problem.", higherJvmVersion, this.fmtName, higherFormatterVersionOrNull));
                }
            }
            return builder.toString();
        }

        public String toString() {
            return String.format("%s alternatives:%n", this.fmtName) + this.jvm2fmtVersion.entrySet().stream().map(e -> String.format("- Version %s requires JVM %d+", e.getValue(), e.getKey())).collect(Collectors.joining(System.lineSeparator()));
        }

        @SuppressFBWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
        private static class SemanticVersionComparator<V>
        implements Comparator<V> {
            private SemanticVersionComparator() {
            }

            @Override
            public int compare(V version0, V version1) {
                Objects.requireNonNull(version0);
                Objects.requireNonNull(version1);
                int[] version0Items = SemanticVersionComparator.convert(version0);
                int[] version1Items = SemanticVersionComparator.convert(version1);
                int numberOfElements = version0Items.length > version1Items.length ? version0Items.length : version1Items.length;
                version0Items = Arrays.copyOf(version0Items, numberOfElements);
                version1Items = Arrays.copyOf(version1Items, numberOfElements);
                for (int i = 0; i < numberOfElements; ++i) {
                    if (version0Items[i] > version1Items[i]) {
                        return 1;
                    }
                    if (version1Items[i] <= version0Items[i]) continue;
                    return -1;
                }
                return 0;
            }

            private static <V> int[] convert(V versionObject) {
                try {
                    return Arrays.asList(versionObject.toString().split("\\.")).stream().mapToInt(s -> Integer.valueOf(s)).toArray();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Not a semantic version: %s", versionObject), e);
                }
            }
        }
    }
}

