/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.diktat.compat;

import com.diffplug.spotless.glue.diktat.compat.DiktatCompatAdapter;
import com.diffplug.spotless.glue.diktat.compat.DiktatReporting;
import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.RuleSet;
import com.pinterest.ktlint.core.api.EditorConfigOverride;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.cqfn.diktat.ruleset.rules.DiktatRuleSetProvider;

public class DiktatCompat1Dot2Dot5Adapter
implements DiktatCompatAdapter {
    private final List<RuleSet> ruleSets;
    private final Function2<? super LintError, ? super Boolean, Unit> formatterCallback;
    private final ArrayList<LintError> errors = new ArrayList();

    public DiktatCompat1Dot2Dot5Adapter(@Nullable File configFile) {
        if (configFile != null) {
            System.setProperty("diktat.config.path", configFile.getAbsolutePath());
        }
        this.ruleSets = Collections.singletonList(new DiktatRuleSetProvider().get());
        this.formatterCallback = new FormatterCallback(this.errors);
    }

    @Override
    public String format(File file, String content, boolean isScript) {
        this.errors.clear();
        String result = KtLint.INSTANCE.format(new KtLint.ExperimentalParams(file.getAbsolutePath(), content, this.ruleSets, Collections.emptyMap(), this.formatterCallback, isScript, null, false, new EditorConfigOverride(), false));
        DiktatReporting.reportIfRequired(this.errors, LintError::getLine, LintError::getCol, LintError::getDetail);
        return result;
    }

    static class FormatterCallback
    implements Function2<LintError, Boolean, Unit> {
        private final ArrayList<LintError> errors;

        FormatterCallback(ArrayList<LintError> errors) {
            this.errors = errors;
        }

        public Unit invoke(LintError lintError, Boolean corrected) {
            if (!corrected.booleanValue()) {
                this.errors.add(lintError);
            }
            return null;
        }
    }
}

