/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.gradle.versions.updates.gradle;

import com.github.benmanes.gradle.versions.updates.gradle.GradleUpdateChecker;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001bB'\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000H\u0096\u0002R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateResult;", "", "enabled", "", "running", "Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus$Available;", "release", "Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus;", "(ZLcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus$Available;Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus;)V", "isFailure", "()Z", "setFailure", "(Z)V", "isUpdateAvailable", "setUpdateAvailable", "reason", "", "getReason", "()Ljava/lang/String;", "setReason", "(Ljava/lang/String;)V", "version", "getVersion", "setVersion", "compareTo", "", "other", "Companion", "gradle-versions-plugin"})
public final class GradleUpdateResult
implements Comparable<GradleUpdateResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String version;
    private boolean isUpdateAvailable;
    private boolean isFailure;
    @NotNull
    private String reason;
    private static final Comparator<GradleUpdateResult> comparator = Comparator.comparing(GradleUpdateResult::comparator$lambda-0);

    public GradleUpdateResult(boolean enabled, @Nullable GradleUpdateChecker.ReleaseStatus.Available running, @Nullable GradleUpdateChecker.ReleaseStatus release) {
        if (!enabled) {
            this.version = "";
            this.isUpdateAvailable = false;
            this.isFailure = false;
            this.reason = "update check disabled";
        } else if (release instanceof GradleUpdateChecker.ReleaseStatus.Available) {
            String string = ((GradleUpdateChecker.ReleaseStatus.Available)release).getGradleVersion().getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"release.gradleVersion.version");
            this.version = string;
            GradleVersion gradleVersion = ((GradleUpdateChecker.ReleaseStatus.Available)release).getGradleVersion();
            GradleUpdateChecker.ReleaseStatus.Available available = running;
            Intrinsics.checkNotNull((Object)available);
            this.isUpdateAvailable = gradleVersion.compareTo(available.getGradleVersion()) > 0;
            this.isFailure = false;
            this.reason = "";
        } else if (release instanceof GradleUpdateChecker.ReleaseStatus.Unavailable) {
            this.version = "";
            this.isUpdateAvailable = false;
            this.isFailure = false;
            this.reason = "update check succeeded: no release available";
        } else if (release instanceof GradleUpdateChecker.ReleaseStatus.Failure) {
            this.version = "";
            this.isUpdateAvailable = false;
            this.isFailure = true;
            this.reason = ((GradleUpdateChecker.ReleaseStatus.Failure)release).getReason();
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("ReleaseStatus subtype [");
            GradleUpdateChecker.ReleaseStatus releaseStatus = release;
            Intrinsics.checkNotNull((Object)releaseStatus);
            throw new IllegalStateException(stringBuilder.append(releaseStatus.getClass()).append("] not yet implemented").toString());
        }
    }

    public /* synthetic */ GradleUpdateResult(boolean bl, GradleUpdateChecker.ReleaseStatus.Available available, GradleUpdateChecker.ReleaseStatus releaseStatus, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            available = null;
        }
        if ((n & 4) != 0) {
            releaseStatus = null;
        }
        this(bl, available, releaseStatus);
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.version = string;
    }

    public final boolean isUpdateAvailable() {
        return this.isUpdateAvailable;
    }

    public final void setUpdateAvailable(boolean bl) {
        this.isUpdateAvailable = bl;
    }

    public final boolean isFailure() {
        return this.isFailure;
    }

    public final void setFailure(boolean bl) {
        this.isFailure = bl;
    }

    @NotNull
    public final String getReason() {
        return this.reason;
    }

    public final void setReason(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.reason = string;
    }

    @Override
    public int compareTo(@NotNull GradleUpdateResult other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return comparator.compare(this, other);
    }

    private static final GradleVersion comparator$lambda-0(GradleUpdateResult gradleUpdateResult) {
        Intrinsics.checkNotNullParameter((Object)gradleUpdateResult, (String)"gradleUpdateResult");
        return GradleVersion.version((String)gradleUpdateResult.version);
    }

    public GradleUpdateResult() {
        this(false, null, null, 7, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateResult$Companion;", "", "()V", "comparator", "Ljava/util/Comparator;", "Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateResult;", "kotlin.jvm.PlatformType", "gradle-versions-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

