/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.gradle.versions.reporter;

import com.github.benmanes.gradle.versions.reporter.AbstractReporter;
import com.github.benmanes.gradle.versions.reporter.AbstractReporterKt;
import com.github.benmanes.gradle.versions.reporter.result.DependenciesGroup;
import com.github.benmanes.gradle.versions.reporter.result.Dependency;
import com.github.benmanes.gradle.versions.reporter.result.DependencyLatest;
import com.github.benmanes.gradle.versions.reporter.result.DependencyOutdated;
import com.github.benmanes.gradle.versions.reporter.result.DependencyUnresolved;
import com.github.benmanes.gradle.versions.reporter.result.Result;
import com.github.benmanes.gradle.versions.reporter.result.VersionAvailable;
import com.github.benmanes.gradle.versions.updates.gradle.GradleReleaseChannel;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 !2\u00020\u0001:\u0001!B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\""}, d2={"Lcom/github/benmanes/gradle/versions/reporter/HtmlReporter;", "Lcom/github/benmanes/gradle/versions/reporter/AbstractReporter;", "project", "Lorg/gradle/api/Project;", "revision", "", "gradleReleaseChannel", "(Lorg/gradle/api/Project;Ljava/lang/String;Ljava/lang/String;)V", "getGradleReleaseChannel", "()Ljava/lang/String;", "getProject", "()Lorg/gradle/api/Project;", "getRevision", "getDisplayableVersion", "versionAvailable", "Lcom/github/benmanes/gradle/versions/reporter/result/VersionAvailable;", "getFileExtension", "getUpgradesRows", "", "result", "Lcom/github/benmanes/gradle/versions/reporter/result/Result;", "write", "", "printStream", "Ljava/io/OutputStream;", "writeBody", "writeExceedLatestFound", "writeGradleUpdates", "writeHeader", "writeUndeclared", "writeUnresolved", "writeUpToDate", "writeUpgrades", "Companion", "gradle-versions-plugin"})
public final class HtmlReporter
extends AbstractReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String revision;
    @NotNull
    private final String gradleReleaseChannel;
    @NotNull
    private static final String header = "\n    <head>\n    <title>Project Dependency Updates Report</title>\n    <style>\n       .body {\n           font:100% verdana, arial, sans-serif;\n           background-color:#fff\n       }\n       .currentInfo {\n           border-collapse: collapse;\n       }\n       .currentInfo header {\n           cursor:pointer;\n           padding: 12px 15px;\n       }\n       .currentInfo td {\n           border: 1px solid black;\n           padding: 12px 15px;\n           border-collapse: collapse;\n       }\n       .currentInfo tr:nth-child(even) {\n           background-color: #E4FFB7;\n           padding: 12px 15px;\n           border-collapse: collapse;\n       }\n       .currentInfo tr:nth-child(odd) {\n           background-color: #EFFFD2;\n           padding: 12px 15px;\n           border-collapse: collapse;\n       }\n       .warningInfo {\n           border-collapse: collapse;\n       }\n       .warningInfo header {\n           cursor:pointer;\n           padding: 12px 15px;\n       }\n       .warningInfo td {\n           border: 1px solid black;\n           padding: 12px 15px;\n           border-collapse: collapse;\n       }\n       .warningInfo tr:nth-child(even) {\n           background-color: #FFFF66;\n           padding: 12px 15px;\n           border-collapse: collapse;\n       }\n       .warningInfo tr:nth-child(odd) {\n           background-color: #FFFFCC;\n           padding: 12px 15px;\n           border-collapse: collapse;\n       }\n   </style>\n   <script src=\"https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js\"></script>\n   <script>\n   $(document).ready(function(){\n    /* set current to collapsed initially */\n    $('#currentId').nextUntil('tr.header').slideToggle(100, function(){});\n    /* click callback to toggle tables */\n    $('tr.header').click(function(){\n        $(this).find('span').text(function(_, value){return value=='(Click to collapse)'?'(Click to expand)':'(Click to collapse)'});\n        $(this).nextUntil('tr.header').slideToggle(100, function(){\n        });\n    });\n   });\n   </script>\n   </head>\n   ";

    public HtmlReporter(@NotNull Project project, @NotNull String revision, @NotNull String gradleReleaseChannel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        Intrinsics.checkNotNullParameter((Object)gradleReleaseChannel, (String)"gradleReleaseChannel");
        super(project, revision, gradleReleaseChannel);
        this.project = project;
        this.revision = revision;
        this.gradleReleaseChannel = gradleReleaseChannel;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getRevision() {
        return this.revision;
    }

    @Override
    @NotNull
    public String getGradleReleaseChannel() {
        return this.gradleReleaseChannel;
    }

    @Override
    public void write(@NotNull OutputStream printStream, @NotNull Result result) {
        Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        AbstractReporterKt.println(printStream, "<!doctype html>");
        AbstractReporterKt.println(printStream, "<html lang=\"en\">");
        this.writeHeader(printStream);
        this.writeBody(printStream, result);
        AbstractReporterKt.println(printStream, "</html>");
    }

    private final void writeHeader(OutputStream printStream) {
        AbstractReporterKt.println(printStream, "    <head>\n    <title>Project Dependency Updates Report</title>\n    <style>\n       .body {\n           font:100% verdana, arial, sans-serif;\n           background-color:#fff\n       }\n       .currentInfo {\n           border-collapse: collapse;\n       }\n       .currentInfo header {\n           cursor:pointer;\n           padding: 12px 15px;\n       }\n       .currentInfo td {\n           border: 1px solid black;\n           padding: 12px 15px;\n           border-collapse: collapse;\n       }\n       .currentInfo tr:nth-child(even) {\n           background-color: #E4FFB7;\n           padding: 12px 15px;\n           border-collapse: collapse;\n       }\n       .currentInfo tr:nth-child(odd) {\n           background-color: #EFFFD2;\n           padding: 12px 15px;\n           border-collapse: collapse;\n       }\n       .warningInfo {\n           border-collapse: collapse;\n       }\n       .warningInfo header {\n           cursor:pointer;\n           padding: 12px 15px;\n       }\n       .warningInfo td {\n           border: 1px solid black;\n           padding: 12px 15px;\n           border-collapse: collapse;\n       }\n       .warningInfo tr:nth-child(even) {\n           background-color: #FFFF66;\n           padding: 12px 15px;\n           border-collapse: collapse;\n       }\n       .warningInfo tr:nth-child(odd) {\n           background-color: #FFFFCC;\n           padding: 12px 15px;\n           border-collapse: collapse;\n       }\n   </style>\n   <script src=\"https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js\"></script>\n   <script>\n   $(document).ready(function(){\n    /* set current to collapsed initially */\n    $('#currentId').nextUntil('tr.header').slideToggle(100, function(){});\n    /* click callback to toggle tables */\n    $('tr.header').click(function(){\n        $(this).find('span').text(function(_, value){return value=='(Click to collapse)'?'(Click to expand)':'(Click to collapse)'});\n        $(this).nextUntil('tr.header').slideToggle(100, function(){\n        });\n    });\n   });\n   </script>\n   </head>");
    }

    private final void writeBody(OutputStream printStream, Result result) {
        AbstractReporterKt.println(printStream, "<body>");
        if (result.getCount() == 0) {
            AbstractReporterKt.println(printStream, "<p>No dependencies found.</p>");
        } else {
            this.writeUpToDate(printStream, result);
            this.writeExceedLatestFound(printStream, result);
            this.writeUpgrades(printStream, result);
            this.writeUndeclared(printStream, result);
            this.writeUnresolved(printStream, result);
        }
        this.writeGradleUpdates(printStream, result);
        AbstractReporterKt.println(printStream, "</body>");
    }

    private final void writeUpToDate(OutputStream printStream, Result result) {
        Set<Dependency> versions = result.getCurrent().getDependencies();
        if (!((Collection)versions).isEmpty()) {
            AbstractReporterKt.println(printStream, "<h2>Current dependencies</h2>");
            AbstractReporterKt.println(printStream, "<p>The following dependencies are using the latest " + this.getRevision() + " version:<p>");
            AbstractReporterKt.println(printStream, "<table class=\"currentInfo\">");
            for (String it : HtmlReporter.Companion.getCurrentRows(result)) {
                AbstractReporterKt.println(printStream, it);
            }
            AbstractReporterKt.println(printStream, "</table>");
            AbstractReporterKt.println(printStream, "<br>");
        }
    }

    private final void writeExceedLatestFound(OutputStream printStream, Result result) {
        Set<DependencyLatest> versions = result.getExceeded().getDependencies();
        if (!((Collection)versions).isEmpty()) {
            AbstractReporterKt.println(printStream, "<h2>Exceeded dependencies</h2>");
            AbstractReporterKt.println(printStream, "<p>The following dependencies exceed the version found at the " + this.getRevision() + " revision level:<p>");
            AbstractReporterKt.println(printStream, "<table class=\"warningInfo\">");
            for (String it : HtmlReporter.Companion.getExceededRows(result)) {
                AbstractReporterKt.println(printStream, it);
            }
            AbstractReporterKt.println(printStream, "</table>");
            AbstractReporterKt.println(printStream, "<br>");
        }
    }

    private final void writeUpgrades(OutputStream printStream, Result result) {
        Set<DependencyOutdated> versions = result.getOutdated().getDependencies();
        if (!((Collection)versions).isEmpty()) {
            AbstractReporterKt.println(printStream, "<h2>Later dependencies</h2>");
            AbstractReporterKt.println(printStream, "<p>The following dependencies have later " + this.getRevision() + " versions:<p>");
            AbstractReporterKt.println(printStream, "<table class=\"warningInfo\">");
            for (String it : this.getUpgradesRows(result)) {
                AbstractReporterKt.println(printStream, it);
            }
            AbstractReporterKt.println(printStream, "</table>");
            AbstractReporterKt.println(printStream, "<br>");
        }
    }

    private final void writeUndeclared(OutputStream printStream, Result result) {
        Set<Dependency> versions = result.getUndeclared().getDependencies();
        if (!((Collection)versions).isEmpty()) {
            AbstractReporterKt.println(printStream, "<h2>Undeclared dependencies</h2>");
            AbstractReporterKt.println(printStream, "<p>Failed to compare versions for the following dependencies because they were declared without version:<p>");
            AbstractReporterKt.println(printStream, "<table class=\"warningInfo\">");
            for (String row : HtmlReporter.Companion.getUndeclaredRows(result)) {
                AbstractReporterKt.println(printStream, row);
            }
            AbstractReporterKt.println(printStream, "</table>");
            AbstractReporterKt.println(printStream, "<br>");
        }
    }

    private final void writeUnresolved(OutputStream printStream, Result result) {
        Set<DependencyUnresolved> versions = result.getUnresolved().getDependencies();
        if (!((Collection)versions).isEmpty()) {
            AbstractReporterKt.println(printStream, "<h2>Unresolved dependencies</h2>");
            AbstractReporterKt.println(printStream, "<p>Failed to determine the latest version for the following dependencies:<p>");
            AbstractReporterKt.println(printStream, "<table class=\"warningInfo\">");
            for (String it : HtmlReporter.Companion.getUnresolvedRows(result)) {
                AbstractReporterKt.println(printStream, it);
            }
            AbstractReporterKt.println(printStream, "</table>");
            AbstractReporterKt.println(printStream, "<br>");
        }
    }

    private final void writeGradleUpdates(OutputStream printStream, Result result) {
        if (!result.getGradle().getEnabled()) {
            return;
        }
        AbstractReporterKt.println(printStream, "<h2>Gradle " + this.getGradleReleaseChannel() + " updates</h2>");
        AbstractReporterKt.println(printStream, "Gradle " + this.getGradleReleaseChannel() + " updates:");
        if (result.getGradle().getCurrent().isFailure()) {
            AbstractReporterKt.println(printStream, "<p>[ERROR] [release channel: " + GradleReleaseChannel.CURRENT.getId() + "] " + result.getGradle().getCurrent().getReason() + "</p>");
        }
        if ((Intrinsics.areEqual((Object)this.getGradleReleaseChannel(), (Object)GradleReleaseChannel.RELEASE_CANDIDATE.getId()) || Intrinsics.areEqual((Object)this.getGradleReleaseChannel(), (Object)GradleReleaseChannel.NIGHTLY.getId())) && result.getGradle().getReleaseCandidate().isFailure()) {
            AbstractReporterKt.println(printStream, "<p>[ERROR] [release channel: " + GradleReleaseChannel.RELEASE_CANDIDATE.getId() + "] " + result.getGradle().getReleaseCandidate().getReason() + "</p>");
        }
        if (Intrinsics.areEqual((Object)this.getGradleReleaseChannel(), (Object)GradleReleaseChannel.NIGHTLY.getId()) && result.getGradle().getNightly().isFailure()) {
            AbstractReporterKt.println(printStream, "<p>[ERROR] [release channel: " + GradleReleaseChannel.NIGHTLY.getId() + "] " + result.getGradle().getNightly().getReason() + "</p>");
        }
        AbstractReporterKt.print(printStream, "<p>Gradle: [" + HtmlReporter.Companion.getGradleVersionUrl(result.getGradle().getRunning().getVersion()));
        boolean updatePrinted = false;
        if (result.getGradle().getCurrent().isUpdateAvailable() && result.getGradle().getCurrent().compareTo(result.getGradle().getRunning()) > 0) {
            updatePrinted = true;
            AbstractReporterKt.print(printStream, " -> " + HtmlReporter.Companion.getGradleVersionUrl(result.getGradle().getCurrent().getVersion()));
        }
        if ((Intrinsics.areEqual((Object)this.getGradleReleaseChannel(), (Object)GradleReleaseChannel.RELEASE_CANDIDATE.getId()) || Intrinsics.areEqual((Object)this.getGradleReleaseChannel(), (Object)GradleReleaseChannel.NIGHTLY.getId())) && result.getGradle().getReleaseCandidate().isUpdateAvailable() && result.getGradle().getReleaseCandidate().compareTo(result.getGradle().getCurrent()) > 0) {
            updatePrinted = true;
            AbstractReporterKt.print(printStream, " -> " + HtmlReporter.Companion.getGradleVersionUrl(result.getGradle().getReleaseCandidate().getVersion()));
        }
        if (Intrinsics.areEqual((Object)this.getGradleReleaseChannel(), (Object)GradleReleaseChannel.NIGHTLY.getId()) && result.getGradle().getNightly().isUpdateAvailable() && result.getGradle().getNightly().compareTo(result.getGradle().getCurrent()) > 0) {
            updatePrinted = true;
            AbstractReporterKt.print(printStream, " -> " + HtmlReporter.Companion.getGradleVersionUrl(result.getGradle().getNightly().getVersion()));
        }
        if (!updatePrinted) {
            AbstractReporterKt.print(printStream, ": UP-TO-DATE");
        }
        AbstractReporterKt.println(printStream, "]</p>");
        AbstractReporterKt.println(printStream, HtmlReporter.Companion.getGradleUrl());
    }

    private final List<String> getUpgradesRows(Result result) {
        List rows = new ArrayList();
        DependenciesGroup<DependencyOutdated> list = result.getOutdated();
        rows.add("<tr class=\"header\"><th colspan=\"5\"><b>Later dependencies<span>(Click to collapse)</span></b></th></tr>");
        rows.add("<tr><td><b>Name</b></td><td><b>Group</b></td><td><b>URL</b></td><td><b>Current Version</b></td><td><b>Latest Version</b></td><td><b>Reason</b></td></tr>");
        for (DependencyOutdated dependency : list.getDependencies()) {
            String rowString;
            String string;
            String string2;
            String string3;
            String rowStringFmt = "<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>";
            Object[] objectArray = new Object[6];
            Object object = dependency.getName();
            if (object == null) {
                object = objectArray[0] = "";
            }
            if ((string3 = dependency.getGroup()) == null) {
                string3 = "";
            }
            objectArray[1] = string3;
            objectArray[2] = HtmlReporter.Companion.getUrlString(dependency.getProjectUrl());
            String string4 = dependency.getGroup();
            if (string4 == null) {
                string4 = "";
            }
            if ((string2 = dependency.getName()) == null) {
                string2 = "";
            }
            objectArray[3] = HtmlReporter.Companion.getVersionString(string4, string2, dependency.getVersion());
            String string5 = dependency.getGroup();
            if (string5 == null) {
                string5 = "";
            }
            if ((string = dependency.getName()) == null) {
                string = "";
            }
            objectArray[4] = HtmlReporter.Companion.getVersionString(string5, string, this.getDisplayableVersion(dependency.getAvailable()));
            String string6 = dependency.getUserReason();
            if (string6 == null) {
                string6 = "";
            }
            objectArray[5] = string6;
            Intrinsics.checkNotNullExpressionValue((Object)String.format(rowStringFmt, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(format, *args)");
            rows.add(rowString);
        }
        return rows;
    }

    private final String getDisplayableVersion(VersionAvailable versionAvailable) {
        if (StringsKt.equals((String)this.getRevision(), (String)"milestone", (boolean)true)) {
            return versionAvailable.getMilestone();
        }
        if (StringsKt.equals((String)this.getRevision(), (String)"release", (boolean)true)) {
            return versionAvailable.getRelease();
        }
        if (StringsKt.equals((String)this.getRevision(), (String)"integration", (boolean)true)) {
            return versionAvailable.getIntegration();
        }
        return "";
    }

    @Override
    @NotNull
    public String getFileExtension() {
        return "html";
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\u0004H\u0002J\u0012\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0002J\"\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0012\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0002J\"\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/benmanes/gradle/versions/reporter/HtmlReporter$Companion;", "", "()V", "header", "", "getCurrentRows", "", "result", "Lcom/github/benmanes/gradle/versions/reporter/result/Result;", "getExceededRows", "getGradleUrl", "getGradleVersionUrl", "version", "getMvnVersionString", "group", "name", "getUndeclaredRows", "getUnresolvedRows", "getUrlString", "url", "getVersionString", "gradle-versions-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final List<String> getCurrentRows(Result result) {
            List rows = new ArrayList();
            DependenciesGroup<Dependency> list = result.getCurrent();
            rows.add("<tr class=\"header\" id = \"currentId\" ><th colspan=\"4\"><b>Current dependencies<span>(Click to expand)</span></b></th></tr>");
            rows.add("<tr><td><b>Name</b></td><td><b>Group</b></td><td><b>URL</b></td><td><b>Current Version</b></td><td><b>Reason</b></td></tr>");
            for (Dependency dependency : list.getDependencies()) {
                String rowString;
                String string;
                String rowStringFmt = "<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>";
                Object[] objectArray = new Object[5];
                objectArray[0] = dependency.getName();
                objectArray[1] = dependency.getGroup();
                objectArray[2] = this.getUrlString(dependency.getProjectUrl());
                String string2 = dependency.getGroup();
                if (string2 == null) {
                    string2 = "";
                }
                if ((string = dependency.getName()) == null) {
                    string = "";
                }
                objectArray[3] = this.getVersionString(string2, string, dependency.getVersion());
                String string3 = dependency.getUserReason();
                if (string3 == null) {
                    string3 = "";
                }
                objectArray[4] = string3;
                Intrinsics.checkNotNullExpressionValue((Object)String.format(rowStringFmt, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(format, *args)");
                rows.add(rowString);
            }
            return rows;
        }

        private final List<String> getExceededRows(Result result) {
            List rows = new ArrayList();
            DependenciesGroup<DependencyLatest> list = result.getExceeded();
            rows.add("<tr class=\"header\"><th colspan=\"5\"><b>Exceeded dependencies<span>(Click to collapse)</span></b></th></tr>");
            rows.add("<tr><td><b>Name</b></td><td><b>Group</b></td><td><b>URL</b></td><td><b>Current Version</b></td><td><b>Latest Version</b></td><td><b>Reason</b></td></tr>");
            for (DependencyLatest dependency : list.getDependencies()) {
                String rowString;
                String string;
                String string2;
                String rowStringFmt = "<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>";
                Object[] objectArray = new Object[6];
                objectArray[0] = dependency.getName();
                objectArray[1] = dependency.getGroup();
                objectArray[2] = this.getUrlString(dependency.getProjectUrl());
                String string3 = dependency.getGroup();
                if (string3 == null) {
                    string3 = "";
                }
                if ((string2 = dependency.getName()) == null) {
                    string2 = "";
                }
                objectArray[3] = this.getVersionString(string3, string2, dependency.getVersion());
                String string4 = dependency.getGroup();
                if (string4 == null) {
                    string4 = "";
                }
                if ((string = dependency.getName()) == null) {
                    string = "";
                }
                objectArray[4] = this.getVersionString(string4, string, dependency.getVersion());
                String string5 = dependency.getUserReason();
                if (string5 == null) {
                    string5 = "";
                }
                objectArray[5] = string5;
                Intrinsics.checkNotNullExpressionValue((Object)String.format(rowStringFmt, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(format, *args)");
                rows.add(rowString);
            }
            return rows;
        }

        private final List<String> getUndeclaredRows(Result result) {
            List rows = new ArrayList();
            rows.add("<tr class=\"header\"><th colspan=\"2\"><b>Undeclared dependencies<span>(Click to collapse)</span></b></th></tr>");
            rows.add("<tr><td><b>Name</b></td><td><b>Group</b></td></tr>");
            for (Dependency dependency : result.getUndeclared().getDependencies()) {
                String rowString;
                String string = "<tr><td>%s</td><td>%s</td></tr>";
                Object[] objectArray = new Object[]{dependency.getName(), dependency.getGroup()};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(format, *args)");
                rows.add(rowString);
            }
            return rows;
        }

        private final List<String> getUnresolvedRows(Result result) {
            List rows = new ArrayList();
            DependenciesGroup<DependencyUnresolved> list = result.getUnresolved();
            rows.add("<tr class=\"header\"><th colspan=\"4\"><b>Unresolved dependencies<span>(Click to collapse)</span></b></th></tr>");
            rows.add("<tr><td><b>Name</b></td><td><b>Group</b></td><td><b>URL</b></td><td><b>Current Version</b></td><td>Reason</td></tr>");
            for (DependencyUnresolved dependency : list.getDependencies()) {
                String rowString;
                String string;
                String rowStringFmt = "<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>";
                Object[] objectArray = new Object[5];
                objectArray[0] = dependency.getName();
                objectArray[1] = dependency.getGroup();
                objectArray[2] = this.getUrlString(dependency.getProjectUrl());
                String string2 = dependency.getGroup();
                if (string2 == null) {
                    string2 = "";
                }
                if ((string = dependency.getName()) == null) {
                    string = "";
                }
                objectArray[3] = this.getVersionString(string2, string, dependency.getVersion());
                String string3 = dependency.getUserReason();
                if (string3 == null) {
                    string3 = "";
                }
                objectArray[4] = string3;
                Intrinsics.checkNotNullExpressionValue((Object)String.format(rowStringFmt, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(format, *args)");
                rows.add(rowString);
            }
            return rows;
        }

        private final String getGradleUrl() {
            return "<p>For information about Gradle releases click <a target=\"_blank\" href=\"https://gradle.org/releases/\">here</a>.</p>";
        }

        private final String getGradleVersionUrl(String version) {
            if (version == null) {
                return "https://gradle.org/releases/";
            }
            String string = "<a target=\"_blank\" href=\"https://docs.gradle.org/%s/release-notes.html\">%s</a>";
            Object[] objectArray = new Object[]{version, version};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return string2;
        }

        private final String getUrlString(String url) {
            if (url == null) {
                return "";
            }
            String string = "<a target=\"_blank\" href=\"%s\">%s</a>";
            Object[] objectArray = new Object[]{url, url};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return string2;
        }

        private final String getVersionString(String group, String name, String version) {
            String mvn = this.getMvnVersionString(group, name, version);
            String string = "%s %s";
            Object[] objectArray = new Object[]{version, mvn};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return string2;
        }

        private final String getMvnVersionString(String group, String name, String version) {
            if (version == null) {
                return "";
            }
            String string = "https://central.sonatype.com/artifact/%s/%s/%s/bundle";
            Object[] objectArray = new Object[]{group, name, version};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            String versionUrl = string2;
            string = "<a target=\"_blank\" href=\"%s\">%s</a>";
            objectArray = new Object[]{versionUrl, "Sonatype"};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            return string3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

