/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.gradle.versions.updates.gradle;

import com.github.benmanes.gradle.versions.updates.gradle.GradleUpdateChecker;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001cB)\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0000H\u0096\u0002R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateResult;", "", "enabled", "", "running", "Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus$Available;", "release", "Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus;", "<init>", "(ZLcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus$Available;Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus;)V", "version", "", "getVersion", "()Ljava/lang/String;", "setVersion", "(Ljava/lang/String;)V", "isUpdateAvailable", "()Z", "setUpdateAvailable", "(Z)V", "isFailure", "setFailure", "reason", "getReason", "setReason", "compareTo", "", "other", "Companion", "gradle-versions-plugin"})
public final class GradleUpdateResult
implements Comparable<GradleUpdateResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String version;
    private boolean isUpdateAvailable;
    private boolean isFailure;
    @NotNull
    private String reason;
    private static final Comparator<GradleUpdateResult> comparator = Comparator.comparing(arg_0 -> GradleUpdateResult.comparator$lambda$1(GradleUpdateResult::comparator$lambda$0, arg_0));

    public GradleUpdateResult(boolean enabled, @Nullable GradleUpdateChecker.ReleaseStatus.Available running, @Nullable GradleUpdateChecker.ReleaseStatus release) {
        if (!enabled) {
            this.version = "";
            this.isUpdateAvailable = false;
            this.isFailure = false;
            this.reason = "update check disabled";
        } else if (release instanceof GradleUpdateChecker.ReleaseStatus.Available) {
            this.version = ((GradleUpdateChecker.ReleaseStatus.Available)release).getGradleVersion().getVersion();
            GradleVersion gradleVersion = ((GradleUpdateChecker.ReleaseStatus.Available)release).getGradleVersion();
            GradleUpdateChecker.ReleaseStatus.Available available = running;
            Intrinsics.checkNotNull((Object)available);
            this.isUpdateAvailable = gradleVersion.compareTo(available.getGradleVersion()) > 0;
            this.isFailure = false;
            this.reason = "";
        } else if (release instanceof GradleUpdateChecker.ReleaseStatus.Unavailable) {
            this.version = "";
            this.isUpdateAvailable = false;
            this.isFailure = false;
            this.reason = "update check succeeded: no release available";
        } else if (release instanceof GradleUpdateChecker.ReleaseStatus.Failure) {
            this.version = "";
            this.isUpdateAvailable = false;
            this.isFailure = true;
            this.reason = ((GradleUpdateChecker.ReleaseStatus.Failure)release).getReason();
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("ReleaseStatus subtype [");
            GradleUpdateChecker.ReleaseStatus releaseStatus = release;
            Intrinsics.checkNotNull((Object)releaseStatus);
            throw new IllegalStateException(stringBuilder.append(releaseStatus.getClass()).append("] not yet implemented").toString());
        }
    }

    public /* synthetic */ GradleUpdateResult(boolean bl, GradleUpdateChecker.ReleaseStatus.Available available, GradleUpdateChecker.ReleaseStatus releaseStatus, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            available = null;
        }
        if ((n & 4) != 0) {
            releaseStatus = null;
        }
        this(bl, available, releaseStatus);
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.version = string;
    }

    public final boolean isUpdateAvailable() {
        return this.isUpdateAvailable;
    }

    public final void setUpdateAvailable(boolean bl) {
        this.isUpdateAvailable = bl;
    }

    public final boolean isFailure() {
        return this.isFailure;
    }

    public final void setFailure(boolean bl) {
        this.isFailure = bl;
    }

    @NotNull
    public final String getReason() {
        return this.reason;
    }

    public final void setReason(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.reason = string;
    }

    @Override
    public int compareTo(@NotNull GradleUpdateResult other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return comparator.compare(this, other);
    }

    private static final GradleVersion comparator$lambda$0(GradleUpdateResult gradleUpdateResult) {
        Intrinsics.checkNotNullParameter((Object)gradleUpdateResult, (String)"gradleUpdateResult");
        return GradleVersion.version((String)gradleUpdateResult.version);
    }

    private static final GradleVersion comparator$lambda$1(Function1 $tmp0, Object p0) {
        return (GradleVersion)$tmp0.invoke(p0);
    }

    public GradleUpdateResult() {
        this(false, null, null, 7, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R4\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateResult$Companion;", "", "<init>", "()V", "comparator", "Ljava/util/Comparator;", "Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateResult;", "kotlin.jvm.PlatformType", "Ljava/util/Comparator;", "gradle-versions-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

