/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.gradle.versions.updates;

import com.github.benmanes.gradle.versions.updates.Coordinate;
import com.github.benmanes.gradle.versions.updates.DependencyStatus;
import com.github.benmanes.gradle.versions.updates.resolutionstrategy.ResolutionStrategyWithCurrent;
import groovy.xml.XmlSlurper;
import groovy.xml.slurpersupport.GPathResult;
import groovy.xml.slurpersupport.NodeChildren;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KCallable;
import kotlin.text.StringsKt;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.artifacts.ComponentSelection;
import org.gradle.api.artifacts.ComponentSelectionRules;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencyConstraintSet;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.query.ArtifactResolutionQuery;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.result.ArtifactResolutionResult;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependencyConstraint;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.maven.MavenModule;
import org.gradle.maven.MavenPomArtifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 ;2\u00020\u0001:\u0001;B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J>\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0010H\u0002J,\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J6\u0010(\u001a\u00020'2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030*2\u0014\b\u0002\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\b0-H\u0002J\u0018\u0010.\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010/\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018H\u0002J\u001c\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u00101\u001a\u00020'H\u0002J\u0010\u00102\u001a\u00020'2\u0006\u00103\u001a\u000204H\u0002J\u0012\u00105\u001a\u0004\u0018\u00010\u00152\u0006\u00106\u001a\u00020\rH\u0002J\u0012\u00107\u001a\u0004\u0018\u00010\u00152\u0006\u00106\u001a\u00020\rH\u0002J\u0010\u00108\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u001a0:2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/github/benmanes/gradle/versions/updates/Resolver;", "", "project", "Lorg/gradle/api/Project;", "resolutionStrategy", "Lorg/gradle/api/Action;", "Lcom/github/benmanes/gradle/versions/updates/resolutionstrategy/ResolutionStrategyWithCurrent;", "checkConstraints", "", "<init>", "(Lorg/gradle/api/Project;Lorg/gradle/api/Action;Z)V", "projectUrls", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/gradle/api/artifacts/ModuleVersionIdentifier;", "Lcom/github/benmanes/gradle/versions/updates/Resolver$Companion$ProjectUrl;", "resolve", "", "Lcom/github/benmanes/gradle/versions/updates/DependencyStatus;", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "revision", "", "getStatus", "coordinates", "", "Lcom/github/benmanes/gradle/versions/updates/Coordinate$Key;", "Lcom/github/benmanes/gradle/versions/updates/Coordinate;", "resolved", "Lorg/gradle/api/artifacts/ResolvedDependency;", "unresolved", "Lorg/gradle/api/artifacts/UnresolvedDependency;", "createLatestConfiguration", "currentCoordinates", "createQueryDependency", "Lorg/gradle/api/artifacts/Dependency;", "dependency", "Lorg/gradle/api/artifacts/ModuleDependency;", "Lorg/gradle/api/artifacts/DependencyConstraint;", "disableAutoTargetJvm", "", "addAttributes", "target", "Lorg/gradle/api/attributes/HasConfigurableAttributes;", "source", "filter", "Lkotlin/Function1;", "addRevisionFilter", "addCustomResolutionStrategy", "getCurrentCoordinates", "logRepositories", "logRepository", "repository", "Lorg/gradle/api/artifacts/repositories/ArtifactRepository;", "getProjectUrl", "id", "resolveProjectUrl", "supportsConstraints", "getResolvableDependencies", "", "Companion", "gradle-versions-plugin"})
@SourceDebugExtension(value={"SMAP\nResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Resolver.kt\ncom/github/benmanes/gradle/versions/updates/Resolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,466:1\n800#2,11:467\n1620#2,3:478\n800#2,11:481\n766#2:492\n857#2,2:493\n1194#2,2:495\n1222#2,4:497\n1747#2,3:501\n1360#2:505\n1446#2,5:506\n766#2:511\n857#2,2:512\n1620#2,3:514\n1855#2,2:517\n1747#2,3:519\n1#3:504\n*S KotlinDebug\n*F\n+ 1 Resolver.kt\ncom/github/benmanes/gradle/versions/updates/Resolver\n*L\n96#1:467,11\n97#1:478,3\n130#1:481,11\n131#1:492\n131#1:493,2\n267#1:495,2\n267#1:497,4\n273#1:501,3\n326#1:505\n326#1:506,5\n425#1:511\n425#1:512,2\n426#1:514,3\n431#1:517,2\n245#1:519,3\n*E\n"})
public final class Resolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final Action<? super ResolutionStrategyWithCurrent> resolutionStrategy;
    private final boolean checkConstraints;
    @NotNull
    private ConcurrentHashMap<ModuleVersionIdentifier, Companion.ProjectUrl> projectUrls;

    public Resolver(@NotNull Project project, @Nullable Action<? super ResolutionStrategyWithCurrent> resolutionStrategy, boolean checkConstraints) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.resolutionStrategy = resolutionStrategy;
        this.checkConstraints = checkConstraints;
        this.projectUrls = new ConcurrentHashMap();
        this.logRepositories();
    }

    @NotNull
    public final Set<DependencyStatus> resolve(@NotNull Configuration configuration, @NotNull String revision) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        Map<Coordinate.Key, Coordinate> coordinates = this.getCurrentCoordinates(configuration);
        Configuration latestConfiguration = this.createLatestConfiguration(configuration, revision, coordinates);
        LenientConfiguration lenient = latestConfiguration.getResolvedConfiguration().getLenientConfiguration();
        Set resolved = lenient.getFirstLevelModuleDependencies();
        Set unresolved = lenient.getUnresolvedModuleDependencies();
        Intrinsics.checkNotNull((Object)resolved);
        Intrinsics.checkNotNull((Object)unresolved);
        return this.getStatus(coordinates, resolved, unresolved);
    }

    private final Set<DependencyStatus> getStatus(Map<Coordinate.Key, Coordinate> coordinates, Set<? extends ResolvedDependency> resolved, Set<? extends UnresolvedDependency> unresolved) {
        Coordinate coord;
        Coordinate originalCoordinate;
        Coordinate resolvedCoordinate;
        HashSet<DependencyStatus> result = new HashSet<DependencyStatus>();
        for (ResolvedDependency resolvedDependency : resolved) {
            ModuleVersionIdentifier moduleVersionIdentifier = resolvedDependency.getModule().getId();
            Intrinsics.checkNotNullExpressionValue((Object)moduleVersionIdentifier, (String)"getId(...)");
            resolvedCoordinate = Coordinate.Companion.from(moduleVersionIdentifier);
            originalCoordinate = coordinates.get(resolvedCoordinate.getKey());
            Coordinate coordinate = originalCoordinate;
            if (coordinate == null) {
                coordinate = resolvedCoordinate;
            }
            coord = coordinate;
            ModuleVersionIdentifier moduleVersionIdentifier2 = resolvedDependency.getModule().getId();
            Intrinsics.checkNotNullExpressionValue((Object)moduleVersionIdentifier2, (String)"getId(...)");
            String projectUrl = this.getProjectUrl(moduleVersionIdentifier2);
            result.add(new DependencyStatus(coord, resolvedCoordinate.getVersion(), projectUrl));
        }
        for (UnresolvedDependency unresolvedDependency : unresolved) {
            ModuleVersionSelector moduleVersionSelector = unresolvedDependency.getSelector();
            Intrinsics.checkNotNullExpressionValue((Object)moduleVersionSelector, (String)"getSelector(...)");
            resolvedCoordinate = Coordinate.Companion.from(moduleVersionSelector);
            originalCoordinate = coordinates.get(resolvedCoordinate.getKey());
            Coordinate coordinate = originalCoordinate;
            if (coordinate == null) {
                coordinate = resolvedCoordinate;
            }
            coord = coordinate;
            result.add(new DependencyStatus(coord, unresolvedDependency));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Configuration createLatestConfiguration(Configuration configuration, String revision, Map<Coordinate.Key, Coordinate> currentCoordinates) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Configuration copy;
        void dependency;
        void destination$iv;
        Iterator $this$mapTo$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Iterable $this$filterIsInstance$iv2;
        DependencySet dependencySet = configuration.getAllDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"getAllDependencies(...)");
        Iterable iterable = (Iterable)dependencySet;
        boolean $i$f$filterIsInstance22 = false;
        void var7_7 = $this$filterIsInstance$iv2;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof ExternalDependency)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv2 = (List)destination$iv$iv;
        Collection $i$f$filterIsInstance22 = new ArrayList();
        boolean $i$f$mapTo = false;
        destination$iv$iv = $this$mapTo$iv.iterator();
        while (destination$iv$iv.hasNext()) {
            Object item$iv = destination$iv$iv.next();
            ExternalDependency externalDependency = (ExternalDependency)item$iv;
            void var17_18 = destination$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)dependency, (String)"null cannot be cast to non-null type org.gradle.api.artifacts.ModuleDependency");
            var17_18.add(this.createQueryDependency((ModuleDependency)dependency));
        }
        List latest = (List)destination$iv;
        if (this.supportsConstraints(configuration)) {
            for (DependencyConstraint dependency2 : configuration.getAllDependencyConstraints()) {
                if (dependency2 instanceof DefaultProjectDependencyConstraint) continue;
                Intrinsics.checkNotNull((Object)dependency2);
                latest.add(this.createQueryDependency(dependency2));
            }
        }
        if (DefaultGroovyMethods.asBoolean((Object)DefaultGroovyMethods.getMetaClass((Object)(copy = configuration.copyRecursive().setTransitive(false)).getResolutionStrategy()).hasProperty((Object)copy.getResolutionStrategy(), "failOnDynamicVersions"))) {
            DefaultGroovyMethods.getMetaClass((Object)copy.getResolutionStrategy()).setProperty((Object)copy.getResolutionStrategy(), "failOnDynamicVersions", (Object)false);
        }
        Function1 isKotlinDep = Resolver::createLatestConfiguration$lambda$1;
        DependencySet dependencySet2 = configuration.getAllDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencySet2, (String)"getAllDependencies(...)");
        destination$iv$iv = (Iterable)dependencySet2;
        boolean $i$f$filterIsInstance = false;
        dependency = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ExternalDependency)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ExternalDependency d = (ExternalDependency)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)isKotlinDep.invoke((Object)d)).booleanValue()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv2;
        DependencySet dependencySet3 = configuration.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencySet3, (String)"getDependencies(...)");
        List inheritedKotlin = CollectionsKt.minus((Iterable)iterable2, (Iterable)((Iterable)dependencySet3));
        Configuration metadata = (Configuration)this.project.getConfigurations().findByName("commonMainMetadataElements");
        if (metadata == null) {
            Configuration compile = (Configuration)this.project.getConfigurations().findByName("compile");
            if (compile != null) {
                Intrinsics.checkNotNull((Object)copy);
                this.addAttributes((HasConfigurableAttributes)copy, (HasConfigurableAttributes)compile, (Function1<? super String, Boolean>)((Function1)Resolver::createLatestConfiguration$lambda$3));
            }
        } else {
            Intrinsics.checkNotNull((Object)copy);
            Resolver.addAttributes$default(this, (HasConfigurableAttributes)copy, (HasConfigurableAttributes)metadata, null, 4, null);
        }
        copy.getDependencies().clear();
        copy.getDependencies().addAll((Collection)latest);
        copy.getDependencies().addAll((Collection)inheritedKotlin);
        Intrinsics.checkNotNull((Object)copy);
        this.addRevisionFilter(copy, revision);
        Resolver.addAttributes$default(this, (HasConfigurableAttributes)copy, (HasConfigurableAttributes)configuration, null, 4, null);
        this.addCustomResolutionStrategy(copy, currentCoordinates);
        this.disableAutoTargetJvm(copy);
        return copy;
    }

    private final Dependency createQueryDependency(ModuleDependency dependency) {
        String version = dependency.getVersion() == null ? (dependency.getArtifacts().isEmpty() ? "+" : "none") : "+";
        String query = null;
        StringBuilder stringBuilder = new StringBuilder();
        String string = dependency.getGroup();
        if (string == null) {
            string = "";
        }
        query = stringBuilder.append(string).append(':').append(dependency.getName()).append(':').append(version).toString();
        Set set = dependency.getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getArtifacts(...)");
        if (!((Collection)set).isEmpty()) {
            Set set2 = dependency.getArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getArtifacts(...)");
            Object object = (DependencyArtifact)CollectionsKt.firstOrNull((Iterable)set2);
            if (object != null && (object = object.getClassifier()) != null) {
                Object classifier = object;
                boolean bl = false;
                query = query + ':' + (String)classifier;
            }
            Set set3 = dependency.getArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"getArtifacts(...)");
            Object object2 = (DependencyArtifact)CollectionsKt.firstOrNull((Iterable)set3);
            if (object2 != null && (object2 = object2.getExtension()) != null) {
                Object extension = object2;
                boolean bl = false;
                query = query + '@' + (String)extension;
            }
        }
        Dependency dependency2 = this.project.getDependencies().create((Object)query);
        Intrinsics.checkNotNull((Object)dependency2, (String)"null cannot be cast to non-null type org.gradle.api.artifacts.ModuleDependency");
        ModuleDependency latest = (ModuleDependency)dependency2;
        latest.setTransitive(false);
        if (dependency.getArtifacts().isEmpty()) {
            Resolver.addAttributes$default(this, (HasConfigurableAttributes)latest, (HasConfigurableAttributes)dependency, null, 4, null);
        }
        return (Dependency)latest;
    }

    private final Dependency createQueryDependency(DependencyConstraint dependency) {
        String version = dependency.getVersion() == null ? "none" : "+";
        DependencyHandler dependencyHandler = this.project.getDependencies();
        StringBuilder stringBuilder = new StringBuilder();
        String string = dependency.getGroup();
        if (string == null) {
            string = "";
        }
        Dependency dependency2 = dependencyHandler.create((Object)stringBuilder.append(string).append(':').append(dependency.getName()).append(':').append(version).toString());
        Intrinsics.checkNotNull((Object)dependency2, (String)"null cannot be cast to non-null type org.gradle.api.artifacts.ModuleDependency");
        ModuleDependency nonTransitiveDependency = (ModuleDependency)dependency2;
        nonTransitiveDependency.setTransitive(false);
        return (Dependency)nonTransitiveDependency;
    }

    private final void disableAutoTargetJvm(Configuration configuration) {
        configuration.getAttributes().attribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, (Object)Integer.MAX_VALUE);
    }

    private final void addAttributes(HasConfigurableAttributes<?> target, HasConfigurableAttributes<?> source, Function1<? super String, Boolean> filter) {
        target.attributes(arg_0 -> Resolver.addAttributes$lambda$8(arg_0 -> Resolver.addAttributes$lambda$7(source, filter, arg_0), arg_0));
    }

    static /* synthetic */ void addAttributes$default(Resolver resolver, HasConfigurableAttributes hasConfigurableAttributes, HasConfigurableAttributes hasConfigurableAttributes2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = Resolver::addAttributes$lambda$6;
        }
        resolver.addAttributes(hasConfigurableAttributes, hasConfigurableAttributes2, (Function1<? super String, Boolean>)function1);
    }

    private final void addRevisionFilter(Configuration configuration, String revision) {
        configuration.resolutionStrategy(arg_0 -> Resolver.addRevisionFilter$lambda$16(arg_0 -> Resolver.addRevisionFilter$lambda$15(revision, arg_0), arg_0));
    }

    private final void addCustomResolutionStrategy(Configuration configuration, Map<Coordinate.Key, Coordinate> currentCoordinates) {
        configuration.resolutionStrategy(arg_0 -> Resolver.addCustomResolutionStrategy$lambda$18(arg_0 -> Resolver.addCustomResolutionStrategy$lambda$17(this, currentCoordinates, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Coordinate.Key, Coordinate> getCurrentCoordinates(Configuration configuration) {
        Coordinate it;
        boolean bl;
        Map declared;
        block10: {
            Iterator $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = this.getResolvableDependencies(configuration);
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            Iterator<Object> iterator = $this$associateByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it2;
                Object element$iv$iv = iterator.next();
                Coordinate coordinate = (Coordinate)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl2 = false;
                map.put(it2.getKey(), element$iv$iv);
            }
            declared = destination$iv$iv;
            if (declared.isEmpty()) {
                return MapsKt.emptyMap();
            }
            Iterable $this$any$iv = declared.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Coordinate it3 = (Coordinate)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it3.getVersion(), (Object)"none")) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        boolean transitive = bl;
        HashMap<Coordinate.Key, Coordinate> coordinates = new HashMap<Coordinate.Key, Coordinate>();
        Configuration copy = configuration.copyRecursive().setTransitive(transitive);
        Intrinsics.checkNotNull((Object)copy);
        this.disableAutoTargetJvm(copy);
        LenientConfiguration lenient = copy.getResolvedConfiguration().getLenientConfiguration();
        Set resolved = lenient.getFirstLevelModuleDependencies();
        for (ResolvedDependency dependency : resolved) {
            ModuleVersionIdentifier moduleVersionIdentifier = dependency.getModule().getId();
            Intrinsics.checkNotNullExpressionValue((Object)moduleVersionIdentifier, (String)"getId(...)");
            Coordinate coordinate = Coordinate.Companion.from(moduleVersionIdentifier, declared);
            ((Map)coordinates).put(coordinate.getKey(), coordinate);
        }
        Set unresolved = lenient.getUnresolvedModuleDependencies();
        for (UnresolvedDependency dependency : unresolved) {
            ModuleVersionSelector moduleVersionSelector = dependency.getSelector();
            Intrinsics.checkNotNullExpressionValue((Object)moduleVersionSelector, (String)"getSelector(...)");
            Coordinate.Key key = Coordinate.Companion.keyFrom(moduleVersionSelector);
            if ((Coordinate)declared.get(key) == null) continue;
            boolean bl4 = false;
            coordinates.put(key, it);
        }
        if (this.supportsConstraints(copy)) {
            for (DependencyConstraint constraint : copy.getAllDependencyConstraints()) {
                Intrinsics.checkNotNull((Object)constraint);
                Coordinate coordinate = Coordinate.Companion.from((ModuleVersionSelector)constraint);
                if (coordinates.containsKey(coordinate.getKey())) continue;
                if ((Coordinate)declared.get(coordinate.getKey()) != null) {
                    boolean bl5 = false;
                    coordinates.put(coordinate.getKey(), it);
                }
            }
        }
        coordinates.keySet().retainAll(declared.keySet());
        return coordinates;
    }

    /*
     * WARNING - void declaration
     */
    private final void logRepositories() {
        void $this$flatMapTo$iv$iv;
        boolean root = Intrinsics.areEqual((Object)this.project.getRootProject(), (Object)this.project);
        String label = (root ? this.project.getName() : this.project.getPath()) + " project " + (root ? " (root)" : "");
        ConfigurationContainer configurationContainer = this.project.getBuildscript().getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"getConfigurations(...)");
        Iterable $this$flatMap$iv = (Iterable)configurationContainer;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Configuration config = (Configuration)element$iv$iv;
            boolean bl = false;
            DependencySet dependencySet = config.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"getDependencies(...)");
            Iterable list$iv$iv = (Iterable)dependencySet;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        if (!CollectionsKt.any((Iterable)((List)destination$iv$iv))) {
            this.project.getLogger().info("Resolving " + label + " buildscript with repositories:");
            for (ArtifactRepository repository : this.project.getBuildscript().getRepositories()) {
                Intrinsics.checkNotNull((Object)repository);
                this.logRepository(repository);
            }
        }
        this.project.getLogger().info("Resolving " + label + " configurations with repositories:");
        for (ArtifactRepository repository : this.project.getRepositories()) {
            Intrinsics.checkNotNull((Object)repository);
            this.logRepository(repository);
        }
    }

    private final void logRepository(ArtifactRepository repository) {
        ArtifactRepository artifactRepository = repository;
        if (artifactRepository instanceof FlatDirectoryArtifactRepository) {
            this.project.getLogger().info(" - " + ((FlatDirectoryArtifactRepository)repository).getName() + ": " + ((FlatDirectoryArtifactRepository)repository).getDirs());
        } else if (artifactRepository instanceof IvyArtifactRepository) {
            this.project.getLogger().info(" - " + ((IvyArtifactRepository)repository).getName() + ": " + ((IvyArtifactRepository)repository).getUrl());
        } else if (artifactRepository instanceof MavenArtifactRepository) {
            this.project.getLogger().info(" - " + ((MavenArtifactRepository)repository).getName() + ": " + ((MavenArtifactRepository)repository).getUrl());
        } else {
            this.project.getLogger().info(" - " + repository.getName() + ": " + repository.getClass().getSimpleName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getProjectUrl(ModuleVersionIdentifier id) {
        if (this.project.getGradle().getStartParameter().isOffline()) {
            return null;
        }
        Companion.ProjectUrl projectUrl = null;
        projectUrl = new Companion.ProjectUrl();
        Companion.ProjectUrl cached = this.projectUrls.putIfAbsent(id, projectUrl);
        if (cached != null) {
            projectUrl = cached;
        }
        Companion.ProjectUrl projectUrl2 = projectUrl;
        synchronized (projectUrl2) {
            boolean bl = false;
            if (!projectUrl.getResolved()) {
                projectUrl.setResolved(true);
                projectUrl.setUrl(this.resolveProjectUrl(id));
            }
            String string = projectUrl.getUrl();
            return string;
        }
    }

    private final String resolveProjectUrl(ModuleVersionIdentifier id) {
        Object var2_4;
        try {
            Object object = new ComponentIdentifier[]{DefaultModuleComponentIdentifier.newId((ModuleVersionIdentifier)id)};
            ArtifactResolutionQuery artifactResolutionQuery = this.project.getDependencies().createArtifactResolutionQuery().forComponents((ComponentIdentifier[])object);
            object = new Class[]{MavenPomArtifact.class};
            ArtifactResolutionResult resolutionResult = artifactResolutionQuery.withArtifacts(MavenModule.class, (Class[])object).execute();
            for (ComponentArtifactsResult result : resolutionResult.getResolvedComponents()) {
                for (ArtifactResult artifact : result.getArtifacts(MavenPomArtifact.class)) {
                    CharSequence charSequence;
                    if (!(artifact instanceof ResolvedArtifactResult)) continue;
                    File file = ((ResolvedArtifactResult)artifact).getFile();
                    this.project.getLogger().info("Pom file for " + id + " is " + file);
                    Intrinsics.checkNotNull((Object)file);
                    String url = Resolver.Companion.getUrlFromPom(file);
                    CharSequence charSequence2 = url;
                    if (!(charSequence2 == null || charSequence2.length() == 0)) {
                        this.project.getLogger().info("Found url for " + id + ": " + url);
                        return ((Object)StringsKt.trim((CharSequence)url)).toString();
                    }
                    ModuleVersionIdentifier parent = Resolver.Companion.getParentFromPom(file);
                    if (parent == null) continue;
                    StringBuilder stringBuilder = new StringBuilder();
                    String string = parent.getGroup();
                    if (string == null) {
                        string = "";
                    }
                    if (Intrinsics.areEqual((Object)stringBuilder.append(string).append(':').append(parent.getName()).toString(), (Object)"org.sonatype.oss:oss-parent") || (charSequence = (CharSequence)(url = this.getProjectUrl(parent))) == null || charSequence.length() == 0) continue;
                    return ((Object)StringsKt.trim((CharSequence)url)).toString();
                }
            }
            this.project.getLogger().info("Did not find url for " + id);
            var2_4 = null;
        }
        catch (Exception e) {
            this.project.getLogger().info("Failed to resolve the project's url", (Throwable)e);
            var2_4 = null;
        }
        return var2_4;
    }

    private final boolean supportsConstraints(Configuration configuration) {
        Collection collection;
        return this.checkConstraints && !((collection = (Collection)configuration.getAllDependencyConstraints()) == null || collection.isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    private final List<Coordinate> getResolvableDependencies(Configuration configuration) {
        void destination$iv;
        void $this$mapTo$iv;
        void $this$filterTo$iv$iv;
        DependencySet dependencySet = configuration.getAllDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"getAllDependencies(...)");
        Iterable $this$filter$iv = (Iterable)dependencySet;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Dependency dependency = (Dependency)element$iv$iv;
            boolean bl = false;
            if (!(dependency instanceof ExternalDependency)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection $i$f$filter22 = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void dependency;
            Dependency dependency2 = (Dependency)item$iv;
            void var12_19 = destination$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)dependency);
            var12_19.add(Coordinate.Companion.from((Dependency)dependency));
        }
        List coordinates = (List)destination$iv;
        if (this.supportsConstraints(configuration)) {
            DependencyConstraintSet dependencyConstraintSet = configuration.getAllDependencyConstraints();
            Intrinsics.checkNotNullExpressionValue((Object)dependencyConstraintSet, (String)"getAllDependencyConstraints(...)");
            Iterable $this$forEach$iv = (Iterable)dependencyConstraintSet;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DependencyConstraint dependencyConstraint = (DependencyConstraint)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)dependencyConstraint);
                coordinates.add(Coordinate.Companion.from((ModuleVersionSelector)dependencyConstraint));
            }
        }
        return coordinates;
    }

    private static final boolean createLatestConfiguration$lambda$1(ExternalDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        String string = dependency.getGroup();
        return string != null ? StringsKt.startsWith$default((String)string, (String)"org.jetbrains.kotlin", (boolean)false, (int)2, null) : false;
    }

    private static final boolean createLatestConfiguration$lambda$3(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return StringsKt.contains$default((CharSequence)key, (CharSequence)"kotlin", (boolean)false, (int)2, null);
    }

    private static final boolean addAttributes$lambda$6(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        return true;
    }

    private static final Unit addAttributes$lambda$7(HasConfigurableAttributes $source, Function1 $filter, AttributeContainer container) {
        for (Attribute key : $source.getAttributes().keySet()) {
            Object value;
            String string = key.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!((Boolean)$filter.invoke((Object)string)).booleanValue()) continue;
            AttributeContainer attributeContainer = $source.getAttributes();
            Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type org.gradle.api.attributes.Attribute<kotlin.Any>");
            Intrinsics.checkNotNull((Object)attributeContainer.getAttribute(key));
            container.attribute(key, value);
        }
        return Unit.INSTANCE;
    }

    private static final void addAttributes$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit addRevisionFilter$lambda$15$lambda$13$lambda$9(String $revision, ComponentSelection selection, ComponentMetadata metadata) {
        boolean accepted;
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        boolean bl = accepted = metadata == null || Intrinsics.areEqual((Object)$revision, (Object)"release") && Intrinsics.areEqual((Object)metadata.getStatus(), (Object)"release") || Intrinsics.areEqual((Object)$revision, (Object)"milestone") && !Intrinsics.areEqual((Object)metadata.getStatus(), (Object)"integration") || Intrinsics.areEqual((Object)$revision, (Object)"integration") || Intrinsics.areEqual((Object)selection.getCandidate().getVersion(), (Object)"none");
        if (!accepted) {
            ComponentMetadata componentMetadata = metadata;
            selection.reject("Component status " + (componentMetadata != null ? componentMetadata.getStatus() : null) + " rejected by revision " + $revision);
        }
        return Unit.INSTANCE;
    }

    private static final Unit addRevisionFilter$lambda$15$lambda$13$lambda$11(Function2 $revisionFilter, ComponentSelection selectionAction) {
        boolean bl;
        block4: {
            Iterable $this$any$iv = Reflection.getOrCreateKotlinClass(ComponentSelection.class).getMembers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KCallable it = (KCallable)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"getMetadata")) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            Intrinsics.checkNotNull((Object)selectionAction);
            $revisionFilter.invoke((Object)selectionAction, (Object)selectionAction.getMetadata());
        }
        return Unit.INSTANCE;
    }

    private static final void addRevisionFilter$lambda$15$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit addRevisionFilter$lambda$15$lambda$13(String $revision, ComponentSelectionRules rules) {
        Function2 revisionFilter = (arg_0, arg_1) -> Resolver.addRevisionFilter$lambda$15$lambda$13$lambda$9($revision, arg_0, arg_1);
        rules.all(arg_0 -> Resolver.addRevisionFilter$lambda$15$lambda$13$lambda$12(arg_0 -> Resolver.addRevisionFilter$lambda$15$lambda$13$lambda$11(revisionFilter, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void addRevisionFilter$lambda$15$lambda$14(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit addRevisionFilter$lambda$15(String $revision, ResolutionStrategy componentSelection) {
        componentSelection.componentSelection(arg_0 -> Resolver.addRevisionFilter$lambda$15$lambda$14(arg_0 -> Resolver.addRevisionFilter$lambda$15$lambda$13($revision, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void addRevisionFilter$lambda$16(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit addCustomResolutionStrategy$lambda$17(Resolver this$0, Map $currentCoordinates, ResolutionStrategy inner) {
        block0: {
            Action<? super ResolutionStrategyWithCurrent> action = this$0.resolutionStrategy;
            if (action == null) break block0;
            Intrinsics.checkNotNull((Object)inner);
            action.execute((Object)new ResolutionStrategyWithCurrent(inner, $currentCoordinates));
        }
        return Unit.INSTANCE;
    }

    private static final void addCustomResolutionStrategy$lambda$18(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/github/benmanes/gradle/versions/updates/Resolver$Companion;", "", "<init>", "()V", "getUrlFromPom", "", "file", "Ljava/io/File;", "getParentFromPom", "Lorg/gradle/api/artifacts/ModuleVersionIdentifier;", "ProjectUrl", "gradle-versions-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final String getUrlFromPom(File file) {
            GPathResult pom = new XmlSlurper(false, false).parse(file);
            NodeChildren nodeChildren = (NodeChildren)pom.getProperty("url");
            String url = nodeChildren != null ? nodeChildren.text() : null;
            String string = url;
            if (string == null) {
                NodeChildren nodeChildren2 = (NodeChildren)pom.getProperty("scm");
                NodeChildren nodeChildren3 = (NodeChildren)(nodeChildren2 != null ? nodeChildren2.getProperty("url") : null);
                string = nodeChildren3 != null ? nodeChildren3.text() : null;
            }
            return string;
        }

        private final ModuleVersionIdentifier getParentFromPom(File file) {
            GPathResult pom = new XmlSlurper(false, false).parse(file);
            GPathResult parent = (GPathResult)((NodeChildren)pom.getProperty("parent"));
            if (parent != null) {
                String version;
                NodeChildren nodeChildren = (NodeChildren)parent.getProperty("groupId");
                String groupId = nodeChildren != null ? nodeChildren.text() : null;
                NodeChildren nodeChildren2 = (NodeChildren)parent.getProperty("artifactId");
                String artifactId = nodeChildren2 != null ? nodeChildren2.text() : null;
                NodeChildren nodeChildren3 = (NodeChildren)parent.getProperty("version");
                String string = version = nodeChildren3 != null ? nodeChildren3.text() : null;
                if (groupId != null && artifactId != null && version != null) {
                    return DefaultModuleVersionIdentifier.newId((String)groupId, (String)artifactId, (String)version);
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/github/benmanes/gradle/versions/updates/Resolver$Companion$ProjectUrl;", "", "<init>", "()V", "resolved", "", "getResolved", "()Z", "setResolved", "(Z)V", "url", "", "getUrl", "()Ljava/lang/String;", "setUrl", "(Ljava/lang/String;)V", "gradle-versions-plugin"})
        public static final class ProjectUrl {
            private boolean resolved;
            @Nullable
            private String url;

            public final boolean getResolved() {
                return this.resolved;
            }

            public final void setResolved(boolean bl) {
                this.resolved = bl;
            }

            @Nullable
            public final String getUrl() {
                return this.url;
            }

            public final void setUrl(@Nullable String string) {
                this.url = string;
            }
        }
    }
}

