/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.servlet;

import java.util.EventListener;
import wiremock.javax.servlet.ServletException;
import wiremock.org.eclipse.jetty.server.handler.ContextHandler;
import wiremock.org.eclipse.jetty.servlet.BaseHolder;
import wiremock.org.eclipse.jetty.servlet.ServletContextHandler;
import wiremock.org.eclipse.jetty.servlet.Source;

public class ListenerHolder
extends BaseHolder<EventListener> {
    private EventListener _listener;

    public ListenerHolder() {
        this(Source.EMBEDDED);
    }

    public ListenerHolder(Source source) {
        super(source);
    }

    public ListenerHolder(Class<? extends EventListener> listenerClass) {
        super(Source.EMBEDDED);
        this.setHeldClass(listenerClass);
    }

    public EventListener getListener() {
        return this._listener;
    }

    public void setListener(EventListener listener) {
        this._listener = listener;
        this._extInstance = true;
        this.setHeldClass(this._listener.getClass());
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        if (!EventListener.class.isAssignableFrom(this._class)) {
            String msg = this._class + " is not a java.util.EventListener";
            super.stop();
            throw new IllegalStateException(msg);
        }
        ContextHandler contextHandler = ContextHandler.getCurrentContext().getContextHandler();
        if (this._listener == null) {
            try {
                ContextHandler.Context scontext = contextHandler.getServletContext();
                this._listener = scontext instanceof ServletContextHandler.Context ? scontext.createListener(this.getHeldClass()) : (EventListener)this.getHeldClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ServletException ex) {
                Throwable cause = ex.getRootCause();
                if (cause instanceof InstantiationException) {
                    throw (InstantiationException)cause;
                }
                if (cause instanceof IllegalAccessException) {
                    throw (IllegalAccessException)cause;
                }
                throw ex;
            }
        }
        contextHandler.addEventListener(this._listener);
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        if (!this._extInstance) {
            this._listener = null;
        }
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.getClassName();
    }
}

