/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api.buildplan;

import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.FileEntry;
import com.google.cloud.tools.jib.api.buildplan.FilePermissions;
import com.google.cloud.tools.jib.api.buildplan.FilePermissionsProvider;
import com.google.cloud.tools.jib.api.buildplan.LayerObject;
import com.google.cloud.tools.jib.api.buildplan.ModificationTimeProvider;
import com.google.cloud.tools.jib.api.buildplan.OwnershipProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FileEntriesLayer
implements LayerObject {
    public static final FilePermissionsProvider DEFAULT_FILE_PERMISSIONS_PROVIDER = (sourcePath, destinationPath) -> Files.isDirectory(sourcePath, new LinkOption[0]) ? FilePermissions.DEFAULT_FOLDER_PERMISSIONS : FilePermissions.DEFAULT_FILE_PERMISSIONS;
    public static final Instant DEFAULT_MODIFICATION_TIME = Instant.ofEpochSecond(1L);
    public static final ModificationTimeProvider DEFAULT_MODIFICATION_TIME_PROVIDER = (sourcePath, destinationPath) -> DEFAULT_MODIFICATION_TIME;
    public static final OwnershipProvider DEFAULT_OWNERSHIP_PROVIDER = (sourcePath, destinationPath) -> "";
    private final String name;
    private final List<FileEntry> entries;

    public static Builder builder() {
        return new Builder();
    }

    private FileEntriesLayer(String name, List<FileEntry> entries) {
        this.name = name;
        this.entries = entries;
    }

    @Override
    public LayerObject.Type getType() {
        return LayerObject.Type.FILE_ENTRIES;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<FileEntry> getEntries() {
        return new ArrayList<FileEntry>(this.entries);
    }

    public Builder toBuilder() {
        return FileEntriesLayer.builder().setName(this.name).setEntries(this.entries);
    }

    public static class Builder {
        private String name = "";
        private List<FileEntry> entries = new ArrayList<FileEntry>();

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setEntries(List<FileEntry> entries) {
            this.entries = new ArrayList<FileEntry>(entries);
            return this;
        }

        public Builder addEntry(FileEntry entry) {
            this.entries.add(entry);
            return this;
        }

        public Builder addEntry(Path sourceFile, AbsoluteUnixPath pathInContainer) {
            return this.addEntry(sourceFile, pathInContainer, DEFAULT_FILE_PERMISSIONS_PROVIDER.get(sourceFile, pathInContainer));
        }

        public Builder addEntry(Path sourceFile, AbsoluteUnixPath pathInContainer, FilePermissions permissions) {
            return this.addEntry(sourceFile, pathInContainer, permissions, DEFAULT_MODIFICATION_TIME);
        }

        public Builder addEntry(Path sourceFile, AbsoluteUnixPath pathInContainer, Instant modificationTime) {
            return this.addEntry(sourceFile, pathInContainer, DEFAULT_FILE_PERMISSIONS_PROVIDER.get(sourceFile, pathInContainer), modificationTime);
        }

        public Builder addEntry(Path sourceFile, AbsoluteUnixPath pathInContainer, FilePermissions permissions, Instant modificationTime) {
            return this.addEntry(new FileEntry(sourceFile, pathInContainer, permissions, modificationTime));
        }

        public Builder addEntry(Path sourceFile, AbsoluteUnixPath pathInContainer, FilePermissions permissions, Instant modificationTime, String ownership) {
            return this.addEntry(new FileEntry(sourceFile, pathInContainer, permissions, modificationTime, ownership));
        }

        public Builder addEntryRecursive(Path sourceFile, AbsoluteUnixPath pathInContainer) throws IOException {
            return this.addEntryRecursive(sourceFile, pathInContainer, DEFAULT_FILE_PERMISSIONS_PROVIDER);
        }

        public Builder addEntryRecursive(Path sourceFile, AbsoluteUnixPath pathInContainer, FilePermissionsProvider filePermissionProvider) throws IOException {
            return this.addEntryRecursive(sourceFile, pathInContainer, filePermissionProvider, DEFAULT_MODIFICATION_TIME_PROVIDER);
        }

        public Builder addEntryRecursive(Path sourceFile, AbsoluteUnixPath pathInContainer, FilePermissionsProvider filePermissionProvider, ModificationTimeProvider modificationTimeProvider) throws IOException {
            return this.addEntryRecursive(sourceFile, pathInContainer, filePermissionProvider, modificationTimeProvider, DEFAULT_OWNERSHIP_PROVIDER);
        }

        public Builder addEntryRecursive(Path sourceFile, AbsoluteUnixPath pathInContainer, FilePermissionsProvider filePermissionProvider, ModificationTimeProvider modificationTimeProvider, OwnershipProvider ownershipProvider) throws IOException {
            FilePermissions permissions = filePermissionProvider.get(sourceFile, pathInContainer);
            Instant modificationTime = modificationTimeProvider.get(sourceFile, pathInContainer);
            String ownership = ownershipProvider.get(sourceFile, pathInContainer);
            this.addEntry(sourceFile, pathInContainer, permissions, modificationTime, ownership);
            if (!Files.isDirectory(sourceFile, new LinkOption[0])) {
                return this;
            }
            try (Stream<Path> files = Files.list(sourceFile);){
                for (Path file : files.collect(Collectors.toList())) {
                    this.addEntryRecursive(file, pathInContainer.resolve(file.getFileName()), filePermissionProvider, modificationTimeProvider, ownershipProvider);
                }
            }
            return this;
        }

        public FileEntriesLayer build() {
            return new FileEntriesLayer(this.name, this.entries);
        }
    }
}

