/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.api.buildplan.ImageFormat;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class ContainerParameters {
    private final ListProperty<String> jvmFlags;
    private Map<String, String> environment = Collections.emptyMap();
    @Nullable
    private List<String> entrypoint;
    private List<String> extraClasspath = Collections.emptyList();
    private boolean expandClasspathDependencies;
    private final Property<String> mainClass;
    @Nullable
    private List<String> args;
    private ImageFormat format = ImageFormat.Docker;
    private List<String> ports = Collections.emptyList();
    private List<String> volumes = Collections.emptyList();
    private MapProperty<String, String> labels;
    private String appRoot = "";
    @Nullable
    private String user;
    @Nullable
    private String workingDirectory;
    private final Property<String> filesModificationTime;
    private final Property<String> creationTime;

    @Inject
    public ContainerParameters(ObjectFactory objectFactory) {
        this.labels = objectFactory.mapProperty(String.class, String.class).empty();
        this.filesModificationTime = objectFactory.property(String.class).convention((Object)"EPOCH_PLUS_SECOND");
        this.creationTime = objectFactory.property(String.class).convention((Object)"EPOCH");
        this.mainClass = objectFactory.property(String.class);
        this.jvmFlags = objectFactory.listProperty(String.class);
    }

    @Input
    @Nullable
    @Optional
    public List<String> getEntrypoint() {
        if (System.getProperty("jib.container.entrypoint") != null) {
            return ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.container.entrypoint"));
        }
        return this.entrypoint;
    }

    public void setEntrypoint(List<String> entrypoint) {
        this.entrypoint = entrypoint;
    }

    public void setEntrypoint(String entrypoint) {
        this.entrypoint = Collections.singletonList(entrypoint);
    }

    @Input
    @Optional
    public List<String> getJvmFlags() {
        String jvmFlagsSystemProperty = System.getProperty("jib.container.jvmFlags");
        if (jvmFlagsSystemProperty != null) {
            return ConfigurationPropertyValidator.parseListProperty(jvmFlagsSystemProperty);
        }
        return (List)this.jvmFlags.getOrElse(Collections.emptyList());
    }

    public void setJvmFlags(List<String> jvmFlags) {
        this.jvmFlags.set(jvmFlags);
    }

    public void setJvmFlags(Provider<List<String>> jvmFlags) {
        this.jvmFlags.set(jvmFlags);
    }

    @Input
    @Optional
    public Map<String, String> getEnvironment() {
        if (System.getProperty("jib.container.environment") != null) {
            return ConfigurationPropertyValidator.parseMapProperty(System.getProperty("jib.container.environment"));
        }
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    @Input
    @Optional
    public List<String> getExtraClasspath() {
        if (System.getProperty("jib.container.extraClasspath") != null) {
            return ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.container.extraClasspath"));
        }
        return this.extraClasspath;
    }

    public void setExtraClasspath(List<String> classpath) {
        this.extraClasspath = classpath;
    }

    @Input
    public boolean getExpandClasspathDependencies() {
        if (System.getProperty("jib.container.expandClasspathDependencies") != null) {
            return Boolean.valueOf(System.getProperty("jib.container.expandClasspathDependencies"));
        }
        return this.expandClasspathDependencies;
    }

    public void setExpandClasspathDependencies(boolean expand) {
        this.expandClasspathDependencies = expand;
    }

    @Input
    @Nullable
    @Optional
    public String getMainClass() {
        String mainClassProperty = System.getProperty("jib.container.mainClass");
        if (mainClassProperty != null) {
            return mainClassProperty;
        }
        return (String)this.mainClass.getOrNull();
    }

    public void setMainClass(String mainClass) {
        this.mainClass.set((Object)mainClass);
    }

    public void setMainClass(Provider<String> mainClass) {
        this.mainClass.set(mainClass);
    }

    @Input
    @Nullable
    @Optional
    public List<String> getArgs() {
        if (System.getProperty("jib.container.args") != null) {
            return ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.container.args"));
        }
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    @Input
    @Optional
    public ImageFormat getFormat() {
        if (System.getProperty("jib.container.format") != null) {
            return ImageFormat.valueOf((String)System.getProperty("jib.container.format"));
        }
        return (ImageFormat)Preconditions.checkNotNull((Object)this.format);
    }

    public void setFormat(ImageFormat format) {
        this.format = format;
    }

    public void setFormat(String format) {
        this.format = ImageFormat.valueOf((String)format);
    }

    @Input
    @Optional
    public List<String> getPorts() {
        if (System.getProperty("jib.container.ports") != null) {
            return ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.container.ports"));
        }
        return this.ports;
    }

    public void setPorts(List<String> ports) {
        this.ports = ports;
    }

    @Input
    @Optional
    public List<String> getVolumes() {
        if (System.getProperty("jib.container.volumes") != null) {
            return ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.container.volumes"));
        }
        return this.volumes;
    }

    public void setVolumes(List<String> volumes) {
        this.volumes = volumes;
    }

    @Input
    @Optional
    public MapProperty<String, String> getLabels() {
        Map<String, String> parsedLabels;
        String labelsProperty = System.getProperty("jib.container.labels");
        if (labelsProperty != null && !(parsedLabels = ConfigurationPropertyValidator.parseMapProperty(labelsProperty)).equals(this.labels.get())) {
            this.labels.set(parsedLabels);
        }
        return this.labels;
    }

    @Input
    @Optional
    public String getAppRoot() {
        if (System.getProperty("jib.container.appRoot") != null) {
            return System.getProperty("jib.container.appRoot");
        }
        return this.appRoot;
    }

    public void setAppRoot(String appRoot) {
        this.appRoot = appRoot;
    }

    @Input
    @Nullable
    @Optional
    public String getUser() {
        if (System.getProperty("jib.container.user") != null) {
            return System.getProperty("jib.container.user");
        }
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Input
    @Nullable
    @Optional
    public String getWorkingDirectory() {
        if (System.getProperty("jib.container.workingDirectory") != null) {
            return System.getProperty("jib.container.workingDirectory");
        }
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Input
    @Optional
    public Property<String> getFilesModificationTime() {
        String property = System.getProperty("jib.container.filesModificationTime");
        if (property != null && !property.equals(this.filesModificationTime.get())) {
            this.filesModificationTime.set((Object)property);
        }
        return this.filesModificationTime;
    }

    @Input
    @Optional
    public Property<String> getCreationTime() {
        String property = System.getProperty("jib.container.creationTime");
        if (property != null && !property.equals(this.creationTime.get())) {
            this.creationTime.set((Object)property);
        }
        return this.creationTime;
    }
}

