/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle.extension.ownership;

import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class Configuration {
    private final RulesSpec rulesSpec;

    @Inject
    public Configuration(Project project) {
        this.rulesSpec = (RulesSpec)project.getObjects().newInstance(RulesSpec.class, new Object[]{project});
    }

    public List<Rule> getRules() {
        return (List)this.rulesSpec.getRules().get();
    }

    public void rules(Action<? super RulesSpec> action) {
        action.execute((Object)this.rulesSpec);
    }

    public static class RulesSpec {
        private final Project project;
        private final ListProperty<Rule> rules;

        @Inject
        public RulesSpec(Project project) {
            this.project = project;
            this.rules = project.getObjects().listProperty(Rule.class).empty();
        }

        private ListProperty<Rule> getRules() {
            return this.rules;
        }

        public void rule(Action<? super Rule> action) {
            Rule filter = (Rule)this.project.getObjects().newInstance(Rule.class, new Object[0]);
            action.execute((Object)filter);
            this.rules.add((Object)filter);
        }
    }

    public static class Rule {
        private String glob = "";
        private String ownership = "";

        @Input
        public String getGlob() {
            return this.glob;
        }

        public void setGlob(String glob) {
            this.glob = glob;
        }

        @Input
        @Optional
        public String getOwnership() {
            return this.ownership;
        }

        public void setOwnership(String ownership) {
            this.ownership = ownership;
        }
    }
}

