/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.CustomBuildScanEnhancements;
import com.gradle.CustomGradleEnterpriseConfig;
import com.gradle.enterprise.gradleplugin.GradleEnterpriseExtension;
import com.gradle.scan.plugin.BuildScanExtension;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.caching.configuration.BuildCacheConfiguration;
import org.gradle.util.GradleVersion;

public class CommonCustomUserDataGradlePlugin
implements Plugin<Object> {
    public void apply(Object target) {
        if (target instanceof Settings) {
            if (!this.isGradle6OrNewer()) {
                throw new GradleException("For Gradle versions prior to 6.0, common-custom-user-data-gradle-plugin must be applied to the Root project");
            }
            this.applySettingsPlugin((Settings)target);
        } else if (target instanceof Project) {
            if (this.isGradle6OrNewer()) {
                throw new GradleException("For Gradle versions 6.0 and newer, common-custom-user-data-gradle-plugin must be applied to Settings");
            }
            this.applyProjectPlugin((Project)target);
        }
    }

    private void applySettingsPlugin(Settings settings) {
        settings.getPluginManager().withPlugin("com.gradle.enterprise", __ -> {
            GradleEnterpriseExtension gradleEnterprise = (GradleEnterpriseExtension)settings.getExtensions().getByType(GradleEnterpriseExtension.class);
            CustomGradleEnterpriseConfig.configureGradleEnterprise(gradleEnterprise);
            BuildScanExtension buildScan = gradleEnterprise.getBuildScan();
            CustomGradleEnterpriseConfig.configureBuildScanPublishing(buildScan);
            CustomBuildScanEnhancements.configureBuildScan(buildScan, settings.getGradle());
            BuildCacheConfiguration buildCache = settings.getBuildCache();
            CustomGradleEnterpriseConfig.configureBuildCache(buildCache);
        });
    }

    private void applyProjectPlugin(Project project) {
        if (!project.equals(project.getRootProject())) {
            throw new GradleException("Common custom user data plugin may only be applied to root project");
        }
        project.getPluginManager().withPlugin("com.gradle.build-scan", __ -> {
            GradleEnterpriseExtension gradleEnterprise = (GradleEnterpriseExtension)project.getExtensions().getByType(GradleEnterpriseExtension.class);
            CustomGradleEnterpriseConfig.configureGradleEnterprise(gradleEnterprise);
            BuildScanExtension buildScan = gradleEnterprise.getBuildScan();
            CustomGradleEnterpriseConfig.configureBuildScanPublishing(buildScan);
            CustomBuildScanEnhancements.configureBuildScan(buildScan, project.getGradle());
        });
    }

    private boolean isGradle6OrNewer() {
        return GradleVersion.current().compareTo(GradleVersion.version((String)"6.0")) >= 0;
    }
}

