/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.Utils;
import com.gradle.scan.plugin.BuildScanExtension;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.testing.Test;

final class CustomBuildScanEnhancements {
    CustomBuildScanEnhancements() {
    }

    static void configureBuildScan(BuildScanExtension buildScan, Gradle gradle) {
        CustomBuildScanEnhancements.captureOs(buildScan);
        CustomBuildScanEnhancements.captureIde(buildScan, gradle);
        CustomBuildScanEnhancements.captureCiOrLocal(buildScan);
        CustomBuildScanEnhancements.captureCiMetadata(buildScan, gradle);
        CustomBuildScanEnhancements.captureGitMetadata(buildScan);
        CustomBuildScanEnhancements.captureTestParallelization(buildScan, gradle);
    }

    private static Optional<String> projectProperty(Gradle gradle, String name) {
        String value = (String)gradle.getRootProject().findProperty(name);
        return Optional.ofNullable(value);
    }

    private static void captureOs(BuildScanExtension buildScan) {
        Utils.sysProperty("os.name").ifPresent(arg_0 -> ((BuildScanExtension)buildScan).tag(arg_0));
    }

    private static void captureIde(BuildScanExtension buildScan, Gradle gradle) {
        gradle.projectsEvaluated(g -> {
            Project project = g.getRootProject();
            if (project.hasProperty("android.injected.invoked.from.ide")) {
                buildScan.tag("Android Studio");
                if (project.hasProperty("android.injected.studio.version")) {
                    buildScan.value("Android Studio version", String.valueOf(project.property("android.injected.studio.version")));
                }
            } else if (Utils.sysProperty("idea.version").isPresent() || Utils.sysPropertyKeyStartingWith("idea.version")) {
                buildScan.tag("IntelliJ IDEA");
            } else if (Utils.sysProperty("eclipse.buildId").isPresent()) {
                buildScan.tag("Eclipse");
            } else if (!CustomBuildScanEnhancements.isCi()) {
                buildScan.tag("Cmd Line");
            }
        });
    }

    private static void captureCiOrLocal(BuildScanExtension buildScan) {
        buildScan.tag(CustomBuildScanEnhancements.isCi() ? "CI" : "LOCAL");
    }

    private static void captureCiMetadata(BuildScanExtension buildScan, Gradle gradle) {
        if (CustomBuildScanEnhancements.isJenkins() || CustomBuildScanEnhancements.isHudson()) {
            Utils.envVariable("BUILD_URL").ifPresent(url -> buildScan.link(CustomBuildScanEnhancements.isJenkins() ? "Jenkins build" : "Hudson build", url));
            Utils.envVariable("BUILD_NUMBER").ifPresent(value -> buildScan.value("CI build number", value));
            Utils.envVariable("NODE_NAME").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "CI node", value));
            Utils.envVariable("JOB_NAME").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "CI job", value));
            Utils.envVariable("STAGE_NAME").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "CI stage", value));
        }
        if (CustomBuildScanEnhancements.isTeamCity()) {
            gradle.projectsEvaluated(g -> {
                Properties properties;
                String teamCityServerUrl;
                Optional<String> teamCityConfigFile = CustomBuildScanEnhancements.projectProperty(gradle, "teamcity.configuration.properties.file");
                Optional<String> buildNumber = CustomBuildScanEnhancements.projectProperty(gradle, "build.number");
                Optional<String> buildTypeId = CustomBuildScanEnhancements.projectProperty(gradle, "teamcity.buildType.id");
                if (teamCityConfigFile.isPresent() && buildNumber.isPresent() && buildTypeId.isPresent() && (teamCityServerUrl = (properties = Utils.readPropertiesFile(teamCityConfigFile.get())).getProperty("teamcity.serverUrl")) != null) {
                    String buildUrl = Utils.appendIfMissing(teamCityServerUrl, "/") + "viewLog.html?buildNumber=" + buildNumber.get() + "&buildTypeId=" + buildTypeId.get();
                    buildScan.link("TeamCity build", buildUrl);
                }
                buildNumber.ifPresent(value -> buildScan.value("CI build number", value));
                buildTypeId.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "CI build config", value));
                CustomBuildScanEnhancements.projectProperty(gradle, "agent.name").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "CI agent", value));
            });
        }
        if (CustomBuildScanEnhancements.isCircleCI()) {
            Utils.envVariable("CIRCLE_BUILD_URL").ifPresent(url -> buildScan.link("CircleCI build", url));
            Utils.envVariable("CIRCLE_BUILD_NUM").ifPresent(value -> buildScan.value("CI build number", value));
            Utils.envVariable("CIRCLE_JOB").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "CI job", value));
            Utils.envVariable("CIRCLE_WORKFLOW_ID").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "CI workflow", value));
        }
        if (CustomBuildScanEnhancements.isBamboo()) {
            Utils.envVariable("bamboo_resultsUrl").ifPresent(url -> buildScan.link("Bamboo build", url));
            Utils.envVariable("bamboo_buildNumber").ifPresent(value -> buildScan.value("CI build number", value));
            Utils.envVariable("bamboo_planName").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "CI plan", value));
            Utils.envVariable("bamboo_buildPlanName").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "CI build plan", value));
            Utils.envVariable("bamboo_agentId").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "CI agent", value));
        }
        if (CustomBuildScanEnhancements.isGitHubActions()) {
            Optional<String> gitHubRepository = Utils.envVariable("GITHUB_REPOSITORY");
            Optional<String> gitHubRunId = Utils.envVariable("GITHUB_RUN_ID");
            if (gitHubRepository.isPresent() && gitHubRunId.isPresent()) {
                buildScan.link("GitHub Actions build", "https://github.com/" + gitHubRepository.get() + "/actions/runs/" + gitHubRunId.get());
            }
            Utils.envVariable("GITHUB_WORKFLOW").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "GitHub workflow", value));
        }
        if (CustomBuildScanEnhancements.isGitLab()) {
            Utils.envVariable("CI_JOB_URL").ifPresent(url -> buildScan.link("GitLab build", url));
            Utils.envVariable("CI_PIPELINE_URL").ifPresent(url -> buildScan.link("GitLab pipeline", url));
            Utils.envVariable("CI_JOB_NAME").ifPresent(value1 -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "CI job", value1));
            Utils.envVariable("CI_JOB_STAGE").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "CI stage", value));
        }
        if (CustomBuildScanEnhancements.isTravis()) {
            Utils.envVariable("TRAVIS_BUILD_WEB_URL").ifPresent(url -> buildScan.link("Travis build", url));
            Utils.envVariable("TRAVIS_BUILD_NUMBER").ifPresent(value -> buildScan.value("CI build number", value));
            Utils.envVariable("TRAVIS_JOB_NAME").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "CI job", value));
            Utils.envVariable("TRAVIS_EVENT_TYPE").ifPresent(arg_0 -> ((BuildScanExtension)buildScan).tag(arg_0));
        }
        if (CustomBuildScanEnhancements.isBitrise()) {
            Utils.envVariable("BITRISE_BUILD_URL").ifPresent(url -> buildScan.link("Bitrise build", url));
            Utils.envVariable("BITRISE_BUILD_NUMBER").ifPresent(value -> buildScan.value("CI build number", value));
        }
    }

    private static boolean isCi() {
        return CustomBuildScanEnhancements.isGenericCI() || CustomBuildScanEnhancements.isJenkins() || CustomBuildScanEnhancements.isHudson() || CustomBuildScanEnhancements.isTeamCity() || CustomBuildScanEnhancements.isCircleCI() || CustomBuildScanEnhancements.isBamboo() || CustomBuildScanEnhancements.isGitHubActions() || CustomBuildScanEnhancements.isGitLab() || CustomBuildScanEnhancements.isTravis() || CustomBuildScanEnhancements.isBitrise();
    }

    private static boolean isGenericCI() {
        return Utils.envVariable("CI").isPresent() || Utils.sysProperty("CI").isPresent();
    }

    private static boolean isJenkins() {
        return Utils.envVariable("JENKINS_URL").isPresent();
    }

    private static boolean isHudson() {
        return Utils.envVariable("HUDSON_URL").isPresent();
    }

    private static boolean isTeamCity() {
        return Utils.envVariable("TEAMCITY_VERSION").isPresent();
    }

    private static boolean isCircleCI() {
        return Utils.envVariable("CIRCLE_BUILD_URL").isPresent();
    }

    private static boolean isBamboo() {
        return Utils.envVariable("bamboo_resultsUrl").isPresent();
    }

    private static boolean isGitHubActions() {
        return Utils.envVariable("GITHUB_ACTIONS").isPresent();
    }

    private static boolean isGitLab() {
        return Utils.envVariable("GITLAB_CI").isPresent();
    }

    private static boolean isTravis() {
        return Utils.envVariable("TRAVIS_JOB_ID").isPresent();
    }

    private static boolean isBitrise() {
        return Utils.envVariable("BITRISE_BUILD_URL").isPresent();
    }

    private static void captureGitMetadata(BuildScanExtension buildScan) {
        buildScan.background(api -> {
            if (!CustomBuildScanEnhancements.isGitInstalled()) {
                return;
            }
            String gitRepo = Utils.execAndGetStdOut("git", "config", "--get", "remote.origin.url");
            String gitCommitId = Utils.execAndGetStdOut("git", "rev-parse", "--short=8", "--verify", "HEAD");
            String gitBranchName = Utils.execAndGetStdOut("git", "rev-parse", "--abbrev-ref", "HEAD");
            String gitStatus = Utils.execAndGetStdOut("git", "status", "--porcelain");
            if (gitCommitId != null) {
                CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "Git commit id", gitCommitId);
                if (Utils.isNotEmpty(gitRepo)) {
                    Matcher matcher;
                    if (gitRepo.contains("github.com/") || gitRepo.contains("github.com:")) {
                        Matcher matcher2 = Pattern.compile("(.*)github\\.com[/|:](.*)").matcher(gitRepo);
                        if (matcher2.matches()) {
                            String rawRepoPath = matcher2.group(2);
                            String repoPath = rawRepoPath.endsWith(".git") ? rawRepoPath.substring(0, rawRepoPath.length() - 4) : rawRepoPath;
                            api.link("Github source", "https://github.com/" + repoPath + "/tree/" + gitCommitId);
                        }
                    } else if ((gitRepo.contains("gitlab.com/") || gitRepo.contains("gitlab.com:")) && (matcher = Pattern.compile("(.*)gitlab\\.com[/|:](.*)").matcher(gitRepo)).matches()) {
                        String rawRepoPath = matcher.group(2);
                        String repoPath = rawRepoPath.endsWith(".git") ? rawRepoPath.substring(0, rawRepoPath.length() - 4) : rawRepoPath;
                        api.link("GitLab Source", "https://gitlab.com/" + repoPath + "/-/commit/" + gitCommitId);
                    }
                }
            }
            if (Utils.isNotEmpty(gitRepo)) {
                api.value("Git repository", gitRepo);
            }
            if (Utils.isNotEmpty(gitBranchName)) {
                api.tag(gitBranchName);
                api.value("Git branch", gitBranchName);
            }
            if (Utils.isNotEmpty(gitStatus)) {
                api.tag("Dirty");
                api.value("Git status", gitStatus);
            }
        });
    }

    private static boolean isGitInstalled() {
        return Utils.execAndCheckSuccess("git", "--version");
    }

    private static void captureTestParallelization(final BuildScanExtension buildScan, Gradle gradle) {
        gradle.allprojects(p -> p.getTasks().withType(Test.class).configureEach(test -> test.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                buildScan.value(test.getIdentityPath() + "#maxParallelForks", String.valueOf(test.getMaxParallelForks()));
            }
        })));
    }

    private static void addCustomValueAndSearchLink(BuildScanExtension buildScan, String label, String value) {
        buildScan.value(label, value);
        String server = buildScan.getServer();
        if (server != null) {
            String searchParams = "search.names=" + Utils.urlEncode(label) + "&search.values=" + Utils.urlEncode(value);
            String url = Utils.appendIfMissing(server, "/") + "scans?" + searchParams + "#selection.buildScanB=" + Utils.urlEncode("{SCAN_ID}");
            buildScan.link(label + " build scans", url);
        }
    }
}

