/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.doubleparser.JavaBigDecimalParser;
import java.math.BigDecimal;
import java.util.Arrays;

public final class BigDecimalParser {
    public static BigDecimal parse(String string) {
        return BigDecimalParser.parse(string.toCharArray());
    }

    public static BigDecimal parse(char[] cArray, int n2, int n3) {
        try {
            if (n3 < 500) {
                return new BigDecimal(cArray, n2, n3);
            }
            return BigDecimalParser.parseBigDecimal(cArray, n2, n3, n3 / 10);
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            String string = runtimeException.getMessage();
            if (string == null) {
                string = "Not a valid number representation";
            }
            String string2 = n3 <= 1000 ? new String(cArray, n2, n3) : new String(Arrays.copyOfRange(cArray, n2, 1000)) + "(truncated, full length is " + cArray.length + " chars)";
            throw new NumberFormatException("Value \"" + string2 + "\" can not be represented as `java.math.BigDecimal`, reason: " + string);
        }
    }

    public static BigDecimal parse(char[] cArray) {
        return BigDecimalParser.parse(cArray, 0, cArray.length);
    }

    public static BigDecimal parseWithFastParser(String string) {
        try {
            return JavaBigDecimalParser.parseBigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = string.length() <= 1000 ? string : string.substring(0, 1000) + " [truncated]";
            throw new NumberFormatException("Value \"" + string2 + "\" can not be represented as `java.math.BigDecimal`, reason: " + numberFormatException.getMessage());
        }
    }

    private static BigDecimal parseBigDecimal(char[] cArray, int n2, int n3, int n4) {
        Object object;
        int n5;
        int n6;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n7 = n2;
        int n8 = -1;
        int n9 = -1;
        int n10 = 0;
        int n11 = n2 + n3;
        block6: for (n6 = n2; n6 < n11; ++n6) {
            n5 = cArray[n6];
            switch (n5) {
                case 43: {
                    if (n8 >= 0) {
                        if (bl3) {
                            throw new NumberFormatException("Multiple signs in exponent");
                        }
                        bl3 = true;
                        continue block6;
                    }
                    if (bl2) {
                        throw new NumberFormatException("Multiple signs in number");
                    }
                    bl2 = true;
                    n7 = n6 + 1;
                    continue block6;
                }
                case 45: {
                    if (n8 >= 0) {
                        if (bl3) {
                            throw new NumberFormatException("Multiple signs in exponent");
                        }
                        bl3 = true;
                        continue block6;
                    }
                    if (bl2) {
                        throw new NumberFormatException("Multiple signs in number");
                    }
                    bl2 = true;
                    bl4 = true;
                    n7 = n6 + 1;
                    continue block6;
                }
                case 69: 
                case 101: {
                    if (n8 >= 0) {
                        throw new NumberFormatException("Multiple exponent markers");
                    }
                    n8 = n6;
                    continue block6;
                }
                case 46: {
                    if (n9 >= 0) {
                        throw new NumberFormatException("Multiple decimal points");
                    }
                    n9 = n6;
                    continue block6;
                }
                default: {
                    if (n9 < 0 || n8 != -1) continue block6;
                    ++n10;
                }
            }
        }
        n5 = 0;
        if (n8 >= 0) {
            n6 = n8;
            object = new String(cArray, n8 + 1, n11 - n8 - 1);
            n5 = Integer.parseInt((String)object);
            n10 = BigDecimalParser.adjustScale(n10, n5);
        } else {
            n6 = n11;
        }
        if (n9 >= 0) {
            int n12 = n9 - n7;
            BigDecimal bigDecimal = BigDecimalParser.toBigDecimalRec(cArray, n7, n12, n5, n4);
            int n13 = n6 - n9 - 1;
            BigDecimal bigDecimal2 = BigDecimalParser.toBigDecimalRec(cArray, n9 + 1, n13, n5 - n13, n4);
            object = bigDecimal.add(bigDecimal2);
        } else {
            object = BigDecimalParser.toBigDecimalRec(cArray, n7, n6 - n7, n5, n4);
        }
        if (n10 != 0) {
            object = ((BigDecimal)object).setScale(n10);
        }
        if (bl4) {
            object = ((BigDecimal)object).negate();
        }
        return object;
    }

    private static int adjustScale(int n2, long l2) {
        long l3 = (long)n2 - l2;
        if (l3 > Integer.MAX_VALUE || l3 < Integer.MIN_VALUE) {
            throw new NumberFormatException("Scale out of range: " + l3 + " while adjusting scale " + n2 + " to exponent " + l2);
        }
        return (int)l3;
    }

    private static BigDecimal toBigDecimalRec(char[] cArray, int n2, int n3, int n4, int n5) {
        if (n3 > n5) {
            int n6 = n3 / 2;
            BigDecimal bigDecimal = BigDecimalParser.toBigDecimalRec(cArray, n2, n6, n4 + n3 - n6, n5);
            BigDecimal bigDecimal2 = BigDecimalParser.toBigDecimalRec(cArray, n2 + n6, n3 - n6, n4, n5);
            return bigDecimal.add(bigDecimal2);
        }
        if (n3 == 0) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(cArray, n2, n3).scaleByPowerOfTen(n4);
    }
}

