/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent;

import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.AbstractEventExecutorGroup;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.DefaultEventExecutorChooserFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.DefaultPromise;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.DefaultThreadFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.EventExecutorChooserFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.FutureListener;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.GlobalEventExecutor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.Promise;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.ThreadPerTaskExecutor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MultithreadEventExecutorGroup
extends AbstractEventExecutorGroup {
    private final EventExecutor[] children;
    private final Set<EventExecutor> readonlyChildren;
    private final AtomicInteger terminatedChildren = new AtomicInteger();
    private final Promise<?> terminationFuture = new DefaultPromise(GlobalEventExecutor.INSTANCE);
    private final EventExecutorChooserFactory.EventExecutorChooser chooser;

    protected MultithreadEventExecutorGroup(int n2, ThreadFactory threadFactory, Object ... objectArray) {
        this(n2, (Executor)(threadFactory == null ? null : new ThreadPerTaskExecutor(threadFactory)), objectArray);
    }

    protected MultithreadEventExecutorGroup(int n2, Executor executor, Object ... objectArray) {
        this(n2, executor, DefaultEventExecutorChooserFactory.INSTANCE, objectArray);
    }

    protected MultithreadEventExecutorGroup(int n2, Executor executor, EventExecutorChooserFactory eventExecutorChooserFactory, Object ... objectArray) {
        ObjectUtil.checkPositive(n2, "nThreads");
        if (executor == null) {
            executor = new ThreadPerTaskExecutor(this.newDefaultThreadFactory());
        }
        this.children = new EventExecutor[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl2 = false;
            try {
                this.children[i2] = this.newChild(executor, objectArray);
                bl2 = true;
                continue;
            }
            catch (Exception exception) {
                throw new IllegalStateException("failed to create a child event loop", exception);
            }
            finally {
                if (!bl2) {
                    int n3;
                    for (n3 = 0; n3 < i2; ++n3) {
                        this.children[n3].shutdownGracefully();
                    }
                    for (n3 = 0; n3 < i2; ++n3) {
                        EventExecutor eventExecutor = this.children[n3];
                        try {
                            while (!eventExecutor.isTerminated()) {
                                eventExecutor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
                            }
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                }
            }
        }
        this.chooser = eventExecutorChooserFactory.newChooser(this.children);
        FutureListener<Object> futureListener = new FutureListener<Object>(){

            public void operationComplete(Future<Object> future) throws Exception {
                if (MultithreadEventExecutorGroup.this.terminatedChildren.incrementAndGet() == MultithreadEventExecutorGroup.this.children.length) {
                    MultithreadEventExecutorGroup.this.terminationFuture.setSuccess(null);
                }
            }
        };
        for (EventExecutor eventExecutor : this.children) {
            eventExecutor.terminationFuture().addListener(futureListener);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet(this.children.length);
        Collections.addAll(linkedHashSet, this.children);
        this.readonlyChildren = Collections.unmodifiableSet(linkedHashSet);
    }

    protected ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(this.getClass());
    }

    @Override
    public EventExecutor next() {
        return this.chooser.next();
    }

    @Override
    public Iterator<EventExecutor> iterator() {
        return this.readonlyChildren.iterator();
    }

    protected abstract EventExecutor newChild(Executor var1, Object ... var2) throws Exception;

    @Override
    public Future<?> shutdownGracefully(long l2, long l3, TimeUnit timeUnit) {
        for (EventExecutor eventExecutor : this.children) {
            eventExecutor.shutdownGracefully(l2, l3, timeUnit);
        }
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
        for (EventExecutor eventExecutor : this.children) {
            eventExecutor.shutdown();
        }
    }

    @Override
    public boolean isShuttingDown() {
        for (EventExecutor eventExecutor : this.children) {
            if (eventExecutor.isShuttingDown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isShutdown() {
        for (EventExecutor eventExecutor : this.children) {
            if (eventExecutor.isShutdown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTerminated() {
        for (EventExecutor eventExecutor : this.children) {
            if (eventExecutor.isTerminated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) throws InterruptedException {
        long l3 = System.nanoTime() + timeUnit.toNanos(l2);
        block0: for (EventExecutor eventExecutor : this.children) {
            long l4;
            while ((l4 = l3 - System.nanoTime()) > 0L) {
                if (!eventExecutor.awaitTermination(l4, TimeUnit.NANOSECONDS)) continue;
                continue block0;
            }
            break block0;
        }
        return this.isTerminated();
    }
}

