/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.TestFrameworkTemplate;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.TestNames;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.BaseJunitTestFrameworkStrategy;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.TestFrameworkProvider;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.TestFrameworkStrategy;
import java.lang.reflect.Constructor;
import java.util.Set;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestFramework;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.junit.JUnitOptions;

final class JunitTestFrameworkStrategy
extends BaseJunitTestFrameworkStrategy {
    JunitTestFrameworkStrategy() {
    }

    @Override
    public TestFramework createRetrying(TestFrameworkTemplate testFrameworkTemplate, TestFramework testFramework, TestNames testNames, Set<String> set) {
        DefaultTestFilter defaultTestFilter = this.testFilterFor(testNames, true, testFrameworkTemplate, set);
        return JunitTestFrameworkProvider.testFrameworkProvider(testFrameworkTemplate, testFramework).testFrameworkFor(defaultTestFilter);
    }

    static class JunitTestFrameworkProvider {
        static TestFrameworkProvider testFrameworkProvider(TestFrameworkTemplate testFrameworkTemplate, TestFramework testFramework) {
            if (TestFrameworkStrategy.gradleVersionIsAtLeast("8.0")) {
                return new TestFrameworkProvider.ProviderForCurrentGradleVersion(testFramework);
            }
            return new ProviderForGradleOlderThanV8(testFrameworkTemplate);
        }

        static class ProviderForGradleOlderThanV8
        implements TestFrameworkProvider {
            private final TestFrameworkTemplate template;

            ProviderForGradleOlderThanV8(TestFrameworkTemplate testFrameworkTemplate) {
                this.template = testFrameworkTemplate;
            }

            @Override
            public TestFramework testFrameworkFor(DefaultTestFilter defaultTestFilter) {
                JUnitTestFramework jUnitTestFramework = ProviderForGradleOlderThanV8.newInstance(this.template.task, defaultTestFilter);
                ProviderForGradleOlderThanV8.copyOptions((JUnitOptions)this.template.task.getTestFramework().getOptions(), jUnitTestFramework.getOptions());
                return jUnitTestFramework;
            }

            private static JUnitTestFramework newInstance(Test test, DefaultTestFilter defaultTestFilter) {
                try {
                    Class<JUnitTestFramework> clazz = JUnitTestFramework.class;
                    Constructor constructor = clazz.getConstructor(Test.class, DefaultTestFilter.class);
                    return (JUnitTestFramework)constructor.newInstance(test, defaultTestFilter);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new RuntimeException(reflectiveOperationException);
                }
            }

            private static void copyOptions(JUnitOptions jUnitOptions, JUnitOptions jUnitOptions2) {
                jUnitOptions2.setIncludeCategories(jUnitOptions.getIncludeCategories());
                jUnitOptions2.setExcludeCategories(jUnitOptions.getExcludeCategories());
            }
        }
    }
}

