/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.function.BiFunction;

public final class DecimalUtils {
    private static final BigDecimal ONE_BILLION = new BigDecimal(1000000000L);

    public static String toDecimal(long l2, int n2) {
        StringBuilder stringBuilder = new StringBuilder(20).append(l2).append('.');
        if ((long)n2 == 0L) {
            if (l2 == 0L) {
                return "0.0";
            }
            stringBuilder.append("000000000");
        } else {
            StringBuilder stringBuilder2 = new StringBuilder(9);
            stringBuilder2.append(n2);
            int n3 = stringBuilder2.length();
            for (int i2 = 9 - n3; i2 > 0; --i2) {
                stringBuilder.append('0');
            }
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        return stringBuilder.toString();
    }

    public static BigDecimal toBigDecimal(long l2, int n2) {
        if ((long)n2 == 0L) {
            if (l2 == 0L) {
                return BigDecimal.ZERO.setScale(1);
            }
            return BigDecimal.valueOf(l2).setScale(9);
        }
        return NumberInput.parseBigDecimal(DecimalUtils.toDecimal(l2, n2), false);
    }

    public static <T> T extractSecondsAndNanos(BigDecimal bigDecimal, BiFunction<Long, Integer, T> biFunction) {
        long l2;
        int n2;
        BigDecimal bigDecimal2 = bigDecimal.scaleByPowerOfTen(9);
        if (bigDecimal2.precision() - bigDecimal2.scale() <= 0) {
            n2 = 0;
            l2 = 0;
        } else if (bigDecimal.scale() < -63) {
            n2 = 0;
            l2 = 0;
        } else {
            l2 = bigDecimal.longValue();
            n2 = bigDecimal2.subtract(BigDecimal.valueOf(l2).scaleByPowerOfTen(9)).intValue();
            if (l2 < 0L && l2 > Instant.MIN.getEpochSecond()) {
                n2 = Math.abs(n2);
            }
        }
        return biFunction.apply(l2, n2);
    }
}

