/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.message;

import com.gradle.scan.plugin.internal.dep.org.apache.http.FormattedHeader;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HeaderElement;
import com.gradle.scan.plugin.internal.dep.org.apache.http.ParseException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.message.BasicHeaderValueParser;
import com.gradle.scan.plugin.internal.dep.org.apache.http.message.ParserCursor;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.CharArrayBuffer;
import java.io.Serializable;

public class BufferedHeader
implements Serializable,
Cloneable,
FormattedHeader {
    private final String name;
    private final CharArrayBuffer buffer;
    private final int valuePos;

    public BufferedHeader(CharArrayBuffer charArrayBuffer) throws ParseException {
        Args.notNull(charArrayBuffer, "Char array buffer");
        int n2 = charArrayBuffer.indexOf(58);
        if (n2 == -1) {
            throw new ParseException("Invalid header: " + charArrayBuffer.toString());
        }
        String string = charArrayBuffer.substringTrimmed(0, n2);
        if (string.isEmpty()) {
            throw new ParseException("Invalid header: " + charArrayBuffer.toString());
        }
        this.buffer = charArrayBuffer;
        this.name = string;
        this.valuePos = n2 + 1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.buffer.substringTrimmed(this.valuePos, this.buffer.length());
    }

    @Override
    public HeaderElement[] getElements() throws ParseException {
        ParserCursor parserCursor = new ParserCursor(0, this.buffer.length());
        parserCursor.updatePos(this.valuePos);
        return BasicHeaderValueParser.INSTANCE.parseElements(this.buffer, parserCursor);
    }

    @Override
    public int getValuePos() {
        return this.valuePos;
    }

    @Override
    public CharArrayBuffer getBuffer() {
        return this.buffer;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

