/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.StreamReadCapability;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.util.DurationUnitConverter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Duration;
import java.util.Objects;

public class DurationDeserializer
extends JSR310DeserializerBase<Duration>
implements ContextualDeserializer {
    public static final DurationDeserializer INSTANCE = new DurationDeserializer();
    protected final DurationUnitConverter _durationUnitConverter;
    protected final Boolean _readTimestampsAsNanosOverride;

    public DurationDeserializer() {
        super(Duration.class);
        this._durationUnitConverter = null;
        this._readTimestampsAsNanosOverride = null;
    }

    protected DurationDeserializer(DurationDeserializer durationDeserializer, Boolean bl2, DurationUnitConverter durationUnitConverter, Boolean bl3) {
        super(durationDeserializer, bl2);
        this._durationUnitConverter = durationUnitConverter;
        this._readTimestampsAsNanosOverride = bl3;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        JsonFormat.Value value = this.findFormatOverrides(deserializationContext, beanProperty, this.handledType());
        DurationDeserializer durationDeserializer = this;
        boolean bl2 = this._isLenient;
        DurationUnitConverter durationUnitConverter = this._durationUnitConverter;
        Boolean bl3 = this._readTimestampsAsNanosOverride;
        if (value != null) {
            String string;
            if (value.hasLenient()) {
                bl2 = value.getLenient();
            }
            if (value.hasPattern() && (durationUnitConverter = DurationUnitConverter.from(string = value.getPattern())) == null) {
                deserializationContext.reportBadDefinition(this.getValueType(deserializationContext), String.format("Bad 'pattern' definition (\"%s\") for `Duration`: expected one of [%s]", string, DurationUnitConverter.descForAllowed()));
            }
            bl3 = value.getFeature(JsonFormat.Feature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
        }
        if (bl2 != this._isLenient || !Objects.equals(durationUnitConverter, this._durationUnitConverter) || !Objects.equals(bl3, this._readTimestampsAsNanosOverride)) {
            return new DurationDeserializer(this, bl2, durationUnitConverter, bl3);
        }
        return durationDeserializer;
    }

    @Override
    public Duration deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.currentTokenId()) {
            case 8: {
                BigDecimal bigDecimal = jsonParser.getDecimalValue();
                return DecimalUtils.extractSecondsAndNanos(bigDecimal, Duration::ofSeconds, false);
            }
            case 7: {
                return this._fromTimestamp(deserializationContext, jsonParser.getLongValue());
            }
            case 6: {
                return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
            }
            case 12: {
                return (Duration)jsonParser.getEmbeddedObject();
            }
            case 3: {
                return (Duration)this._deserializeFromArray(jsonParser, deserializationContext);
            }
            case 1: {
                String string = deserializationContext.extractScalarFromObject(jsonParser, this, this.handledType());
                if (string == null) break;
                return this._fromString(jsonParser, deserializationContext, string);
            }
        }
        return (Duration)this._handleUnexpectedToken(deserializationContext, jsonParser, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT);
    }

    protected Duration _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return (Duration)this._fromEmptyString(jsonParser, deserializationContext, string2);
        }
        if (deserializationContext.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(string2)) {
            return this._fromTimestamp(deserializationContext, NumberInput.parseLong(string2));
        }
        try {
            return Duration.parse(string2);
        }
        catch (DateTimeException dateTimeException) {
            return (Duration)this._handleDateTimeException(deserializationContext, dateTimeException, string2);
        }
    }

    protected Duration _fromTimestamp(DeserializationContext deserializationContext, long l2) {
        if (this._durationUnitConverter != null) {
            return this._durationUnitConverter.convert(l2);
        }
        if (this.shouldReadTimestampsAsNanoseconds(deserializationContext)) {
            return Duration.ofSeconds(l2);
        }
        return Duration.ofMillis(l2);
    }

    protected boolean shouldReadTimestampsAsNanoseconds(DeserializationContext deserializationContext) {
        return this._readTimestampsAsNanosOverride != null ? this._readTimestampsAsNanosOverride.booleanValue() : deserializationContext.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
    }
}

