/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.buffer;

import java.util.Arrays;

final class IntPriorityQueue {
    private int[] array = new int[9];
    private int size;

    IntPriorityQueue() {
    }

    public void offer(int n2) {
        if (n2 == -1) {
            throw new IllegalArgumentException("The NO_VALUE (-1) cannot be added to the queue.");
        }
        ++this.size;
        if (this.size == this.array.length) {
            this.array = Arrays.copyOf(this.array, 1 + (this.array.length - 1) * 2);
        }
        this.array[this.size] = n2;
        this.lift(this.size);
    }

    public void remove(int n2) {
        for (int i2 = 1; i2 <= this.size; ++i2) {
            if (this.array[i2] != n2) continue;
            this.array[i2] = this.array[this.size--];
            this.lift(i2);
            this.sink(i2);
            return;
        }
    }

    public int poll() {
        if (this.size == 0) {
            return -1;
        }
        int n2 = this.array[1];
        this.array[1] = this.array[this.size];
        this.array[this.size] = 0;
        --this.size;
        this.sink(1);
        return n2;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private void lift(int n2) {
        int n3;
        while (n2 > 1 && this.subord(n3 = n2 >> 1, n2)) {
            this.swap(n2, n3);
            n2 = n3;
        }
    }

    private void sink(int n2) {
        int n3;
        while ((n3 = n2 << 1) <= this.size) {
            if (n3 < this.size && this.subord(n3, n3 + 1)) {
                ++n3;
            }
            if (!this.subord(n2, n3)) break;
            this.swap(n2, n3);
            n2 = n3;
        }
    }

    private boolean subord(int n2, int n3) {
        return this.array[n2] > this.array[n3];
    }

    private void swap(int n2, int n3) {
        int n4 = this.array[n2];
        this.array[n2] = this.array[n3];
        this.array[n3] = n4;
    }
}

