/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.buffer;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ReadOnlyByteBufferBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.UnsafeByteBufUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class ReadOnlyUnsafeDirectByteBuf
extends ReadOnlyByteBufferBuf {
    private final long memoryAddress;

    ReadOnlyUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer) {
        super(byteBufAllocator, byteBuffer);
        this.memoryAddress = PlatformDependent.directBufferAddress(this.buffer);
    }

    @Override
    protected byte _getByte(int n2) {
        return UnsafeByteBufUtil.getByte(this.addr(n2));
    }

    @Override
    protected short _getShort(int n2) {
        return UnsafeByteBufUtil.getShort(this.addr(n2));
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(n2));
    }

    @Override
    protected int _getInt(int n2) {
        return UnsafeByteBufUtil.getInt(this.addr(n2));
    }

    @Override
    protected long _getLong(int n2) {
        return UnsafeByteBufUtil.getLong(this.addr(n2));
    }

    @Override
    protected ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4, boolean bl2) {
        this.checkIndex(n2, n4);
        ObjectUtil.checkNotNull(byteBuf, "dst");
        if (n3 < 0 || n3 > byteBuf.capacity() - n4) {
            throw new IndexOutOfBoundsException("dstIndex: " + n3);
        }
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory(this.addr(n2), byteBuf.memoryAddress() + (long)n3, n4);
        } else if (byteBuf.hasArray()) {
            PlatformDependent.copyMemory(this.addr(n2), byteBuf.array(), byteBuf.arrayOffset() + n3, (long)n4);
        } else {
            byteBuf.setBytes(n3, this, n2, n4);
        }
        return this;
    }

    @Override
    protected ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4, boolean bl2) {
        this.checkIndex(n2, n4);
        ObjectUtil.checkNotNull(byArray, "dst");
        if (n3 < 0 || n3 > byArray.length - n4) {
            throw new IndexOutOfBoundsException(String.format("dstIndex: %d, length: %d (expected: range(0, %d))", n3, n4, byArray.length));
        }
        if (n4 != 0) {
            PlatformDependent.copyMemory(this.addr(n2), byArray, n3, (long)n4);
        }
        return this;
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        return this.memoryAddress;
    }

    private long addr(int n2) {
        return this.memoryAddress + (long)n2;
    }
}

