/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.pool;

import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;
import java.util.concurrent.TimeUnit;

public abstract class PoolEntry<T, C> {
    private final String id;
    private final T route;
    private final C conn;
    private final long created;
    private final long validityDeadline;
    private long updated;
    private long expiry;
    private volatile Object state;

    public PoolEntry(String string, T t2, C c2, long l2, TimeUnit timeUnit) {
        long l3;
        Args.notNull(t2, "Route");
        Args.notNull(c2, "Connection");
        Args.notNull(timeUnit, "Time unit");
        this.id = string;
        this.route = t2;
        this.conn = c2;
        this.updated = this.created = System.currentTimeMillis();
        this.validityDeadline = l2 > 0L ? ((l3 = this.created + timeUnit.toMillis(l2)) > 0L ? l3 : Long.MAX_VALUE) : Long.MAX_VALUE;
        this.expiry = this.validityDeadline;
    }

    public String getId() {
        return this.id;
    }

    public T getRoute() {
        return this.route;
    }

    public C getConnection() {
        return this.conn;
    }

    public Object getState() {
        return this.state;
    }

    public void setState(Object object) {
        this.state = object;
    }

    public synchronized long getUpdated() {
        return this.updated;
    }

    public synchronized long getExpiry() {
        return this.expiry;
    }

    public synchronized void updateExpiry(long l2, TimeUnit timeUnit) {
        Args.notNull(timeUnit, "Time unit");
        this.updated = System.currentTimeMillis();
        long l3 = l2 > 0L ? this.updated + timeUnit.toMillis(l2) : Long.MAX_VALUE;
        this.expiry = Math.min(l3, this.validityDeadline);
    }

    public synchronized boolean isExpired(long l2) {
        return l2 >= this.expiry;
    }

    public abstract void close();

    public abstract boolean isClosed();

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[id:");
        stringBuilder.append(this.id);
        stringBuilder.append("][route:");
        stringBuilder.append(this.route);
        stringBuilder.append("][state:");
        stringBuilder.append(this.state);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

