/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.testsreader.TestsReader;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.AnnotationVisitor;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.MethodVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class TestNgClassVisitor
extends TestsReader.Visitor<ClassInfo> {
    private static final List<String> LIFECYCLE_ANNOTATION_DESCRIPTORS = Arrays.asList("Lorg/testng/annotations/BeforeClass;", "Lorg/testng/annotations/BeforeTest;", "Lorg/testng/annotations/BeforeMethod;", "Lorg/testng/annotations/AfterTest;", "Lorg/testng/annotations/AfterClass;", "Lorg/testng/annotations/AfterMethod;");
    private String currentMethod;
    private final ClassInfo classInfo = new ClassInfo();
    private final TestNGMethodVisitor methodVisitor = new TestNGMethodVisitor();

    TestNgClassVisitor() {
    }

    @Override
    public ClassInfo getResult() {
        return this.classInfo;
    }

    @Override
    public MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        this.currentMethod = string;
        return this.methodVisitor;
    }

    @Override
    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        this.classInfo.superClass = string3.replace('/', '.');
    }

    static final class ClassInfo {
        private final Map<String, List<String>> dependsOn = new HashMap<String, List<String>>();
        private final Map<String, List<String>> dependedOn = new HashMap<String, List<String>>();
        private final Set<String> lifecycleMethods = new HashSet<String>();
        private String superClass;

        ClassInfo() {
        }

        Set<String> dependsOn(String string2) {
            HashSet<String> hashSet = new HashSet<String>();
            List<String> list = Collections.singletonList(string2);
            while (!list.isEmpty()) {
                list = list.stream().flatMap(string -> this.dependsOn.getOrDefault(string, Collections.emptyList()).stream()).filter(string -> !hashSet.contains(string)).collect(Collectors.toList());
                hashSet.addAll(list);
            }
            list = Collections.singletonList(string2);
            while (!list.isEmpty()) {
                list = list.stream().flatMap(string -> this.dependedOn.getOrDefault(string, Collections.emptyList()).stream()).filter(string -> !hashSet.contains(string)).collect(Collectors.toList());
                hashSet.addAll(list);
            }
            return hashSet;
        }

        @Nullable
        public String getSuperClass() {
            return this.superClass;
        }

        public Set<String> getLifecycleMethods() {
            return this.lifecycleMethods;
        }
    }

    private final class TestNGMethodVisitor
    extends MethodVisitor {
        private final TestNGTestAnnotationVisitor testAnnotationVisitor;

        public TestNGMethodVisitor() {
            super(458752);
            this.testAnnotationVisitor = new TestNGTestAnnotationVisitor();
        }

        @Override
        public AnnotationVisitor visitAnnotation(String string, boolean bl2) {
            if (string.contains("org/testng/annotations/Test")) {
                return this.testAnnotationVisitor;
            }
            if (LIFECYCLE_ANNOTATION_DESCRIPTORS.contains(string)) {
                TestNgClassVisitor.this.classInfo.lifecycleMethods.add(TestNgClassVisitor.this.currentMethod);
            }
            return null;
        }
    }

    private final class TestNGTestDependsOnAnnotationVisitor
    extends AnnotationVisitor {
        public TestNGTestDependsOnAnnotationVisitor() {
            super(458752);
        }

        @Override
        public void visit(String string2, Object object) {
            TestNgClassVisitor.this.classInfo.dependsOn.compute(TestNgClassVisitor.this.currentMethod, (string, arrayList) -> {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add((String)object);
                return arrayList;
            });
            TestNgClassVisitor.this.classInfo.dependedOn.compute((String)object, (string, arrayList) -> {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(TestNgClassVisitor.this.currentMethod);
                return arrayList;
            });
        }
    }

    private final class TestNGTestAnnotationVisitor
    extends AnnotationVisitor {
        private final TestNGTestDependsOnAnnotationVisitor dependsOnAnnotationVisitor;

        public TestNGTestAnnotationVisitor() {
            super(458752);
            this.dependsOnAnnotationVisitor = new TestNGTestDependsOnAnnotationVisitor();
        }

        @Override
        public AnnotationVisitor visitArray(String string) {
            if ("dependsOnMethods".equals(string)) {
                return this.dependsOnAnnotationVisitor;
            }
            return null;
        }
    }
}

