/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.gradleplugin.testdistribution.internal;

import com.gradle.enterprise.gradleplugin.testdistribution.internal.ProcessedResourcesSpec;
import com.gradle.enterprise.gradleplugin.testdistribution.internal.TestDistributionExtensionInternal;
import com.gradle.enterprise.gradleplugin.testdistribution.internal.WorkspaceRootSpec;
import com.gradle.enterprise.gradleplugin.testdistribution.internal.e;
import com.gradle.enterprise.gradleplugin.testdistribution.internal.p;
import com.gradle.enterprise.testdistribution.client.filterer.TestPlanFilterer;
import com.gradle.enterprise.testdistribution.obfuscated.af.b;
import com.gradle.enterprise.testdistribution.obfuscated.ah.c;
import com.gradle.enterprise.testdistribution.obfuscated.ah.d;
import com.gradle.enterprise.testdistribution.obfuscated.au.ad;
import java.io.File;
import java.net.URI;
import java.time.Duration;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.testing.Test;

public class DefaultTestDistributionExtension
implements TestDistributionExtensionInternal {
    private static final String ACCESS_KEYS_PATH_IN_GRADLE_USER_HOME = "enterprise/keys.properties";
    private static final String DEFAULT_TEST_DISTRIBUTION_OUTPUTS_LOCATION = "test-distribution-outputs";
    private final Property<Boolean> enabled;
    private final Property<Integer> maxLocalExecutors;
    private final Property<Integer> maxRemoteExecutors;
    private final Property<Boolean> remoteExecutionPreferred;
    private final Property<Duration> waitTimeout;
    private final NamedDomainObjectContainer<ProcessedResourcesSpec> processedResources;
    private final SetProperty<String> requirements;
    private final Property<com.gradle.enterprise.testdistribution.obfuscated.af.a> buildScanFacade;
    private final Property<URI> server;
    private final Property<String> accessKey;
    private final Property<Boolean> allowUntrustedServer;
    private final Property<Boolean> writeTraceFile;
    private final Property<Boolean> writeTestEventLogFile;
    private final Property<Duration> forkedVMShutdownTimeout;
    private final Property<Boolean> failOnPassedAfterRetry;
    private final Property<Integer> maxRetries;
    private final Property<Integer> maxFailures;
    private final Property<Duration> preferredMaxDuration;
    private final Property<TestPlanFilterer> testPlanFilterer;
    private final Property<Boolean> showStacktraces;
    private final Property<Boolean> allowUseWithoutBuildScans;
    private final DirectoryProperty testDistributionOutputs;
    private final RegularFileProperty accessKeyLocation;
    private final Property<String> rootProjectName;
    private final NamedDomainObjectContainer<WorkspaceRootSpec> workspaceRoots;

    public DefaultTestDistributionExtension(Test test) {
        Project project = test.getProject();
        Project rootProject = project.getRootProject();
        ObjectFactory objectFactory = project.getObjects();
        this.enabled = objectFactory.property(Boolean.class).convention((Object)false);
        this.maxLocalExecutors = objectFactory.property(Integer.class).convention(project.provider(() -> ((Test)test).getMaxParallelForks()));
        this.maxRemoteExecutors = objectFactory.property(Integer.class);
        this.remoteExecutionPreferred = objectFactory.property(Boolean.class).convention((Object)false);
        this.preferredMaxDuration = objectFactory.property(Duration.class);
        this.testPlanFilterer = objectFactory.property(TestPlanFilterer.class);
        this.waitTimeout = objectFactory.property(Duration.class).convention((Object)Duration.ofSeconds(30L));
        this.processedResources = project.container(ProcessedResourcesSpec.class, (NamedDomainObjectFactory)new a(objectFactory));
        this.requirements = objectFactory.setProperty(String.class).empty();
        this.buildScanFacade = objectFactory.property(com.gradle.enterprise.testdistribution.obfuscated.af.a.class).convention(project.provider(() -> b.a(rootProject)));
        this.server = objectFactory.property(URI.class).convention(DefaultTestDistributionExtension.getServer(project, this.buildScanFacade));
        this.accessKey = objectFactory.property(String.class).convention(DefaultTestDistributionExtension.getAccessKey(project, this.buildScanFacade));
        this.allowUntrustedServer = objectFactory.property(Boolean.class).convention(DefaultTestDistributionExtension.getAllowUntrusted(project, this.buildScanFacade));
        this.writeTraceFile = objectFactory.property(Boolean.class).convention(project.provider(() -> p.b(project)));
        this.writeTestEventLogFile = objectFactory.property(Boolean.class).convention(project.provider(() -> p.c(project)));
        this.forkedVMShutdownTimeout = objectFactory.property(Duration.class).convention((Object)ad.a);
        Provider testRetry = project.provider(() -> d.a(test, project));
        this.maxRetries = objectFactory.property(Integer.class).convention(testRetry.flatMap(c::a));
        this.maxFailures = objectFactory.property(Integer.class).convention(testRetry.flatMap(c::b));
        this.failOnPassedAfterRetry = objectFactory.property(Boolean.class).convention(testRetry.flatMap(c::c));
        this.showStacktraces = objectFactory.property(Boolean.class).convention((Object)(project.getGradle().getStartParameter().getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS ? 1 : 0));
        this.rootProjectName = objectFactory.property(String.class).convention((Object)project.getRootProject().getName());
        this.allowUseWithoutBuildScans = objectFactory.property(Boolean.class).convention((Object)p.a(project));
        this.testDistributionOutputs = objectFactory.directoryProperty().convention(project.getLayout().getBuildDirectory().dir("test-distribution-outputs/" + test.getName()));
        this.workspaceRoots = project.container(WorkspaceRootSpec.class);
        this.workspaceRoots.add((Object)new WorkspaceRootSpec("rootDir", project.getRootDir().toPath()));
        this.workspaceRoots.add((Object)new WorkspaceRootSpec("projectDir", project.getProjectDir().toPath()));
        File gradleHomeDir = project.getGradle().getGradleHomeDir();
        if (gradleHomeDir != null) {
            this.workspaceRoots.add((Object)new WorkspaceRootSpec("gradleHome", gradleHomeDir.toPath()));
        }
        File gradleUserHomeDir = project.getGradle().getGradleUserHomeDir();
        this.workspaceRoots.add((Object)new WorkspaceRootSpec("gradleUserHome", gradleUserHomeDir.toPath()));
        this.accessKeyLocation = objectFactory.fileProperty().convention(project.getLayout().file(project.provider(() -> new File(gradleUserHomeDir, ACCESS_KEYS_PATH_IN_GRADLE_USER_HOME))));
    }

    private static Provider<URI> getServer(Project project, Property<com.gradle.enterprise.testdistribution.obfuscated.af.a> buildScanFacade) {
        if (e.h()) {
            return buildScanFacade.map(com.gradle.enterprise.testdistribution.obfuscated.af.a::a);
        }
        return project.provider(() -> {
            if (buildScanFacade.isPresent()) {
                return ((com.gradle.enterprise.testdistribution.obfuscated.af.a)buildScanFacade.get()).a();
            }
            return null;
        });
    }

    private static Provider<String> getAccessKey(Project project, Property<com.gradle.enterprise.testdistribution.obfuscated.af.a> buildScanFacade) {
        if (e.h()) {
            return buildScanFacade.map(com.gradle.enterprise.testdistribution.obfuscated.af.a::b);
        }
        return project.provider(() -> {
            if (buildScanFacade.isPresent()) {
                return ((com.gradle.enterprise.testdistribution.obfuscated.af.a)buildScanFacade.get()).b();
            }
            return null;
        });
    }

    private static Provider<Boolean> getAllowUntrusted(Project project, Property<com.gradle.enterprise.testdistribution.obfuscated.af.a> buildScanFacade) {
        Provider allowUntrusted = buildScanFacade.map(com.gradle.enterprise.testdistribution.obfuscated.af.a::c);
        if (e.b()) {
            return allowUntrusted.orElse((Object)false);
        }
        return project.provider(() -> {
            if (buildScanFacade.isPresent()) {
                return ((com.gradle.enterprise.testdistribution.obfuscated.af.a)buildScanFacade.get()).c();
            }
            return false;
        });
    }

    @Override
    public Property<Boolean> getEnabled() {
        return this.enabled;
    }

    @Override
    public Property<Integer> getMaxLocalExecutors() {
        return this.maxLocalExecutors;
    }

    @Override
    public Property<Integer> getMaxRemoteExecutors() {
        return this.maxRemoteExecutors;
    }

    @Override
    public Property<Boolean> getRemoteExecutionPreferred() {
        return this.remoteExecutionPreferred;
    }

    @Override
    public Property<Duration> getWaitTimeout() {
        return this.waitTimeout;
    }

    @Override
    public NamedDomainObjectContainer<ProcessedResourcesSpec> getProcessedResources() {
        return this.processedResources;
    }

    @Override
    public void processedResources(Action<? super NamedDomainObjectContainer<ProcessedResourcesSpec>> action) {
        action.execute(this.processedResources);
    }

    @Override
    public SetProperty<String> getRequirements() {
        return this.requirements;
    }

    @Override
    public Property<com.gradle.enterprise.testdistribution.obfuscated.af.a> getBuildScanFacade() {
        return this.buildScanFacade;
    }

    @Override
    public Property<URI> getServer() {
        return this.server;
    }

    @Override
    public Property<String> getAccessKey() {
        return this.accessKey;
    }

    @Override
    public Property<Boolean> getAllowUntrustedServer() {
        return this.allowUntrustedServer;
    }

    @Override
    public Property<Boolean> getWriteTraceFile() {
        return this.writeTraceFile;
    }

    @Override
    public Property<Boolean> getWriteTestEventLogFile() {
        return this.writeTestEventLogFile;
    }

    @Override
    public Property<Duration> getForkedVMShutdownTimeout() {
        return this.forkedVMShutdownTimeout;
    }

    @Override
    public Property<Boolean> getFailOnPassedAfterRetry() {
        return this.failOnPassedAfterRetry;
    }

    @Override
    public Property<Boolean> getShowStacktraces() {
        return this.showStacktraces;
    }

    @Override
    public Property<String> getRootProjectName() {
        return this.rootProjectName;
    }

    @Override
    public NamedDomainObjectContainer<WorkspaceRootSpec> getWorkspaceRoots() {
        return this.workspaceRoots;
    }

    @Override
    public Property<Boolean> getAllowUseWithoutBuildScans() {
        return this.allowUseWithoutBuildScans;
    }

    @Override
    public DirectoryProperty getTestDistributionOutputs() {
        return this.testDistributionOutputs;
    }

    @Override
    public RegularFileProperty getAccessKeyLocation() {
        return this.accessKeyLocation;
    }

    @Override
    public Property<Integer> getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public Property<Integer> getMaxFailures() {
        return this.maxFailures;
    }

    @Override
    public Property<Duration> getPreferredMaxDuration() {
        return this.preferredMaxDuration;
    }

    @Override
    public void registerTestPlanFilterer(TestPlanFilterer testPlanFilterer) {
        this.testPlanFilterer.set((Object)testPlanFilterer);
    }

    @Override
    public Property<TestPlanFilterer> getTestPlanFilterer() {
        return this.testPlanFilterer;
    }

    public boolean shouldTestRetryPluginBeDeactivated() {
        this.enabled.finalizeValue();
        return (Boolean)this.enabled.get();
    }

    private static class a
    implements NamedDomainObjectFactory<ProcessedResourcesSpec> {
        private final ObjectFactory a;

        @Inject
        public a(ObjectFactory objectFactory) {
            this.a = objectFactory;
        }

        public ProcessedResourcesSpec a(String name) {
            return (ProcessedResourcesSpec)this.a.newInstance(ProcessedResourcesSpec.class, new Object[]{name, this.a});
        }

        public /* synthetic */ Object create(String string) {
            return this.a(string);
        }
    }
}

