/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.gradleplugin.testdistribution.internal;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.process.CommandLineArgumentProvider;

class GradleDistribution
implements CommandLineArgumentProvider {
    private final Path gradleHome;
    private final Project project;

    GradleDistribution(Path gradleHome, Project project) {
        this.gradleHome = gradleHome;
        this.project = project;
    }

    @Classpath
    public Set<File> getLibs() {
        Path libDir = this.gradleHome.resolve("lib");
        return GradleDistribution.asSortedSet(this.project.fileTree((Object)libDir, tree -> tree.include(new String[]{"*.jar"})));
    }

    @Classpath
    public Set<File> getPlugins() {
        Path pluginsDir = this.gradleHome.resolve("lib/plugins");
        return GradleDistribution.asSortedSet(this.project.fileTree((Object)pluginsDir, tree -> tree.include(new String[]{"*.jar"})));
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getStaticContent() {
        return this.project.fileTree((Object)this.gradleHome, tree -> {
            tree.exclude(new String[]{"lib/**"});
            tree.exclude(new String[]{"samples/**"});
            tree.exclude(new String[]{"src/**"});
            tree.exclude(new String[]{"docs/**"});
            tree.exclude(new String[]{"getting-started.html"});
        });
    }

    private static NavigableSet<File> asSortedSet(ConfigurableFileTree files) {
        return new TreeSet<File>(files.getFiles());
    }

    public Iterable<String> asArguments() {
        return Collections.emptyList();
    }
}

