/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.client.output;

import com.gradle.enterprise.testdistribution.client.output.OutputMergeException;
import com.gradle.enterprise.testdistribution.client.output.d;
import com.gradle.enterprise.testdistribution.obfuscated.ao.g;
import com.gradle.enterprise.testdistribution.obfuscated.as.a;
import com.gradle.enterprise.testdistribution.obfuscated.as.c;
import com.gradle.enterprise.testdistribution.obfuscated.bh.z;
import com.gradle.nullability.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@SuppressFBWarnings(value={"SECPTI"}, justification="Reading path that we created on the build agent is intentional")
public class b {
    private final Path a;
    private final d b;
    private final ConcurrentMap<Path, b> c = new ConcurrentHashMap<Path, b>();
    private final ConcurrentMap<z, a> d = new ConcurrentHashMap<z, a>();
    private boolean e;

    public b(Path storage, d registry) {
        if (!Files.isDirectory(storage, new LinkOption[0])) {
            throw new IllegalArgumentException("Storage " + storage + " is not a directory");
        }
        this.a = storage;
        this.b = registry;
    }

    @Nullable
    public synchronized a a(g command, z sessionId) {
        if (this.e) {
            return null;
        }
        Path targetPath = Paths.get(command.a(), new String[0]);
        b fragmentStore = this.c.computeIfAbsent(targetPath, destination -> new b(this.a((Path)destination), command.b()));
        Path tempFile = fragmentStore.a().resolve(targetPath.getFileName().toString() + sessionId);
        a fragment = new a(tempFile, fragmentStore.b());
        this.d.put(sessionId, fragment);
        return fragment;
    }

    @Nullable
    public synchronized a a(com.gradle.enterprise.testdistribution.obfuscated.ao.b fileChunkMessage, z sessionId) {
        if (this.e) {
            return null;
        }
        a fragment = (a)this.d.get(sessionId);
        fragment.a(fileChunkMessage.a(), fileChunkMessage.b());
        return fragment;
    }

    public synchronized void a() throws IOException {
        this.e = true;
        for (Map.Entry destinationToStorage : this.c.entrySet()) {
            Path destination = (Path)destinationToStorage.getKey();
            b fragmentStore = (b)destinationToStorage.getValue();
            if (fragmentStore.b()) {
                com.gradle.enterprise.testdistribution.client.output.b.b(destination, fragmentStore);
                continue;
            }
            this.a(destination, fragmentStore);
        }
        com.gradle.enterprise.testdistribution.obfuscated.bl.a.a(this.a);
    }

    private Path a(Path destination) {
        try {
            return Files.createTempDirectory(this.a, destination.getFileName().toString(), new FileAttribute[0]);
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private void a(Path destination, b store) throws IOException {
        if (!this.b.a(destination, store.c())) {
            throw new OutputMergeException("Test sessions created conflicting fragments for output file '" + destination + "'");
        }
        this.b.b(destination, store.c());
    }

    private static void b(final Path destination, b store) throws IOException {
        final HashSet writtenFiles = new HashSet();
        final TreeSet failedFiles = new TreeSet();
        for (final Path fragment : store.c()) {
            Files.walkFileTree(fragment, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                public FileVisitResult a(Path dir, BasicFileAttributes attrs) throws IOException {
                    Files.createDirectories(destination.resolve(fragment.relativize(dir)), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult b(Path file, BasicFileAttributes attrs) throws IOException {
                    Path target = destination.resolve(fragment.relativize(file));
                    if (writtenFiles.add(target)) {
                        Files.move(file, target, StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        failedFiles.add(target);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                    return this.b((Path)object, basicFileAttributes);
                }

                @Override
                public /* synthetic */ FileVisitResult preVisitDirectory(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                    return this.a((Path)object, basicFileAttributes);
                }
            });
        }
        if (!failedFiles.isEmpty()) {
            String formattedFailedFiles = failedFiles.stream().map(destination::relativize).map(Objects::toString).collect(Collectors.joining("', '", "'", "'"));
            throw new OutputMergeException("Test sessions created conflicting fragments in output directory '" + destination + "' for " + formattedFailedFiles);
        }
    }

    public static final class a {
        private final Path a;
        private final a.a b;
        private long c;

        private a(Path path, boolean directory) {
            this.a = path;
            this.b = new a.a(path, directory);
        }

        private void a(com.gradle.enterprise.testdistribution.obfuscated.bb.a content, boolean last) {
            this.c += (long)content.a().length;
            this.b.a(content, last);
            if (last) {
                this.a(this.b.b());
                this.b.close();
            }
        }

        private void a(Path path) {
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                com.gradle.enterprise.testdistribution.obfuscated.as.c.a(in, this.b.a(), this.a);
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        public Path a() {
            return this.a;
        }

        public boolean b() {
            return this.b.a();
        }

        public long c() {
            return this.c;
        }
    }

    private static final class b {
        private final Path a;
        private final boolean b;

        private b(Path store, boolean storesDirectories) {
            this.a = store;
            this.b = storesDirectories;
        }

        private Path a() {
            return this.a;
        }

        private boolean b() {
            return this.b;
        }

        private List<Path> c() throws IOException {
            try (Stream<Path> files = Files.list(this.a);){
                List<Path> list = files.collect(Collectors.toList());
                return list;
            }
        }
    }
}

