/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.io;

import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.KryoException;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.io.Input;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class ByteBufferInput
extends Input {
    protected ByteBuffer niobuffer;
    protected boolean varIntsEnabled = true;
    ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected static final ByteOrder nativeOrder = ByteOrder.nativeOrder();

    public ByteBufferInput() {
    }

    public ByteBufferInput(ByteBuffer buffer) {
        this.setBuffer(buffer);
    }

    public void setBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        this.niobuffer = buffer;
        this.position = buffer.position();
        this.limit = buffer.limit();
        this.capacity = buffer.capacity();
        this.byteOrder = buffer.order();
        this.total = 0L;
        this.inputStream = null;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    protected int fill(ByteBuffer buffer, int offset, int count) throws KryoException {
        if (this.inputStream == null) {
            return -1;
        }
        try {
            byte[] tmp = new byte[count];
            int result = this.inputStream.read(tmp, 0, count);
            buffer.position(offset);
            if (result >= 0) {
                buffer.put(tmp, 0, result);
                buffer.position(offset);
            }
            return result;
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
    }

    @Override
    protected final int require(int required) throws KryoException {
        int count;
        int remaining = this.limit - this.position;
        if (remaining >= required) {
            return remaining;
        }
        if (required > this.capacity) {
            throw new KryoException("Buffer too small: capacity: " + this.capacity + ", required: " + required);
        }
        if (remaining > 0) {
            count = this.fill(this.niobuffer, this.limit, this.capacity - this.limit);
            if (count == -1) {
                throw new KryoException("Buffer underflow.");
            }
            if ((remaining += count) >= required) {
                this.limit += count;
                return remaining;
            }
        }
        this.niobuffer.position(this.position);
        this.niobuffer.compact();
        this.total += (long)this.position;
        this.position = 0;
        do {
            if ((count = this.fill(this.niobuffer, remaining, this.capacity - remaining)) != -1) continue;
            if (remaining >= required) break;
            throw new KryoException("Buffer underflow.");
        } while ((remaining += count) < required);
        this.limit = remaining;
        this.niobuffer.position(0);
        return remaining;
    }

    private int optional(int optional) throws KryoException {
        int remaining = this.limit - this.position;
        if (remaining >= optional) {
            return optional;
        }
        optional = Math.min(optional, this.capacity);
        int count = this.fill(this.niobuffer, this.limit, this.capacity - this.limit);
        if (count == -1) {
            return remaining == 0 ? -1 : Math.min(remaining, optional);
        }
        if ((remaining += count) >= optional) {
            this.limit += count;
            return optional;
        }
        this.niobuffer.compact();
        this.total += (long)this.position;
        this.position = 0;
        while ((count = this.fill(this.niobuffer, remaining, this.capacity - remaining)) != -1 && (remaining += count) < optional) {
        }
        this.limit = remaining;
        this.niobuffer.position(this.position);
        return remaining == 0 ? -1 : Math.min(remaining, optional);
    }

    @Override
    public int read() throws KryoException {
        if (this.optional(1) <= 0) {
            return -1;
        }
        this.niobuffer.position(this.position);
        ++this.position;
        return this.niobuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes) throws KryoException {
        this.niobuffer.position(this.position);
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int offset, int count) throws KryoException {
        this.niobuffer.position(this.position);
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int startingCount = count;
        int copyCount = Math.min(this.limit - this.position, count);
        do {
            this.niobuffer.get(bytes, offset, copyCount);
            this.position += copyCount;
            if ((count -= copyCount) == 0) break;
            offset += copyCount;
            copyCount = this.optional(count);
            if (copyCount != -1) continue;
            if (startingCount == count) {
                return -1;
            }
            break;
        } while (this.position != this.limit);
        return startingCount - count;
    }

    @Override
    public void skip(int count) throws KryoException {
        super.skip(count);
        this.niobuffer.position(this.position());
    }

    @Override
    public long skip(long count) throws KryoException {
        int skip;
        for (long remaining = count; remaining > 0L; remaining -= (long)skip) {
            skip = (int)Math.min(0x7FFFFFF7L, remaining);
            this.skip(skip);
        }
        return count;
    }

    @Override
    public void close() throws KryoException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public byte readByte() throws KryoException {
        this.niobuffer.position(this.position);
        this.require(1);
        ++this.position;
        return this.niobuffer.get();
    }

    @Override
    public byte[] readBytes(int length) throws KryoException {
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return bytes;
    }

    @Override
    public void readBytes(byte[] bytes, int offset, int count) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int copyCount = Math.min(this.limit - this.position, count);
        while (true) {
            this.niobuffer.get(bytes, offset, copyCount);
            this.position += copyCount;
            if ((count -= copyCount) == 0) break;
            offset += copyCount;
            copyCount = Math.min(count, this.capacity);
            this.require(copyCount);
        }
    }

    @Override
    public int readInt() throws KryoException {
        this.require(4);
        this.position += 4;
        return this.niobuffer.getInt();
    }

    @Override
    public int readInt(boolean optimizePositive) throws KryoException {
        if (this.varIntsEnabled) {
            return this.readVarInt(optimizePositive);
        }
        return this.readInt();
    }

    @Override
    public int readVarInt(boolean optimizePositive) throws KryoException {
        this.niobuffer.position(this.position);
        if (this.require(1) < 5) {
            return this.readInt_slow(optimizePositive);
        }
        ++this.position;
        byte b2 = this.niobuffer.get();
        int result = b2 & 0x7F;
        if ((b2 & 0x80) != 0) {
            ++this.position;
            b2 = this.niobuffer.get();
            result |= (b2 & 0x7F) << 7;
            if ((b2 & 0x80) != 0) {
                ++this.position;
                b2 = this.niobuffer.get();
                result |= (b2 & 0x7F) << 14;
                if ((b2 & 0x80) != 0) {
                    ++this.position;
                    b2 = this.niobuffer.get();
                    result |= (b2 & 0x7F) << 21;
                    if ((b2 & 0x80) != 0) {
                        ++this.position;
                        b2 = this.niobuffer.get();
                        result |= (b2 & 0x7F) << 28;
                    }
                }
            }
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    private int readInt_slow(boolean optimizePositive) {
        ++this.position;
        byte b2 = this.niobuffer.get();
        int result = b2 & 0x7F;
        if ((b2 & 0x80) != 0) {
            this.require(1);
            ++this.position;
            b2 = this.niobuffer.get();
            result |= (b2 & 0x7F) << 7;
            if ((b2 & 0x80) != 0) {
                this.require(1);
                ++this.position;
                b2 = this.niobuffer.get();
                result |= (b2 & 0x7F) << 14;
                if ((b2 & 0x80) != 0) {
                    this.require(1);
                    ++this.position;
                    b2 = this.niobuffer.get();
                    result |= (b2 & 0x7F) << 21;
                    if ((b2 & 0x80) != 0) {
                        this.require(1);
                        ++this.position;
                        b2 = this.niobuffer.get();
                        result |= (b2 & 0x7F) << 28;
                    }
                }
            }
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    @Override
    public String readString() {
        this.niobuffer.position(this.position);
        int available = this.require(1);
        ++this.position;
        byte b2 = this.niobuffer.get();
        if ((b2 & 0x80) == 0) {
            return this.readAscii();
        }
        int charCount = available >= 5 ? this.readUtf8Length(b2) : this.readUtf8Length_slow(b2);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
        }
        if (this.chars.length < --charCount) {
            this.chars = new char[charCount];
        }
        this.readUtf8(charCount);
        return new String(this.chars, 0, charCount);
    }

    private int readUtf8Length(int b2) {
        int result = b2 & 0x3F;
        if ((b2 & 0x40) != 0) {
            ++this.position;
            b2 = this.niobuffer.get();
            result |= (b2 & 0x7F) << 6;
            if ((b2 & 0x80) != 0) {
                ++this.position;
                b2 = this.niobuffer.get();
                result |= (b2 & 0x7F) << 13;
                if ((b2 & 0x80) != 0) {
                    ++this.position;
                    b2 = this.niobuffer.get();
                    result |= (b2 & 0x7F) << 20;
                    if ((b2 & 0x80) != 0) {
                        ++this.position;
                        b2 = this.niobuffer.get();
                        result |= (b2 & 0x7F) << 27;
                    }
                }
            }
        }
        return result;
    }

    private int readUtf8Length_slow(int b2) {
        int result = b2 & 0x3F;
        if ((b2 & 0x40) != 0) {
            this.require(1);
            ++this.position;
            b2 = this.niobuffer.get();
            result |= (b2 & 0x7F) << 6;
            if ((b2 & 0x80) != 0) {
                this.require(1);
                ++this.position;
                b2 = this.niobuffer.get();
                result |= (b2 & 0x7F) << 13;
                if ((b2 & 0x80) != 0) {
                    this.require(1);
                    ++this.position;
                    b2 = this.niobuffer.get();
                    result |= (b2 & 0x7F) << 20;
                    if ((b2 & 0x80) != 0) {
                        this.require(1);
                        ++this.position;
                        b2 = this.niobuffer.get();
                        result |= (b2 & 0x7F) << 27;
                    }
                }
            }
        }
        return result;
    }

    private void readUtf8(int charCount) {
        char[] chars = this.chars;
        int charIndex = 0;
        int count = Math.min(this.require(1), charCount);
        int position = this.position;
        while (charIndex < count) {
            ++position;
            byte b2 = this.niobuffer.get();
            if (b2 < 0) {
                --position;
                break;
            }
            chars[charIndex++] = (char)b2;
        }
        this.position = position;
        if (charIndex < charCount) {
            this.niobuffer.position(position);
            this.readUtf8_slow(charCount, charIndex);
        }
    }

    private void readUtf8_slow(int charCount, int charIndex) {
        char[] chars = this.chars;
        while (charIndex < charCount) {
            if (this.position == this.limit) {
                this.require(1);
            }
            ++this.position;
            int b2 = this.niobuffer.get() & 0xFF;
            switch (b2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[charIndex] = (char)b2;
                    break;
                }
                case 12: 
                case 13: {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    ++this.position;
                    chars[charIndex] = (char)((b2 & 0x1F) << 6 | this.niobuffer.get() & 0x3F);
                    break;
                }
                case 14: {
                    this.require(2);
                    this.position += 2;
                    byte b22 = this.niobuffer.get();
                    byte b3 = this.niobuffer.get();
                    chars[charIndex] = (char)((b2 & 0xF) << 12 | (b22 & 0x3F) << 6 | b3 & 0x3F);
                }
            }
            ++charIndex;
        }
    }

    private String readAscii() {
        byte b2;
        int end = this.position;
        int start = end - 1;
        int limit = this.limit;
        do {
            if (end == limit) {
                return this.readAscii_slow();
            }
            ++end;
        } while (((b2 = this.niobuffer.get()) & 0x80) == 0);
        this.niobuffer.put(end - 1, (byte)(this.niobuffer.get(end - 1) & 0x7F));
        byte[] tmp = new byte[end - start];
        this.niobuffer.position(start);
        this.niobuffer.get(tmp);
        String value = new String(tmp, 0, 0, end - start);
        this.niobuffer.put(end - 1, (byte)(this.niobuffer.get(end - 1) | 0x80));
        this.position = end;
        this.niobuffer.position(this.position);
        return value;
    }

    private String readAscii_slow() {
        byte b2;
        --this.position;
        int charCount = this.limit - this.position;
        if (charCount > this.chars.length) {
            this.chars = new char[charCount * 2];
        }
        char[] chars = this.chars;
        int i2 = this.position;
        int ii = 0;
        int n2 = this.limit;
        while (i2 < n2) {
            chars[ii] = (char)this.niobuffer.get(i2);
            ++i2;
            ++ii;
        }
        this.position = this.limit;
        while (true) {
            this.require(1);
            ++this.position;
            b2 = this.niobuffer.get();
            if (charCount == chars.length) {
                char[] newChars = new char[charCount * 2];
                System.arraycopy(chars, 0, newChars, 0, charCount);
                chars = newChars;
                this.chars = newChars;
            }
            if ((b2 & 0x80) == 128) break;
            chars[charCount++] = (char)b2;
        }
        chars[charCount++] = (char)(b2 & 0x7F);
        return new String(chars, 0, charCount);
    }

    @Override
    public StringBuilder readStringBuilder() {
        this.niobuffer.position(this.position);
        int available = this.require(1);
        ++this.position;
        byte b2 = this.niobuffer.get();
        if ((b2 & 0x80) == 0) {
            return new StringBuilder(this.readAscii());
        }
        int charCount = available >= 5 ? this.readUtf8Length(b2) : this.readUtf8Length_slow(b2);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return new StringBuilder("");
            }
        }
        if (this.chars.length < --charCount) {
            this.chars = new char[charCount];
        }
        this.readUtf8(charCount);
        StringBuilder builder = new StringBuilder(charCount);
        builder.append(this.chars, 0, charCount);
        return builder;
    }

    @Override
    public float readFloat() throws KryoException {
        this.require(4);
        this.position += 4;
        return this.niobuffer.getFloat();
    }

    @Override
    public short readShort() throws KryoException {
        this.require(2);
        this.position += 2;
        return this.niobuffer.getShort();
    }

    @Override
    public long readLong() throws KryoException {
        this.require(8);
        this.position += 8;
        return this.niobuffer.getLong();
    }

    @Override
    public long readLong(boolean optimizePositive) throws KryoException {
        if (this.varIntsEnabled) {
            return this.readVarLong(optimizePositive);
        }
        return this.readLong();
    }

    @Override
    public long readVarLong(boolean optimizePositive) throws KryoException {
        this.niobuffer.position(this.position);
        if (this.require(1) < 9) {
            return this.readLong_slow(optimizePositive);
        }
        ++this.position;
        byte b2 = this.niobuffer.get();
        long result = b2 & 0x7F;
        if ((b2 & 0x80) != 0) {
            ++this.position;
            b2 = this.niobuffer.get();
            result |= (long)((b2 & 0x7F) << 7);
            if ((b2 & 0x80) != 0) {
                ++this.position;
                b2 = this.niobuffer.get();
                result |= (long)((b2 & 0x7F) << 14);
                if ((b2 & 0x80) != 0) {
                    ++this.position;
                    b2 = this.niobuffer.get();
                    result |= (long)((b2 & 0x7F) << 21);
                    if ((b2 & 0x80) != 0) {
                        ++this.position;
                        b2 = this.niobuffer.get();
                        result |= (long)(b2 & 0x7F) << 28;
                        if ((b2 & 0x80) != 0) {
                            ++this.position;
                            b2 = this.niobuffer.get();
                            result |= (long)(b2 & 0x7F) << 35;
                            if ((b2 & 0x80) != 0) {
                                ++this.position;
                                b2 = this.niobuffer.get();
                                result |= (long)(b2 & 0x7F) << 42;
                                if ((b2 & 0x80) != 0) {
                                    ++this.position;
                                    b2 = this.niobuffer.get();
                                    result |= (long)(b2 & 0x7F) << 49;
                                    if ((b2 & 0x80) != 0) {
                                        ++this.position;
                                        b2 = this.niobuffer.get();
                                        result |= (long)b2 << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!optimizePositive) {
            result = result >>> 1 ^ -(result & 1L);
        }
        return result;
    }

    private long readLong_slow(boolean optimizePositive) {
        ++this.position;
        byte b2 = this.niobuffer.get();
        long result = b2 & 0x7F;
        if ((b2 & 0x80) != 0) {
            this.require(1);
            ++this.position;
            b2 = this.niobuffer.get();
            result |= (long)((b2 & 0x7F) << 7);
            if ((b2 & 0x80) != 0) {
                this.require(1);
                ++this.position;
                b2 = this.niobuffer.get();
                result |= (long)((b2 & 0x7F) << 14);
                if ((b2 & 0x80) != 0) {
                    this.require(1);
                    ++this.position;
                    b2 = this.niobuffer.get();
                    result |= (long)((b2 & 0x7F) << 21);
                    if ((b2 & 0x80) != 0) {
                        this.require(1);
                        ++this.position;
                        b2 = this.niobuffer.get();
                        result |= (long)(b2 & 0x7F) << 28;
                        if ((b2 & 0x80) != 0) {
                            this.require(1);
                            ++this.position;
                            b2 = this.niobuffer.get();
                            result |= (long)(b2 & 0x7F) << 35;
                            if ((b2 & 0x80) != 0) {
                                this.require(1);
                                ++this.position;
                                b2 = this.niobuffer.get();
                                result |= (long)(b2 & 0x7F) << 42;
                                if ((b2 & 0x80) != 0) {
                                    this.require(1);
                                    ++this.position;
                                    b2 = this.niobuffer.get();
                                    result |= (long)(b2 & 0x7F) << 49;
                                    if ((b2 & 0x80) != 0) {
                                        this.require(1);
                                        ++this.position;
                                        b2 = this.niobuffer.get();
                                        result |= (long)b2 << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!optimizePositive) {
            result = result >>> 1 ^ -(result & 1L);
        }
        return result;
    }

    @Override
    public boolean readBoolean() throws KryoException {
        this.require(1);
        ++this.position;
        return this.niobuffer.get() == 1;
    }

    @Override
    public char readChar() throws KryoException {
        this.require(2);
        this.position += 2;
        return this.niobuffer.getChar();
    }

    @Override
    public double readDouble() throws KryoException {
        this.require(8);
        this.position += 8;
        return this.niobuffer.getDouble();
    }

    @Override
    public float[] readFloats(int length) throws KryoException {
        if (this.capacity - this.position >= length * 4 && this.isNativeOrder()) {
            float[] array = new float[length];
            FloatBuffer buf = this.niobuffer.asFloatBuffer();
            buf.get(array);
            this.position += length * 4;
            this.niobuffer.position(this.position);
            return array;
        }
        return super.readFloats(length);
    }

    @Override
    public short[] readShorts(int length) throws KryoException {
        if (this.capacity - this.position >= length * 2 && this.isNativeOrder()) {
            short[] array = new short[length];
            ShortBuffer buf = this.niobuffer.asShortBuffer();
            buf.get(array);
            this.position += length * 2;
            this.niobuffer.position(this.position);
            return array;
        }
        return super.readShorts(length);
    }

    @Override
    public char[] readChars(int length) throws KryoException {
        if (this.capacity - this.position >= length * 2 && this.isNativeOrder()) {
            char[] array = new char[length];
            CharBuffer buf = this.niobuffer.asCharBuffer();
            buf.get(array);
            this.position += length * 2;
            this.niobuffer.position(this.position);
            return array;
        }
        return super.readChars(length);
    }

    @Override
    public double[] readDoubles(int length) throws KryoException {
        if (this.capacity - this.position >= length * 8 && this.isNativeOrder()) {
            double[] array = new double[length];
            DoubleBuffer buf = this.niobuffer.asDoubleBuffer();
            buf.get(array);
            this.position += length * 8;
            this.niobuffer.position(this.position);
            return array;
        }
        return super.readDoubles(length);
    }

    private boolean isNativeOrder() {
        return this.byteOrder == nativeOrder;
    }
}

