/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.pool;

import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.Kryo;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.pool.KryoCallback;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.pool.KryoFactory;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.pool.KryoPool;
import java.util.Queue;

class KryoPoolQueueImpl
implements KryoPool {
    private final Queue<Kryo> queue;
    private final KryoFactory factory;

    KryoPoolQueueImpl(KryoFactory factory, Queue<Kryo> queue) {
        this.factory = factory;
        this.queue = queue;
    }

    public Kryo borrow() {
        Kryo res = this.queue.poll();
        if (res != null) {
            return res;
        }
        return this.factory.create();
    }

    public void release(Kryo kryo) {
        this.queue.offer(kryo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(KryoCallback<T> callback) {
        Kryo kryo = this.borrow();
        try {
            T t2 = callback.execute(kryo);
            return t2;
        }
        finally {
            this.release(kryo);
        }
    }
}

