/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.serializers;

import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.Kryo;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.Serializer;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.io.Input;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.io.Output;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;

public class ClosureSerializer
extends Serializer {
    private static Method readResolve;
    private static Class serializedLambda;

    public void write(Kryo kryo, Output output, Object object) {
        try {
            Class<?> type = object.getClass();
            Method writeReplace = type.getDeclaredMethod("writeReplace", new Class[0]);
            writeReplace.setAccessible(true);
            Object replacement = writeReplace.invoke(object, new Object[0]);
            if (!serializedLambda.isInstance(replacement)) {
                throw new RuntimeException("Could not serialize lambda");
            }
            kryo.writeObject(output, replacement);
        }
        catch (Exception e2) {
            throw new RuntimeException("Could not serialize lambda", e2);
        }
    }

    public Object read(Kryo kryo, Input input, Class type) {
        try {
            Object object = kryo.readObject(input, serializedLambda);
            return readResolve.invoke(object, new Object[0]);
        }
        catch (Exception e2) {
            throw new RuntimeException("Could not serialize lambda", e2);
        }
    }

    public Object copy(Kryo kryo, Object original) {
        try {
            Class<?> type = original.getClass();
            Method writeReplace = type.getDeclaredMethod("writeReplace", new Class[0]);
            writeReplace.setAccessible(true);
            Object replacement = writeReplace.invoke(original, new Object[0]);
            if (serializedLambda.isInstance(replacement)) {
                return readResolve.invoke(replacement, new Object[0]);
            }
            throw new RuntimeException("Could not serialize lambda");
        }
        catch (Exception e2) {
            throw new RuntimeException("Could not serialize lambda", e2);
        }
    }

    static {
        serializedLambda = SerializedLambda.class;
        try {
            readResolve = serializedLambda.getDeclaredMethod("readResolve", new Class[0]);
            readResolve.setAccessible(true);
        }
        catch (Exception e2) {
            throw new RuntimeException("Could not obtain SerializedLambda or its methods via reflection", e2);
        }
    }

    public static class Closure {
    }
}

