/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.util;

import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.minlog.Log;
import java.util.concurrent.ConcurrentHashMap;

public class Util {
    public static final boolean IS_ANDROID;
    @Deprecated
    public static boolean isAndroid;
    private static final ConcurrentHashMap<String, Boolean> classAvailabilities;

    public static boolean isClassAvailable(String className) {
        Boolean result = classAvailabilities.get(className);
        if (result == null) {
            try {
                Class.forName(className);
                result = true;
            }
            catch (Exception e2) {
                Log.debug("kryo", "Class not available: " + className);
                result = false;
            }
            classAvailabilities.put(className, result);
        }
        return result;
    }

    public static Class getWrapperClass(Class type) {
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        return Void.class;
    }

    public static boolean isWrapperClass(Class type) {
        return type == Integer.class || type == Float.class || type == Boolean.class || type == Long.class || type == Byte.class || type == Character.class || type == Short.class || type == Double.class;
    }

    public static void log(String message, Object object) {
        if (object == null) {
            if (Log.TRACE) {
                Log.trace("kryo", message + ": null");
            }
            return;
        }
        Class<?> type = object.getClass();
        if (type.isPrimitive() || type == Boolean.class || type == Byte.class || type == Character.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == String.class) {
            if (Log.TRACE) {
                Log.trace("kryo", message + ": " + Util.string(object));
            }
        } else {
            Log.debug("kryo", message + ": " + Util.string(object));
        }
    }

    public static String string(Object object) {
        if (object == null) {
            return "null";
        }
        Class<?> type = object.getClass();
        if (type.isArray()) {
            return Util.className(type);
        }
        try {
            if (type.getMethod("toString", new Class[0]).getDeclaringClass() == Object.class) {
                return Log.TRACE ? Util.className(type) : type.getSimpleName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return String.valueOf(object);
        }
        catch (Throwable e2) {
            return (Log.TRACE ? Util.className(type) : type.getSimpleName()) + "(Exception " + e2 + " in toString)";
        }
    }

    public static String className(Class type) {
        if (type.isArray()) {
            Class elementClass = Util.getElementClass(type);
            StringBuilder buffer = new StringBuilder(16);
            int n2 = Util.getDimensionCount(type);
            for (int i2 = 0; i2 < n2; ++i2) {
                buffer.append("[]");
            }
            return Util.className(elementClass) + buffer;
        }
        if (type.isPrimitive() || type == Object.class || type == Boolean.class || type == Byte.class || type == Character.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == String.class) {
            return type.getSimpleName();
        }
        return type.getName();
    }

    public static int getDimensionCount(Class arrayClass) {
        int depth = 0;
        for (Class<?> nextClass = arrayClass.getComponentType(); nextClass != null; nextClass = nextClass.getComponentType()) {
            ++depth;
        }
        return depth;
    }

    public static Class getElementClass(Class arrayClass) {
        Class<?> elementClass = arrayClass;
        while (elementClass.getComponentType() != null) {
            elementClass = elementClass.getComponentType();
        }
        return elementClass;
    }

    static {
        isAndroid = IS_ANDROID = "Dalvik".equals(System.getProperty("java.vm.name"));
        classAvailabilities = new ConcurrentHashMap();
    }
}

