/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.apache.commons.compress.archivers.tar;

import com.gradle.enterprise.testdistribution.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveStructSparse;
import com.gradle.enterprise.testdistribution.internal.dep.org.apache.commons.compress.archivers.tar.TarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TarArchiveSparseEntry {
    private final boolean isExtended;
    private List<TarArchiveStructSparse> sparseHeaders;

    public TarArchiveSparseEntry(byte[] headerBuf) throws IOException {
        int offset = 0;
        this.sparseHeaders = new ArrayList<TarArchiveStructSparse>();
        for (int i2 = 0; i2 < 21; ++i2) {
            TarArchiveStructSparse sparseHeader = TarUtils.parseSparse(headerBuf, offset + i2 * 24);
            if (sparseHeader.getOffset() <= 0L && sparseHeader.getNumbytes() <= 0L) continue;
            this.sparseHeaders.add(sparseHeader);
        }
        this.isExtended = TarUtils.parseBoolean(headerBuf, offset += 504);
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public List<TarArchiveStructSparse> getSparseHeaders() {
        return this.sparseHeaders;
    }
}

