/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.client;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.client.HttpConversation;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.client.Origin;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.client.api.ContentProvider;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.client.api.Request;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.client.api.Result;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.HttpFields;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.HttpMethod;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.HttpVersion;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.Fields;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class HttpRequest
implements Request {
    private static final URI NULL_URI = URI.create("null:0");
    private final HttpFields headers = new HttpFields();
    private final Fields params = new Fields(true);
    private final List<Response.ResponseListener> responseListeners = new ArrayList<Response.ResponseListener>();
    private final AtomicReference<Throwable> aborted = new AtomicReference();
    private final HttpClient client;
    private final HttpConversation conversation;
    private String scheme;
    private String host;
    private int port;
    private String path;
    private String query;
    private URI uri;
    private String method = HttpMethod.GET.asString();
    private HttpVersion version = HttpVersion.HTTP_1_1;
    private long idleTimeout = -1L;
    private long timeout;
    private long timeoutAt;
    private ContentProvider content;
    private boolean followRedirects;
    private List<HttpCookie> cookies;
    private Map<String, Object> attributes;
    private List<Request.RequestListener> requestListeners;
    private Supplier<HttpFields> trailers;
    private Object tag;
    private boolean normalized;

    protected HttpRequest(HttpClient client, HttpConversation conversation, URI uri) {
        HttpField userAgentField;
        this.client = client;
        this.conversation = conversation;
        this.scheme = uri.getScheme();
        this.host = uri.getHost();
        this.port = HttpClient.normalizePort(this.scheme, uri.getPort());
        this.path = uri.getRawPath();
        this.query = uri.getRawQuery();
        this.extractParams(this.query);
        this.followRedirects(client.isFollowRedirects());
        HttpField acceptEncodingField = client.getAcceptEncodingField();
        if (acceptEncodingField != null) {
            this.headers.put(acceptEncodingField);
        }
        if ((userAgentField = client.getUserAgentField()) != null) {
            this.headers.put(userAgentField);
        }
    }

    public HttpConversation getConversation() {
        return this.conversation;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public Request scheme(String scheme) {
        this.scheme = scheme;
        this.uri = null;
        return this;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public Request method(HttpMethod method) {
        return this.method(method.asString());
    }

    @Override
    public Request method(String method) {
        this.method = Objects.requireNonNull(method).toUpperCase(Locale.ENGLISH);
        return this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Request path(String path) {
        URI uri = this.newURI(path);
        if (uri == null) {
            this.path = path;
            this.query = null;
        } else {
            String rawPath = uri.getRawPath();
            if (rawPath == null) {
                rawPath = "";
            }
            this.path = rawPath;
            String query = uri.getRawQuery();
            if (query != null) {
                this.query = query;
                this.params.clear();
                this.extractParams(query);
            }
            if (uri.isAbsolute()) {
                this.path = this.buildURI(false).toString();
            }
        }
        this.uri = null;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    @Override
    public URI getURI() {
        if (this.uri == null) {
            this.uri = this.buildURI(true);
        }
        boolean isNullURI = this.uri == NULL_URI;
        return isNullURI ? null : this.uri;
    }

    @Override
    public HttpVersion getVersion() {
        return this.version;
    }

    @Override
    public Request version(HttpVersion version) {
        this.version = Objects.requireNonNull(version);
        return this;
    }

    private Request param(String name, String value, boolean fromQuery) {
        this.params.add(name, value);
        if (!fromQuery) {
            this.query = this.query != null ? this.query + "&" + this.urlEncode(name) + "=" + this.urlEncode(value) : this.buildQuery();
            this.uri = null;
        }
        return this;
    }

    @Override
    public Request header(String name, String value) {
        if (value == null) {
            this.headers.remove(name);
        } else {
            this.headers.add(name, value);
        }
        return this;
    }

    @Override
    public Request header(HttpHeader header, String value) {
        if (value == null) {
            this.headers.remove(header);
        } else {
            this.headers.add(header, value);
        }
        return this;
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this.cookies != null ? this.cookies : Collections.emptyList();
    }

    public Object getTag() {
        return this.tag;
    }

    @Override
    public Request attribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(4);
        }
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes != null ? this.attributes : Collections.emptyMap();
    }

    @Override
    public HttpFields getHeaders() {
        return this.headers;
    }

    @Override
    public <T extends Request.RequestListener> List<T> getRequestListeners(Class<T> type) {
        if (type == null || this.requestListeners == null) {
            return this.requestListeners != null ? this.requestListeners : Collections.emptyList();
        }
        ArrayList<Request.RequestListener> result = new ArrayList<Request.RequestListener>();
        for (Request.RequestListener listener : this.requestListeners) {
            if (!type.isInstance(listener)) continue;
            result.add(listener);
        }
        return result;
    }

    @Override
    public Request listener(Request.Listener listener) {
        return this.requestListener(listener);
    }

    @Override
    public Request onRequestBegin(final Request.BeginListener listener) {
        return this.requestListener(new Request.BeginListener(){

            @Override
            public void onBegin(Request request) {
                listener.onBegin(request);
            }
        });
    }

    private Request requestListener(Request.RequestListener listener) {
        if (this.requestListeners == null) {
            this.requestListeners = new ArrayList<Request.RequestListener>();
        }
        this.requestListeners.add(listener);
        return this;
    }

    public Request onResponseHeaders(final Response.HeadersListener listener) {
        this.responseListeners.add(new Response.HeadersListener(){

            @Override
            public void onHeaders(Response response) {
                listener.onHeaders(response);
            }
        });
        return this;
    }

    public Request onResponseContent(final Response.ContentListener listener) {
        this.responseListeners.add(new Response.ContentListener(){

            @Override
            public void onContent(Response response, ByteBuffer content) {
                listener.onContent(response, content);
            }
        });
        return this;
    }

    public Request onComplete(final Response.CompleteListener listener) {
        this.responseListeners.add(new Response.CompleteListener(){

            @Override
            public void onComplete(Result result) {
                listener.onComplete(result);
            }
        });
        return this;
    }

    @Override
    public ContentProvider getContent() {
        return this.content;
    }

    @Override
    public Request content(ContentProvider content) {
        return this.content(content, null);
    }

    public Request content(ContentProvider content, String contentType) {
        if (contentType != null) {
            this.header(HttpHeader.CONTENT_TYPE, contentType);
        }
        this.content = content;
        return this;
    }

    @Override
    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    @Override
    public Request followRedirects(boolean follow) {
        this.followRedirects = follow;
        return this;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public Request idleTimeout(long timeout, TimeUnit unit) {
        this.idleTimeout = unit.toMillis(timeout);
        return this;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public Request timeout(long timeout, TimeUnit unit) {
        this.timeout = unit.toMillis(timeout);
        return this;
    }

    @Override
    public void send(Response.CompleteListener listener) {
        this.sendAsync(this.client::send, listener);
    }

    private void sendAsync(BiConsumer<HttpRequest, List<Response.ResponseListener>> sender, Response.CompleteListener listener) {
        if (listener != null) {
            this.responseListeners.add(listener);
        }
        this.sent();
        sender.accept(this, this.responseListeners);
    }

    void sent() {
        long timeout = this.getTimeout();
        this.timeoutAt = timeout > 0L ? System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeout) : -1L;
    }

    long getTimeoutAt() {
        return this.timeoutAt;
    }

    protected List<Response.ResponseListener> getResponseListeners() {
        return this.responseListeners;
    }

    public Supplier<HttpFields> getTrailers() {
        return this.trailers;
    }

    @Override
    public boolean abort(Throwable cause) {
        if (this.aborted.compareAndSet(null, Objects.requireNonNull(cause))) {
            if (this.content instanceof Callback) {
                ((Callback)((Object)this.content)).failed(cause);
            }
            return this.conversation.abort(cause);
        }
        return false;
    }

    @Override
    public Throwable getAbortCause() {
        return this.aborted.get();
    }

    boolean normalized() {
        boolean result = this.normalized;
        this.normalized = true;
        return result;
    }

    private String buildQuery() {
        StringBuilder result = new StringBuilder();
        Iterator<Fields.Field> iterator = this.params.iterator();
        while (iterator.hasNext()) {
            Fields.Field field = iterator.next();
            List<String> values = field.getValues();
            for (int i2 = 0; i2 < values.size(); ++i2) {
                if (i2 > 0) {
                    result.append("&");
                }
                result.append(field.getName()).append("=");
                result.append(this.urlEncode(values.get(i2)));
            }
            if (!iterator.hasNext()) continue;
            result.append("&");
        }
        return result.toString();
    }

    private String urlEncode(String value) {
        if (value == null) {
            return "";
        }
        String encoding = "utf-8";
        try {
            return URLEncoder.encode(value, encoding);
        }
        catch (UnsupportedEncodingException e2) {
            throw new UnsupportedCharsetException(encoding);
        }
    }

    private void extractParams(String query) {
        if (query != null) {
            for (String nameValue : query.split("&")) {
                String name;
                String[] parts = nameValue.split("=");
                if (parts.length <= 0 || (name = this.urlDecode(parts[0])).trim().length() == 0) continue;
                this.param(name, parts.length < 2 ? "" : this.urlDecode(parts[1]), true);
            }
        }
    }

    private String urlDecode(String value) {
        String charset = "utf-8";
        try {
            return URLDecoder.decode(value, charset);
        }
        catch (UnsupportedEncodingException x2) {
            throw new UnsupportedCharsetException(charset);
        }
    }

    private URI buildURI(boolean withQuery) {
        URI result;
        String path = this.getPath();
        String query = this.getQuery();
        if (query != null && withQuery) {
            path = path + "?" + query;
        }
        if ((result = this.newURI(path)) == null) {
            return NULL_URI;
        }
        if (!result.isAbsolute()) {
            result = URI.create(new Origin(this.getScheme(), this.getHost(), this.getPort()).asString() + path);
        }
        return result;
    }

    private URI newURI(String uri) {
        try {
            if ("*".equals(uri)) {
                return null;
            }
            URI result = new URI(uri);
            return result.isOpaque() ? null : result;
        }
        catch (URISyntaxException x2) {
            return null;
        }
    }

    public String toString() {
        return String.format("%s[%s %s %s]@%x", new Object[]{this.getClass().getSimpleName(), this.getMethod(), this.getPath(), this.getVersion(), this.hashCode()});
    }
}

