/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.BadMessageException;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.ArrayTrie;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.Trie;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.TypeUtil;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.URIUtil;
import java.util.EnumSet;

public class HttpURI {
    private static final Trie<Boolean> __ambiguousSegments = new ArrayTrie<Boolean>();
    private String _scheme;
    private String _user;
    private String _host;
    private int _port;
    private String _path;
    private String _param;
    private String _query;
    private String _fragment;
    private String _uri;
    private String _decodedPath;
    private final EnumSet<Ambiguous> _ambiguous = EnumSet.noneOf(Ambiguous.class);

    public HttpURI() {
    }

    public HttpURI(String uri) {
        this._port = -1;
        this.parse(State.START, uri, 0, uri.length());
    }

    private void parse(State state, String uri, int offset, int end) {
        int mark = offset;
        int pathMark = 0;
        int segment = 0;
        boolean encoded = false;
        boolean dot = false;
        int escapedSlash = 0;
        block73: for (int i2 = offset; i2 < end; ++i2) {
            char c2 = uri.charAt(i2);
            switch (state) {
                case START: {
                    switch (c2) {
                        case '/': {
                            mark = i2;
                            state = State.HOST_OR_PATH;
                            continue block73;
                        }
                        case ';': {
                            mark = i2 + 1;
                            state = State.PARAM;
                            continue block73;
                        }
                        case '?': {
                            this._path = "";
                            mark = i2 + 1;
                            state = State.QUERY;
                            continue block73;
                        }
                        case '#': {
                            mark = i2 + 1;
                            state = State.FRAGMENT;
                            continue block73;
                        }
                        case '*': {
                            this._path = "*";
                            state = State.ASTERISK;
                            continue block73;
                        }
                        case '%': {
                            encoded = true;
                            escapedSlash = 1;
                            pathMark = segment = i2;
                            mark = segment;
                            state = State.PATH;
                            continue block73;
                        }
                        case '.': {
                            dot = true;
                            pathMark = segment = i2;
                            state = State.PATH;
                            continue block73;
                        }
                    }
                    mark = i2;
                    if (this._scheme == null) {
                        state = State.SCHEME_OR_PATH;
                        continue block73;
                    }
                    pathMark = segment = i2;
                    state = State.PATH;
                    continue block73;
                }
                case SCHEME_OR_PATH: {
                    switch (c2) {
                        case ':': {
                            this._scheme = uri.substring(mark, i2);
                            state = State.START;
                            continue block73;
                        }
                        case '/': {
                            segment = i2 + 1;
                            state = State.PATH;
                            continue block73;
                        }
                        case ';': {
                            mark = i2 + 1;
                            state = State.PARAM;
                            continue block73;
                        }
                        case '?': {
                            this._path = uri.substring(mark, i2);
                            mark = i2 + 1;
                            state = State.QUERY;
                            continue block73;
                        }
                        case '%': {
                            encoded = true;
                            escapedSlash = 1;
                            state = State.PATH;
                            continue block73;
                        }
                        case '#': {
                            this._path = uri.substring(mark, i2);
                            state = State.FRAGMENT;
                            continue block73;
                        }
                    }
                    continue block73;
                }
                case HOST_OR_PATH: {
                    switch (c2) {
                        case '/': {
                            this._host = "";
                            mark = i2 + 1;
                            state = State.HOST;
                            continue block73;
                        }
                        case '#': 
                        case '%': 
                        case '.': 
                        case ';': 
                        case '?': 
                        case '@': {
                            --i2;
                            pathMark = mark;
                            segment = mark + 1;
                            state = State.PATH;
                            continue block73;
                        }
                    }
                    pathMark = mark;
                    segment = mark + 1;
                    state = State.PATH;
                    continue block73;
                }
                case HOST: {
                    switch (c2) {
                        case '/': {
                            this._host = uri.substring(mark, i2);
                            pathMark = mark = i2;
                            segment = mark + 1;
                            state = State.PATH;
                            continue block73;
                        }
                        case ':': {
                            if (i2 > mark) {
                                this._host = uri.substring(mark, i2);
                            }
                            mark = i2 + 1;
                            state = State.PORT;
                            continue block73;
                        }
                        case '@': {
                            if (this._user != null) {
                                throw new IllegalArgumentException("Bad authority");
                            }
                            this._user = uri.substring(mark, i2);
                            mark = i2 + 1;
                            continue block73;
                        }
                        case '[': {
                            state = State.IPV6;
                            continue block73;
                        }
                    }
                    continue block73;
                }
                case IPV6: {
                    switch (c2) {
                        case '/': {
                            throw new IllegalArgumentException("No closing ']' for ipv6 in " + uri);
                        }
                        case ']': {
                            c2 = uri.charAt(++i2);
                            this._host = uri.substring(mark, i2);
                            if (c2 == ':') {
                                mark = i2 + 1;
                                state = State.PORT;
                                continue block73;
                            }
                            pathMark = mark = i2;
                            state = State.PATH;
                            continue block73;
                        }
                    }
                    continue block73;
                }
                case PORT: {
                    if (c2 == '@') {
                        if (this._user != null) {
                            throw new IllegalArgumentException("Bad authority");
                        }
                        this._user = this._host + ":" + uri.substring(mark, i2);
                        mark = i2 + 1;
                        state = State.HOST;
                        continue block73;
                    }
                    if (c2 != '/') continue block73;
                    this._port = TypeUtil.parseInt(uri, mark, i2 - mark, 10);
                    pathMark = mark = i2;
                    segment = i2 + 1;
                    state = State.PATH;
                    continue block73;
                }
                case PATH: {
                    switch (c2) {
                        case ';': {
                            this.checkSegment(uri, segment, i2, true);
                            mark = i2 + 1;
                            state = State.PARAM;
                            continue block73;
                        }
                        case '?': {
                            this.checkSegment(uri, segment, i2, false);
                            this._path = uri.substring(pathMark, i2);
                            mark = i2 + 1;
                            state = State.QUERY;
                            continue block73;
                        }
                        case '#': {
                            this.checkSegment(uri, segment, i2, false);
                            this._path = uri.substring(pathMark, i2);
                            mark = i2 + 1;
                            state = State.FRAGMENT;
                            continue block73;
                        }
                        case '/': {
                            this.checkSegment(uri, segment, i2, false);
                            segment = i2 + 1;
                            continue block73;
                        }
                        case '.': {
                            dot |= segment == i2;
                            continue block73;
                        }
                        case '%': {
                            encoded = true;
                            escapedSlash = 1;
                            continue block73;
                        }
                        case '2': {
                            escapedSlash = escapedSlash == 1 ? 2 : 0;
                            continue block73;
                        }
                        case 'F': 
                        case 'f': {
                            if (escapedSlash == 2) {
                                this._ambiguous.add(Ambiguous.SEPARATOR);
                            }
                            escapedSlash = 0;
                            continue block73;
                        }
                    }
                    escapedSlash = 0;
                    continue block73;
                }
                case PARAM: {
                    switch (c2) {
                        case '?': {
                            this._path = uri.substring(pathMark, i2);
                            this._param = uri.substring(mark, i2);
                            mark = i2 + 1;
                            state = State.QUERY;
                            continue block73;
                        }
                        case '#': {
                            this._path = uri.substring(pathMark, i2);
                            this._param = uri.substring(mark, i2);
                            mark = i2 + 1;
                            state = State.FRAGMENT;
                            continue block73;
                        }
                        case '/': {
                            encoded = true;
                            segment = i2 + 1;
                            state = State.PATH;
                            continue block73;
                        }
                        case ';': {
                            mark = i2 + 1;
                            continue block73;
                        }
                    }
                    continue block73;
                }
                case QUERY: {
                    if (c2 != '#') continue block73;
                    this._query = uri.substring(mark, i2);
                    mark = i2 + 1;
                    state = State.FRAGMENT;
                    continue block73;
                }
                case ASTERISK: {
                    throw new IllegalArgumentException("Bad character '*'");
                }
                case FRAGMENT: {
                    this._fragment = uri.substring(mark, end);
                    i2 = end;
                    continue block73;
                }
            }
        }
        switch (state) {
            case START: {
                break;
            }
            case SCHEME_OR_PATH: {
                this._path = uri.substring(mark, end);
                break;
            }
            case HOST_OR_PATH: {
                this._path = uri.substring(mark, end);
                break;
            }
            case HOST: {
                if (end <= mark) break;
                this._host = uri.substring(mark, end);
                break;
            }
            case IPV6: {
                throw new IllegalArgumentException("No closing ']' for ipv6 in " + uri);
            }
            case PORT: {
                this._port = TypeUtil.parseInt(uri, mark, end - mark, 10);
                break;
            }
            case ASTERISK: {
                break;
            }
            case FRAGMENT: {
                this._fragment = uri.substring(mark, end);
                break;
            }
            case PARAM: {
                this._path = uri.substring(pathMark, end);
                this._param = uri.substring(mark, end);
                break;
            }
            case PATH: {
                this.checkSegment(uri, segment, end, false);
                this._path = uri.substring(pathMark, end);
                break;
            }
            case QUERY: {
                this._query = uri.substring(mark, end);
                break;
            }
        }
        if (!encoded && !dot) {
            this._decodedPath = this._param == null ? this._path : this._path.substring(0, this._path.length() - this._param.length() - 1);
        } else if (this._path != null) {
            String canonical = URIUtil.canonicalPath(this._path);
            if (canonical == null) {
                throw new BadMessageException("Bad URI");
            }
            this._decodedPath = URIUtil.decodePath(canonical);
        }
    }

    private void checkSegment(String uri, int segment, int end, boolean param) {
        if (!this._ambiguous.contains((Object)Ambiguous.SEGMENT)) {
            Boolean ambiguous = __ambiguousSegments.get(uri, segment, end - segment);
            if (ambiguous == Boolean.TRUE) {
                this._ambiguous.add(Ambiguous.SEGMENT);
            } else if (param && ambiguous == Boolean.FALSE) {
                this._ambiguous.add(Ambiguous.PARAM);
            }
        }
    }

    public String toString() {
        if (this._uri == null) {
            StringBuilder out = new StringBuilder();
            if (this._scheme != null) {
                out.append(this._scheme).append(':');
            }
            if (this._host != null) {
                out.append("//");
                if (this._user != null) {
                    out.append(this._user).append('@');
                }
                out.append(this._host);
            }
            if (this._port > 0) {
                out.append(':').append(this._port);
            }
            if (this._path != null) {
                out.append(this._path);
            }
            if (this._query != null) {
                out.append('?').append(this._query);
            }
            if (this._fragment != null) {
                out.append('#').append(this._fragment);
            }
            this._uri = out.length() > 0 ? out.toString() : "";
        }
        return this._uri;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof HttpURI)) {
            return false;
        }
        return this.toString().equals(o2.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    static {
        __ambiguousSegments.put("%2e", Boolean.TRUE);
        __ambiguousSegments.put("%2e%2e", Boolean.TRUE);
        __ambiguousSegments.put(".%2e", Boolean.TRUE);
        __ambiguousSegments.put("%2e.", Boolean.TRUE);
        __ambiguousSegments.put("..", Boolean.FALSE);
        __ambiguousSegments.put(".", Boolean.FALSE);
    }

    static enum Ambiguous {
        SEGMENT,
        SEPARATOR,
        PARAM;

    }

    private static enum State {
        START,
        HOST_OR_PATH,
        SCHEME_OR_PATH,
        HOST,
        IPV6,
        PORT,
        PATH,
        PARAM,
        QUERY,
        FRAGMENT,
        ASTERISK;

    }
}

