/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io.ssl;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io.ClientConnectionFactory;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io.Connection;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io.EndPoint;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io.ssl.SslConnection;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io.ssl.SslHandshakeListener;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.ssl.SslContextFactory;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;

public class SslClientConnectionFactory
implements ClientConnectionFactory {
    private final SslContextFactory sslContextFactory;
    private final ByteBufferPool byteBufferPool;
    private final Executor executor;
    private final ClientConnectionFactory connectionFactory;
    private boolean _directBuffersForEncryption = true;
    private boolean _directBuffersForDecryption = true;
    private boolean _requireCloseMessage;

    public SslClientConnectionFactory(SslContextFactory sslContextFactory, ByteBufferPool byteBufferPool, Executor executor, ClientConnectionFactory connectionFactory) {
        this.sslContextFactory = Objects.requireNonNull(sslContextFactory, "Missing SslContextFactory");
        this.byteBufferPool = byteBufferPool;
        this.executor = executor;
        this.connectionFactory = connectionFactory;
    }

    public boolean isDirectBuffersForDecryption() {
        return this._directBuffersForDecryption;
    }

    public boolean isDirectBuffersForEncryption() {
        return this._directBuffersForEncryption;
    }

    public boolean isRequireCloseMessage() {
        return this._requireCloseMessage;
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        String host = (String)context.get("ssl.peer.host");
        int port = (Integer)context.get("ssl.peer.port");
        SSLEngine engine = this.sslContextFactory instanceof SslEngineFactory ? ((SslEngineFactory)((Object)this.sslContextFactory)).newSslEngine(host, port, context) : this.sslContextFactory.newSSLEngine(host, port);
        engine.setUseClientMode(true);
        context.put("ssl.engine", engine);
        SslConnection sslConnection = this.newSslConnection(this.byteBufferPool, this.executor, endPoint, engine);
        SslConnection.DecryptedEndPoint appEndPoint = sslConnection.getDecryptedEndPoint();
        appEndPoint.setConnection(this.connectionFactory.newConnection(appEndPoint, context));
        sslConnection.addHandshakeListener(new HTTPSHandshakeListener(context));
        this.customize(sslConnection, context);
        return sslConnection;
    }

    protected SslConnection newSslConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, SSLEngine engine) {
        return new SslConnection(byteBufferPool, executor, endPoint, engine, this.isDirectBuffersForEncryption(), this.isDirectBuffersForDecryption());
    }

    @Override
    public Connection customize(Connection connection, Map<String, Object> context) {
        if (connection instanceof SslConnection) {
            SslConnection sslConnection = (SslConnection)connection;
            sslConnection.setRenegotiationAllowed(this.sslContextFactory.isRenegotiationAllowed());
            sslConnection.setRenegotiationLimit(this.sslContextFactory.getRenegotiationLimit());
            sslConnection.setRequireCloseMessage(this.isRequireCloseMessage());
            ContainerLifeCycle connector = (ContainerLifeCycle)context.get("client.connector");
            connector.getBeans(SslHandshakeListener.class).forEach(sslConnection::addHandshakeListener);
        }
        return ClientConnectionFactory.super.customize(connection, context);
    }

    private class HTTPSHandshakeListener
    implements SslHandshakeListener {
        private final Map<String, Object> context;

        private HTTPSHandshakeListener(Map<String, Object> context) {
            this.context = context;
        }

        @Override
        public void handshakeSucceeded(SslHandshakeListener.Event event) throws SSLException {
            HostnameVerifier verifier = SslClientConnectionFactory.this.sslContextFactory.getHostnameVerifier();
            if (verifier != null) {
                String host = (String)this.context.get("ssl.peer.host");
                try {
                    if (!verifier.verify(host, event.getSSLEngine().getSession())) {
                        throw new SSLPeerUnverifiedException("Host name verification failed for host: " + host);
                    }
                }
                catch (SSLException x2) {
                    throw x2;
                }
                catch (Throwable x3) {
                    throw (SSLException)new SSLPeerUnverifiedException("Host name verification failed for host: " + host).initCause(x3);
                }
            }
        }
    }

    public static interface SslEngineFactory {
        public SSLEngine newSslEngine(String var1, int var2, Map<String, Object> var3);
    }
}

