/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util;

import java.util.concurrent.atomic.AtomicLong;

public class AtomicBiInteger
extends AtomicLong {
    public AtomicBiInteger() {
    }

    public AtomicBiInteger(int hi, int lo) {
        super(AtomicBiInteger.encode(hi, lo));
    }

    public int getHi() {
        return AtomicBiInteger.getHi(this.get());
    }

    public int getLo() {
        return AtomicBiInteger.getLo(this.get());
    }

    public int getAndSetHi(int hi) {
        long update;
        long encoded;
        while (!this.compareAndSet(encoded = this.get(), update = AtomicBiInteger.encodeHi(encoded, hi))) {
        }
        return AtomicBiInteger.getHi(encoded);
    }

    public void set(int hi, int lo) {
        this.set(AtomicBiInteger.encode(hi, lo));
    }

    public boolean compareAndSet(long encoded, int hi, int lo) {
        long update = AtomicBiInteger.encode(hi, lo);
        return this.compareAndSet(encoded, update);
    }

    public boolean compareAndSet(int expectHi, int hi, int expectLo, int lo) {
        long encoded = AtomicBiInteger.encode(expectHi, expectLo);
        long update = AtomicBiInteger.encode(hi, lo);
        return this.compareAndSet(encoded, update);
    }

    public static int getHi(long encoded) {
        return (int)(encoded >> 32 & 0xFFFFFFFFL);
    }

    public static int getLo(long encoded) {
        return (int)(encoded & 0xFFFFFFFFL);
    }

    public static long encode(int hi, int lo) {
        long h2 = (long)hi & 0xFFFFFFFFL;
        long l2 = (long)lo & 0xFFFFFFFFL;
        return (h2 << 32) + l2;
    }

    public static long encodeHi(long encoded, int hi) {
        long h2 = (long)hi & 0xFFFFFFFFL;
        long l2 = encoded & 0xFFFFFFFFL;
        return (h2 << 32) + l2;
    }
}

