/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.TypeUtil;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.log.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class BufferUtil {
    static final byte[] DIGIT = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);
    private static final int[] decDivisors = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    private static final int[] hexDivisors = new int[]{0x10000000, 0x1000000, 0x100000, 65536, 4096, 256, 16, 1};
    private static final long[] decDivisorsL = new long[]{1000000000000000000L, 100000000000000000L, 10000000000000000L, 1000000000000000L, 100000000000000L, 10000000000000L, 1000000000000L, 100000000000L, 10000000000L, 1000000000L, 100000000L, 10000000L, 1000000L, 100000L, 10000L, 1000L, 100L, 10L, 1L};

    public static ByteBuffer allocate(int capacity) {
        ByteBuffer buf = ByteBuffer.allocate(capacity);
        buf.limit(0);
        return buf;
    }

    public static ByteBuffer allocateDirect(int capacity) {
        ByteBuffer buf = ByteBuffer.allocateDirect(capacity);
        buf.limit(0);
        return buf;
    }

    public static void clear(ByteBuffer buffer) {
        if (buffer != null) {
            buffer.position(0);
            buffer.limit(0);
        }
    }

    public static void clearToFill(ByteBuffer buffer) {
        if (buffer != null) {
            buffer.position(0);
            buffer.limit(buffer.capacity());
        }
    }

    public static int flipToFill(ByteBuffer buffer) {
        int limit;
        int position = buffer.position();
        if (position == (limit = buffer.limit())) {
            buffer.position(0);
            buffer.limit(buffer.capacity());
            return 0;
        }
        int capacity = buffer.capacity();
        if (limit == capacity) {
            buffer.compact();
            return 0;
        }
        buffer.position(limit);
        buffer.limit(capacity);
        return position;
    }

    public static void flipToFlush(ByteBuffer buffer, int position) {
        buffer.limit(buffer.position());
        buffer.position(position);
    }

    public static byte[] toArray(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            byte[] array = buffer.array();
            int from = buffer.arrayOffset() + buffer.position();
            return Arrays.copyOfRange(array, from, from + buffer.remaining());
        }
        byte[] to = new byte[buffer.remaining()];
        buffer.slice().get(to);
        return to;
    }

    public static boolean isTheEmptyBuffer(ByteBuffer buf) {
        boolean isTheEmptyBuffer = buf == EMPTY_BUFFER;
        return isTheEmptyBuffer;
    }

    public static boolean isEmpty(ByteBuffer buf) {
        return buf == null || buf.remaining() == 0;
    }

    public static boolean isEmpty(ByteBuffer[] buf) {
        if (buf == null || buf.length == 0) {
            return true;
        }
        for (ByteBuffer b2 : buf) {
            if (b2 == null || !b2.hasRemaining()) continue;
            return false;
        }
        return true;
    }

    public static long remaining(ByteBuffer ... buf) {
        long remaining = 0L;
        if (buf != null) {
            for (ByteBuffer b2 : buf) {
                if (b2 == null) continue;
                remaining += (long)b2.remaining();
            }
        }
        return remaining;
    }

    public static boolean hasContent(ByteBuffer buf) {
        return buf != null && buf.remaining() > 0;
    }

    public static int length(ByteBuffer buffer) {
        return buffer == null ? 0 : buffer.remaining();
    }

    public static int space(ByteBuffer buffer) {
        if (buffer == null) {
            return 0;
        }
        return buffer.capacity() - buffer.limit();
    }

    public static boolean compact(ByteBuffer buffer) {
        if (buffer.position() == 0) {
            return false;
        }
        boolean full = buffer.limit() == buffer.capacity();
        buffer.compact().flip();
        return full && buffer.limit() < buffer.capacity();
    }

    public static int put(ByteBuffer from, ByteBuffer to) {
        int put;
        int remaining = from.remaining();
        if (remaining > 0) {
            if (remaining <= to.remaining()) {
                to.put(from);
                put = remaining;
                from.position(from.limit());
            } else if (from.hasArray()) {
                put = to.remaining();
                to.put(from.array(), from.arrayOffset() + from.position(), put);
                from.position(from.position() + put);
            } else {
                put = to.remaining();
                ByteBuffer slice = from.slice();
                slice.limit(put);
                to.put(slice);
                from.position(from.position() + put);
            }
        } else {
            put = 0;
        }
        return put;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int append(ByteBuffer to, ByteBuffer b2) {
        int pos = BufferUtil.flipToFill(to);
        try {
            int n2 = BufferUtil.put(b2, to);
            return n2;
        }
        finally {
            BufferUtil.flipToFlush(to, pos);
        }
    }

    public static void writeTo(ByteBuffer buffer, OutputStream out) throws IOException {
        if (buffer.hasArray()) {
            out.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
            buffer.position(buffer.position() + buffer.remaining());
        } else {
            byte[] bytes = new byte[Math.min(buffer.remaining(), 4096)];
            while (buffer.hasRemaining()) {
                int byteCountToWrite = Math.min(buffer.remaining(), 4096);
                buffer.get(bytes, 0, byteCountToWrite);
                out.write(bytes, 0, byteCountToWrite);
            }
        }
    }

    public static String toString(ByteBuffer buffer, int position, int length, Charset charset) {
        byte[] array;
        if (buffer == null) {
            return null;
        }
        byte[] byArray = array = buffer.hasArray() ? buffer.array() : null;
        if (array == null) {
            ByteBuffer ro = buffer.asReadOnlyBuffer();
            ro.position(position);
            ro.limit(position + length);
            byte[] to = new byte[length];
            ro.get(to);
            return new String(to, 0, to.length, charset);
        }
        return new String(array, buffer.arrayOffset() + position, length, charset);
    }

    public static void putHexInt(ByteBuffer buffer, int n2) {
        if (n2 < 0) {
            buffer.put((byte)45);
            if (n2 == Integer.MIN_VALUE) {
                buffer.put((byte)56);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                return;
            }
            n2 = -n2;
        }
        if (n2 < 16) {
            buffer.put(DIGIT[n2]);
        } else {
            boolean started = false;
            for (int hexDivisor : hexDivisors) {
                if (n2 < hexDivisor) {
                    if (!started) continue;
                    buffer.put((byte)48);
                    continue;
                }
                started = true;
                int d2 = n2 / hexDivisor;
                buffer.put(DIGIT[d2]);
                n2 -= d2 * hexDivisor;
            }
        }
    }

    public static void putDecLong(ByteBuffer buffer, long n2) {
        if (n2 < 0L) {
            buffer.put((byte)45);
            if (n2 == Long.MIN_VALUE) {
                buffer.put((byte)57);
                n2 = 223372036854775808L;
            } else {
                n2 = -n2;
            }
        }
        if (n2 < 10L) {
            buffer.put(DIGIT[(int)n2]);
        } else {
            boolean started = false;
            for (long aDecDivisorsL : decDivisorsL) {
                if (n2 < aDecDivisorsL) {
                    if (!started) continue;
                    buffer.put((byte)48);
                    continue;
                }
                started = true;
                long d2 = n2 / aDecDivisorsL;
                buffer.put(DIGIT[(int)d2]);
                n2 -= d2 * aDecDivisorsL;
            }
        }
    }

    public static ByteBuffer toBuffer(String s2) {
        return BufferUtil.toBuffer(s2, StandardCharsets.ISO_8859_1);
    }

    public static ByteBuffer toBuffer(String s2, Charset charset) {
        if (s2 == null) {
            return EMPTY_BUFFER;
        }
        return BufferUtil.toBuffer(s2.getBytes(charset));
    }

    public static ByteBuffer toBuffer(byte[] array) {
        if (array == null) {
            return EMPTY_BUFFER;
        }
        return BufferUtil.toBuffer(array, 0, array.length);
    }

    public static ByteBuffer toBuffer(byte[] array, int offset, int length) {
        if (array == null) {
            return EMPTY_BUFFER;
        }
        return ByteBuffer.wrap(array, offset, length);
    }

    public static String toSummaryString(ByteBuffer buffer) {
        if (buffer == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("[p=");
        buf.append(buffer.position());
        buf.append(",l=");
        buf.append(buffer.limit());
        buf.append(",c=");
        buf.append(buffer.capacity());
        buf.append(",r=");
        buf.append(buffer.remaining());
        buf.append("]");
        return buf.toString();
    }

    public static String toDetailString(ByteBuffer[] buffer) {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (int i2 = 0; i2 < buffer.length; ++i2) {
            if (i2 > 0) {
                builder.append(',');
            }
            builder.append(BufferUtil.toDetailString(buffer[i2]));
        }
        builder.append(']');
        return builder.toString();
    }

    private static void idString(ByteBuffer buffer, StringBuilder out) {
        out.append(buffer.getClass().getSimpleName());
        out.append("@");
        if (buffer.hasArray() && buffer.arrayOffset() == 4) {
            out.append('T');
            byte[] array = buffer.array();
            TypeUtil.toHex(array[0], out);
            TypeUtil.toHex(array[1], out);
            TypeUtil.toHex(array[2], out);
            TypeUtil.toHex(array[3], out);
        } else {
            out.append(Integer.toHexString(System.identityHashCode(buffer)));
        }
    }

    public static String toDetailString(ByteBuffer buffer) {
        if (buffer == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        BufferUtil.idString(buffer, buf);
        buf.append("[p=");
        buf.append(buffer.position());
        buf.append(",l=");
        buf.append(buffer.limit());
        buf.append(",c=");
        buf.append(buffer.capacity());
        buf.append(",r=");
        buf.append(buffer.remaining());
        buf.append("]={");
        BufferUtil.appendDebugString(buf, buffer);
        buf.append("}");
        return buf.toString();
    }

    private static void appendDebugString(StringBuilder buf, ByteBuffer buffer) {
        buffer = buffer.asReadOnlyBuffer();
        try {
            int i2;
            for (i2 = 0; i2 < buffer.position(); ++i2) {
                BufferUtil.appendContentChar(buf, buffer.get(i2));
                if (i2 != 8 || buffer.position() <= 16) continue;
                buf.append("...");
                i2 = buffer.position() - 8;
            }
            buf.append("<<<");
            for (i2 = buffer.position(); i2 < buffer.limit(); ++i2) {
                BufferUtil.appendContentChar(buf, buffer.get(i2));
                if (i2 != buffer.position() + 24 || buffer.limit() <= buffer.position() + 48) continue;
                buf.append("...");
                i2 = buffer.limit() - 24;
            }
            buf.append(">>>");
            int limit = buffer.limit();
            buffer.limit(buffer.capacity());
            for (int i3 = limit; i3 < buffer.capacity(); ++i3) {
                BufferUtil.appendContentChar(buf, buffer.get(i3));
                if (i3 != limit + 8 || buffer.capacity() <= limit + 16) continue;
                buf.append("...");
                i3 = buffer.capacity() - 8;
            }
            buffer.limit(limit);
        }
        catch (Throwable x2) {
            Log.getRootLogger().ignore(x2);
            buf.append("!!concurrent mod!!");
        }
    }

    private static void appendContentChar(StringBuilder buf, byte b2) {
        if (b2 == 92) {
            buf.append("\\\\");
        } else if (b2 >= 32 && b2 <= 126) {
            buf.append((char)b2);
        } else if (b2 == 13) {
            buf.append("\\r");
        } else if (b2 == 10) {
            buf.append("\\n");
        } else if (b2 == 9) {
            buf.append("\\t");
        } else {
            buf.append("\\x").append(TypeUtil.toHexString(b2));
        }
    }

    public static void putCRLF(ByteBuffer buffer) {
        buffer.put((byte)13);
        buffer.put((byte)10);
    }

    public static ByteBuffer ensureCapacity(ByteBuffer buffer, int capacity) {
        if (buffer == null) {
            return BufferUtil.allocate(capacity);
        }
        if (buffer.capacity() >= capacity) {
            return buffer;
        }
        if (buffer.hasArray()) {
            return ByteBuffer.wrap(Arrays.copyOfRange(buffer.array(), buffer.arrayOffset(), buffer.arrayOffset() + capacity), buffer.position(), buffer.remaining());
        }
        throw new UnsupportedOperationException();
    }
}

