/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.resource;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.URIUtil;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.resource.JarResource;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarFileResource
extends JarResource {
    private static final Logger LOG = Log.getLogger(JarFileResource.class);
    private JarFile _jarFile;
    private File _file;
    private String[] _list;
    private JarEntry _entry;
    private boolean _directory;
    private String _jarUrl;
    private String _path;
    private boolean _exists;

    protected JarFileResource(URL url, boolean useCaches) {
        super(url, useCaches);
    }

    @Override
    public synchronized void close() {
        this._exists = false;
        this._list = null;
        this._entry = null;
        this._file = null;
        if (!this.getUseCaches() && this._jarFile != null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Closing JarFile " + this._jarFile.getName(), new Object[0]);
                }
                this._jarFile.close();
            }
            catch (IOException ioe) {
                LOG.ignore(ioe);
            }
        }
        this._jarFile = null;
        super.close();
    }

    @Override
    protected synchronized boolean checkConnection() {
        try {
            super.checkConnection();
        }
        finally {
            if (this._jarConnection == null) {
                this._entry = null;
                this._file = null;
                this._jarFile = null;
                this._list = null;
            }
        }
        return this._jarFile != null;
    }

    @Override
    protected synchronized void newConnection() throws IOException {
        super.newConnection();
        this._entry = null;
        this._file = null;
        this._jarFile = null;
        this._list = null;
        int sep = this._urlString.lastIndexOf("!/");
        this._jarUrl = this._urlString.substring(0, sep + 2);
        this._path = URIUtil.decodePath(this._urlString.substring(sep + 2));
        if (this._path.length() == 0) {
            this._path = null;
        }
        this._jarFile = this._jarConnection.getJarFile();
        this._file = new File(this._jarFile.getName());
    }

    @Override
    public boolean exists() {
        if (this._exists) {
            return true;
        }
        if (this._urlString.endsWith("!/")) {
            String fileUrl = this._urlString.substring(4, this._urlString.length() - 2);
            try {
                return JarFileResource.newResource(fileUrl).exists();
            }
            catch (Exception e2) {
                LOG.ignore(e2);
                return false;
            }
        }
        boolean check = this.checkConnection();
        if (this._jarUrl != null && this._path == null) {
            this._directory = check;
            return true;
        }
        boolean closeJarFile = false;
        JarFile jarFile = null;
        if (check) {
            jarFile = this._jarFile;
        } else {
            try {
                JarURLConnection c2 = (JarURLConnection)new URL(this._jarUrl).openConnection();
                c2.setUseCaches(this.getUseCaches());
                jarFile = c2.getJarFile();
                closeJarFile = !this.getUseCaches();
            }
            catch (Exception e3) {
                LOG.ignore(e3);
            }
        }
        if (jarFile != null && this._entry == null && !this._directory) {
            JarEntry entry = jarFile.getJarEntry(this._path);
            if (entry == null) {
                this._exists = false;
            } else if (entry.isDirectory()) {
                this._directory = true;
                this._entry = entry;
            } else {
                JarEntry directory = jarFile.getJarEntry(this._path + '/');
                if (directory != null) {
                    this._directory = true;
                    this._entry = directory;
                } else {
                    this._directory = false;
                    this._entry = entry;
                }
            }
        }
        if (closeJarFile && jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException ioe) {
                LOG.ignore(ioe);
            }
        }
        this._exists = this._directory || this._entry != null;
        return this._exists;
    }
}

