/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.resource;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.resource.BadResource;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.resource.JarFileResource;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.resource.JarResource;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.resource.PathResource;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.resource.URLResource;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;

public abstract class Resource
implements Closeable {
    private static final Logger LOG = Log.getLogger(Resource.class);
    public static boolean __defaultUseCaches = true;

    public static Resource newResource(URL url) {
        return Resource.newResource(url, __defaultUseCaches);
    }

    static Resource newResource(URL url, boolean useCaches) {
        if (url == null) {
            return null;
        }
        String urlString = url.toExternalForm();
        if (urlString.startsWith("file:")) {
            try {
                return new PathResource(url);
            }
            catch (Exception e2) {
                LOG.warn(e2.toString(), new Object[0]);
                LOG.debug("EXCEPTION ", e2);
                return new BadResource(url, e2.toString());
            }
        }
        if (urlString.startsWith("jar:file:")) {
            return new JarFileResource(url, useCaches);
        }
        if (urlString.startsWith("jar:")) {
            return new JarResource(url, useCaches);
        }
        return new URLResource(url, null, useCaches);
    }

    public static Resource newResource(String resource) throws IOException {
        return Resource.newResource(resource, __defaultUseCaches);
    }

    public static Resource newResource(String resource, boolean useCaches) throws IOException {
        URL url = null;
        try {
            url = new URL(resource);
        }
        catch (MalformedURLException e2) {
            if (!(resource.startsWith("ftp:") || resource.startsWith("file:") || resource.startsWith("jar:"))) {
                return new PathResource(Paths.get(resource, new String[0]));
            }
            LOG.warn("Bad Resource: " + resource, new Object[0]);
            throw e2;
        }
        return Resource.newResource(url, useCaches);
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public abstract void close();

    public abstract boolean exists();

    public abstract String getName();

    public abstract InputStream getInputStream() throws IOException;
}

