/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.api.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public final class WSURI {
    public static URI toWebsocket(URI inputUri) throws URISyntaxException {
        Objects.requireNonNull(inputUri, "Input URI must not be null");
        String httpScheme = inputUri.getScheme();
        if ("ws".equalsIgnoreCase(httpScheme) || "wss".equalsIgnoreCase(httpScheme)) {
            return inputUri;
        }
        if ("http".equalsIgnoreCase(httpScheme)) {
            return new URI("ws" + inputUri.toString().substring(httpScheme.length()));
        }
        if ("https".equalsIgnoreCase(httpScheme)) {
            return new URI("wss" + inputUri.toString().substring(httpScheme.length()));
        }
        throw new URISyntaxException(inputUri.toString(), "Unrecognized HTTP scheme");
    }
}

