/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.common;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.component.AbstractLifeCycle;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.component.Dumpable;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.component.LifeCycle;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.common.WebSocketSession;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.common.WebSocketSessionListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SessionTracker
extends AbstractLifeCycle
implements Dumpable,
WebSocketSessionListener {
    private final Set<WebSocketSession> sessions = Collections.newSetFromMap(new ConcurrentHashMap());

    public Set<WebSocketSession> getSessions() {
        return Collections.unmodifiableSet(new HashSet<WebSocketSession>(this.sessions));
    }

    @Override
    public void onSessionCreated(WebSocketSession session) {
        LifeCycle.start(session);
        this.sessions.add(session);
    }

    @Override
    public void onSessionClosed(WebSocketSession session) {
        this.sessions.remove(session);
        LifeCycle.stop(session);
    }

    @Override
    protected void doStop() throws Exception {
        for (WebSocketSession session : this.sessions) {
            LifeCycle.stop(session);
        }
        super.doStop();
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, this.sessions);
    }
}

