/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.common.events;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.Utf8Appendable;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.component.AbstractLifeCycle;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.api.BadPayloadException;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.api.extensions.Frame;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.common.CloseInfo;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.common.WebSocketSession;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.common.events.EventDriver;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.common.frames.CloseFrame;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.common.message.MessageAppender;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;

public abstract class AbstractEventDriver
extends AbstractLifeCycle
implements EventDriver {
    private final Logger logger = Log.getLogger(this.getClass());
    protected final Logger targetLog;
    protected WebSocketPolicy policy;
    protected final Object websocket;
    protected WebSocketSession session;
    protected MessageAppender activeMessage;

    public AbstractEventDriver(WebSocketPolicy policy, Object websocket) {
        this.policy = policy;
        this.websocket = Objects.requireNonNull(websocket, "WebSocket endpoint may not be null");
        this.targetLog = Log.getLogger(websocket.getClass());
    }

    protected void appendMessage(ByteBuffer buffer, boolean fin) throws IOException {
        this.activeMessage.appendFrame(buffer, fin);
        if (fin) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    protected void dispatch(Runnable runnable) {
        this.session.dispatch(runnable);
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public void incomingFrame(Frame frame) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("incomingFrame({})", frame);
        }
        try {
            this.onFrame(frame);
            byte opcode = frame.getOpCode();
            switch (opcode) {
                case 8: {
                    boolean validate = true;
                    CloseFrame closeframe = (CloseFrame)frame;
                    CloseInfo close = new CloseInfo(closeframe, validate);
                    this.session.getConnection().remoteClose(close);
                    return;
                }
                case 9: {
                    ByteBuffer pongBuf;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("PING: {}", BufferUtil.toDetailString(frame.getPayload()));
                    }
                    if (frame.hasPayload()) {
                        pongBuf = ByteBuffer.allocate(frame.getPayload().remaining());
                        BufferUtil.put(frame.getPayload().slice(), pongBuf);
                        BufferUtil.flipToFlush(pongBuf, 0);
                    } else {
                        pongBuf = ByteBuffer.allocate(0);
                    }
                    this.onPing(frame.getPayload());
                    this.session.getRemote().sendPong(pongBuf);
                    break;
                }
                case 10: {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("PONG: {}", BufferUtil.toDetailString(frame.getPayload()));
                    }
                    this.onPong(frame.getPayload());
                    break;
                }
                case 2: {
                    this.onBinaryFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                case 1: {
                    this.onTextFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                case 0: {
                    this.onContinuationFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                default: {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Unhandled OpCode: {}", opcode);
                    }
                    break;
                }
            }
        }
        catch (Utf8Appendable.NotUtf8Exception e2) {
            this.session.close(new BadPayloadException(e2));
        }
        catch (Throwable t2) {
            this.session.close(t2);
        }
    }

    public void onContinuationFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.activeMessage == null) {
            throw new IOException("Out of order Continuation frame encountered");
        }
        this.appendMessage(buffer, fin);
    }

    public void onPong(ByteBuffer buffer) {
    }

    public void onPing(ByteBuffer buffer) {
    }

    @Override
    public void openSession(WebSocketSession session) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("openSession({}) objectFactory={}", session, session.getContainerScope().getObjectFactory());
        }
        this.session = session;
        this.session.getContainerScope().getObjectFactory().decorate(this.websocket);
        try {
            this.onConnect();
        }
        catch (Throwable t2) {
            this.session.close(t2);
        }
    }
}

