/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.jacoco.core.data;

import com.gradle.enterprise.testdistribution.internal.dep.org.jacoco.core.data.ExecutionData;
import com.gradle.enterprise.testdistribution.internal.dep.org.jacoco.core.data.IExecutionDataVisitor;
import com.gradle.enterprise.testdistribution.internal.dep.org.jacoco.core.data.ISessionInfoVisitor;
import com.gradle.enterprise.testdistribution.internal.dep.org.jacoco.core.data.SessionInfo;
import com.gradle.enterprise.testdistribution.internal.dep.org.jacoco.core.internal.data.CompactDataOutput;
import java.io.IOException;
import java.io.OutputStream;

public class ExecutionDataWriter
implements IExecutionDataVisitor,
ISessionInfoVisitor {
    public static final char FORMAT_VERSION = (char)4103;
    protected final CompactDataOutput out;

    public ExecutionDataWriter(OutputStream output) throws IOException {
        this.out = new CompactDataOutput(output);
        this.writeHeader();
    }

    private void writeHeader() throws IOException {
        this.out.writeByte(1);
        this.out.writeChar(49344);
        this.out.writeChar(FORMAT_VERSION);
    }

    public void visitSessionInfo(SessionInfo info) {
        try {
            this.out.writeByte(16);
            this.out.writeUTF(info.getId());
            this.out.writeLong(info.getStartTimeStamp());
            this.out.writeLong(info.getDumpTimeStamp());
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void visitClassExecution(ExecutionData data) {
        if (data.hasHits()) {
            try {
                this.out.writeByte(17);
                this.out.writeLong(data.getId());
                this.out.writeUTF(data.getName());
                this.out.writeBooleanArray(data.getProbes());
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }
}

