/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.objectweb.asm;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;

final class Constants {
    static void checkAsmExperimental(Object caller) {
        Class<?> callerClass = caller.getClass();
        String internalName = callerClass.getName().replace('.', '/');
        if (!Constants.isWhitelisted(internalName)) {
            Constants.checkIsPreview(callerClass.getClassLoader().getResourceAsStream(internalName + ".class"));
        }
    }

    static boolean isWhitelisted(String internalName) {
        if (!internalName.startsWith("com/gradle/enterprise/testdistribution/internal/dep/org/objectweb/asm/")) {
            return false;
        }
        String member = "(Annotation|Class|Field|Method|Module|RecordComponent|Signature)";
        return internalName.contains("Test$") || Pattern.matches("com/gradle/enterprise/testdistribution/internal/dep/org/objectweb/asm/util/Trace" + member + "Visitor(\\$.*)?", internalName) || Pattern.matches("com/gradle/enterprise/testdistribution/internal/dep/org/objectweb/asm/util/Check" + member + "Adapter(\\$.*)?", internalName);
    }

    static void checkIsPreview(InputStream classInputStream) {
        int minorVersion;
        if (classInputStream == null) {
            throw new IllegalStateException("Bytecode not available, can't check class version");
        }
        try {
            DataInputStream callerClassStream = new DataInputStream(classInputStream);
            try {
                callerClassStream.readInt();
                minorVersion = callerClassStream.readUnsignedShort();
            }
            catch (Throwable throwable) {
                try {
                    callerClassStream.close();
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            callerClassStream.close();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("I/O error, can't check class version", ioe);
        }
        if (minorVersion != 65535) {
            throw new IllegalStateException("ASM9_EXPERIMENTAL can only be used by classes compiled with --enable-preview");
        }
    }
}

