/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.gradleplugin.testdistribution.internal;

import com.gradle.enterprise.gradleplugin.testacceleration.internal.WorkspaceRootSpec;
import com.gradle.enterprise.gradleplugin.testdistribution.TestDistributionExtension;
import com.gradle.enterprise.gradleplugin.testdistribution.internal.ProcessedResourcesSpec;
import com.gradle.enterprise.gradleplugin.testdistribution.internal.TestDistributionExtensionInternal;
import com.gradle.enterprise.gradleplugin.testdistribution.internal.a;
import com.gradle.enterprise.testacceleration.client.a.au;
import com.gradle.obfuscation.Keep;
import com.gradle.scan.plugin.internal.g;
import java.io.File;
import java.time.Duration;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.testing.Test;

@Keep
public abstract class DefaultTestDistributionExtension
implements TestDistributionExtensionInternal {
    private static final String ACCESS_KEYS_PATH_IN_GRADLE_USER_HOME = "enterprise/keys.properties";
    private static final String DEFAULT_TEST_DISTRIBUTION_OUTPUTS_LOCATION = "test-distribution-outputs";
    private final NamedDomainObjectContainer<ProcessedResourcesSpec> processedResources;
    private final NamedDomainObjectContainer<WorkspaceRootSpec> workspaceRoots;
    private final TestDistributionExtension.RestrictedExecutionCriteria localExecutionCriteria;
    private final TestDistributionExtension.RestrictedExecutionCriteria remoteExecutionCriteria;

    @Inject
    public DefaultTestDistributionExtension(Test test, ProviderFactory providerFactory, Provider<g.b> provider) {
        Project project = test.getProject();
        ObjectFactory objectFactory = project.getObjects();
        this.getEnabled().convention((Object)false);
        this.getMaxLocalExecutors().convention(providerFactory.provider(() -> ((Test)test).getMaxParallelForks()));
        this.getRemoteExecutionPreferred().convention((Object)false);
        this.getWaitTimeout().convention((Object)Duration.ofSeconds(30L));
        this.processedResources = project.container(ProcessedResourcesSpec.class, (NamedDomainObjectFactory)new ProcessedResourcesSpecFactory(objectFactory));
        this.getRequirements().empty();
        this.getServer().convention(com.gradle.enterprise.gradleplugin.testacceleration.internal.a.a(providerFactory, provider));
        this.getAccessKey().convention(com.gradle.enterprise.gradleplugin.testacceleration.internal.a.b(providerFactory, provider));
        this.getAllowUntrustedServer().convention(com.gradle.enterprise.gradleplugin.testacceleration.internal.a.c(providerFactory, provider));
        this.getWriteTraceFile().convention(providerFactory.provider(() -> a.b(project)));
        this.getWriteTestEventLogFile().convention(providerFactory.provider(() -> a.c(project)));
        this.getForkedVMShutdownTimeout().convention((Object)au.a);
        this.getShowStacktraces().convention((Object)(project.getGradle().getStartParameter().getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS ? 1 : 0));
        this.getRootProjectName().convention((Object)project.getRootProject().getName());
        this.getAllowUseWithoutBuildScans().convention((Object)a.a(project));
        this.getTestDistributionOutputs().convention(project.getLayout().getBuildDirectory().dir("test-distribution-outputs/" + test.getName()));
        this.getRetryInSameJvm().convention((Object)Boolean.TRUE);
        this.getUnknownHistoryPartitionSize().convention(providerFactory.provider(a::c));
        this.workspaceRoots = project.container(WorkspaceRootSpec.class);
        this.workspaceRoots.add((Object)new WorkspaceRootSpec("rootDir", project.getRootDir().toPath()));
        this.workspaceRoots.add((Object)new WorkspaceRootSpec("projectDir", project.getProjectDir().toPath()));
        File file = project.getGradle().getGradleHomeDir();
        if (file != null) {
            this.workspaceRoots.add((Object)new WorkspaceRootSpec("gradleHome", file.toPath()));
        }
        File file2 = project.getGradle().getGradleUserHomeDir();
        this.workspaceRoots.add((Object)new WorkspaceRootSpec("gradleUserHome", file2.toPath()));
        this.getAccessKeyLocation().convention(project.getLayout().file(providerFactory.provider(() -> new File(file2, ACCESS_KEYS_PATH_IN_GRADLE_USER_HOME))));
        this.localExecutionCriteria = (TestDistributionExtension.RestrictedExecutionCriteria)objectFactory.newInstance(TestDistributionExtension.RestrictedExecutionCriteria.class, new Object[0]);
        this.remoteExecutionCriteria = (TestDistributionExtension.RestrictedExecutionCriteria)objectFactory.newInstance(TestDistributionExtension.RestrictedExecutionCriteria.class, new Object[0]);
    }

    @Override
    public NamedDomainObjectContainer<ProcessedResourcesSpec> getProcessedResources() {
        return this.processedResources;
    }

    @Override
    public void processedResources(Action<? super NamedDomainObjectContainer<ProcessedResourcesSpec>> action) {
        action.execute(this.processedResources);
    }

    @Override
    public NamedDomainObjectContainer<WorkspaceRootSpec> getWorkspaceRoots() {
        return this.workspaceRoots;
    }

    public boolean shouldTestRetryPluginBeDeactivated() {
        return (Boolean)this.getDeactivateRetryPlugin().get();
    }

    @Override
    @Keep
    public TestDistributionExtension.RestrictedExecutionCriteria getLocalOnly() {
        return this.localExecutionCriteria;
    }

    @Override
    @Keep
    public void localOnly(Action<? super TestDistributionExtension.RestrictedExecutionCriteria> action) {
        action.execute((Object)this.localExecutionCriteria);
    }

    @Override
    @Keep
    public TestDistributionExtension.RestrictedExecutionCriteria getRemoteOnly() {
        return this.remoteExecutionCriteria;
    }

    @Override
    @Keep
    public void remoteOnly(Action<? super TestDistributionExtension.RestrictedExecutionCriteria> action) {
        action.execute((Object)this.remoteExecutionCriteria);
    }

    @Keep
    private static class ProcessedResourcesSpecFactory
    implements NamedDomainObjectFactory<ProcessedResourcesSpec> {
        private final ObjectFactory objectFactory;

        @Inject
        public ProcessedResourcesSpecFactory(ObjectFactory objectFactory) {
            this.objectFactory = objectFactory;
        }

        public ProcessedResourcesSpec create(String string) {
            return (ProcessedResourcesSpec)this.objectFactory.newInstance(ProcessedResourcesSpec.class, new Object[]{string, this.objectFactory});
        }
    }
}

