/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.io;

import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.KryoException;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.io.Input;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class ByteBufferInput
extends Input {
    protected ByteBuffer niobuffer;
    protected boolean varIntsEnabled = true;
    ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected static final ByteOrder nativeOrder = ByteOrder.nativeOrder();

    public ByteBufferInput() {
    }

    public ByteBufferInput(ByteBuffer byteBuffer) {
        this.setBuffer(byteBuffer);
    }

    public void setBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        this.niobuffer = byteBuffer;
        this.position = byteBuffer.position();
        this.limit = byteBuffer.limit();
        this.capacity = byteBuffer.capacity();
        this.byteOrder = byteBuffer.order();
        this.total = 0L;
        this.inputStream = null;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    protected int fill(ByteBuffer byteBuffer, int n2, int n3) throws KryoException {
        if (this.inputStream == null) {
            return -1;
        }
        try {
            byte[] byArray = new byte[n3];
            int n4 = this.inputStream.read(byArray, 0, n3);
            byteBuffer.position(n2);
            if (n4 >= 0) {
                byteBuffer.put(byArray, 0, n4);
                byteBuffer.position(n2);
            }
            return n4;
        }
        catch (IOException iOException) {
            throw new KryoException(iOException);
        }
    }

    @Override
    protected final int require(int n2) throws KryoException {
        int n3;
        int n4 = this.limit - this.position;
        if (n4 >= n2) {
            return n4;
        }
        if (n2 > this.capacity) {
            throw new KryoException("Buffer too small: capacity: " + this.capacity + ", required: " + n2);
        }
        if (n4 > 0) {
            n3 = this.fill(this.niobuffer, this.limit, this.capacity - this.limit);
            if (n3 == -1) {
                throw new KryoException("Buffer underflow.");
            }
            if ((n4 += n3) >= n2) {
                this.limit += n3;
                return n4;
            }
        }
        this.niobuffer.position(this.position);
        this.niobuffer.compact();
        this.total += (long)this.position;
        this.position = 0;
        do {
            if ((n3 = this.fill(this.niobuffer, n4, this.capacity - n4)) != -1) continue;
            if (n4 >= n2) break;
            throw new KryoException("Buffer underflow.");
        } while ((n4 += n3) < n2);
        this.limit = n4;
        this.niobuffer.position(0);
        return n4;
    }

    private int optional(int n2) throws KryoException {
        int n3 = this.limit - this.position;
        if (n3 >= n2) {
            return n2;
        }
        n2 = Math.min(n2, this.capacity);
        int n4 = this.fill(this.niobuffer, this.limit, this.capacity - this.limit);
        if (n4 == -1) {
            return n3 == 0 ? -1 : Math.min(n3, n2);
        }
        if ((n3 += n4) >= n2) {
            this.limit += n4;
            return n2;
        }
        this.niobuffer.compact();
        this.total += (long)this.position;
        this.position = 0;
        while ((n4 = this.fill(this.niobuffer, n3, this.capacity - n3)) != -1 && (n3 += n4) < n2) {
        }
        this.limit = n3;
        this.niobuffer.position(this.position);
        return n3 == 0 ? -1 : Math.min(n3, n2);
    }

    @Override
    public int read() throws KryoException {
        if (this.optional(1) <= 0) {
            return -1;
        }
        this.niobuffer.position(this.position);
        ++this.position;
        return this.niobuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws KryoException {
        this.niobuffer.position(this.position);
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws KryoException {
        this.niobuffer.position(this.position);
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int n4 = n3;
        int n5 = Math.min(this.limit - this.position, n3);
        do {
            this.niobuffer.get(byArray, n2, n5);
            this.position += n5;
            if ((n3 -= n5) == 0) break;
            n2 += n5;
            n5 = this.optional(n3);
            if (n5 != -1) continue;
            if (n4 == n3) {
                return -1;
            }
            break;
        } while (this.position != this.limit);
        return n4 - n3;
    }

    @Override
    public void skip(int n2) throws KryoException {
        super.skip(n2);
        this.niobuffer.position(this.position());
    }

    @Override
    public long skip(long l2) throws KryoException {
        int n2;
        for (long i2 = l2; i2 > 0L; i2 -= (long)n2) {
            n2 = (int)Math.min(0x7FFFFFF7L, i2);
            this.skip(n2);
        }
        return l2;
    }

    @Override
    public void close() throws KryoException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public byte readByte() throws KryoException {
        this.niobuffer.position(this.position);
        this.require(1);
        ++this.position;
        return this.niobuffer.get();
    }

    @Override
    public byte[] readBytes(int n2) throws KryoException {
        byte[] byArray = new byte[n2];
        this.readBytes(byArray, 0, n2);
        return byArray;
    }

    @Override
    public void readBytes(byte[] byArray, int n2, int n3) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int n4 = Math.min(this.limit - this.position, n3);
        while (true) {
            this.niobuffer.get(byArray, n2, n4);
            this.position += n4;
            if ((n3 -= n4) == 0) break;
            n2 += n4;
            n4 = Math.min(n3, this.capacity);
            this.require(n4);
        }
    }

    @Override
    public int readInt() throws KryoException {
        this.require(4);
        this.position += 4;
        return this.niobuffer.getInt();
    }

    @Override
    public int readInt(boolean bl2) throws KryoException {
        if (this.varIntsEnabled) {
            return this.readVarInt(bl2);
        }
        return this.readInt();
    }

    @Override
    public int readVarInt(boolean bl2) throws KryoException {
        this.niobuffer.position(this.position);
        if (this.require(1) < 5) {
            return this.readInt_slow(bl2);
        }
        ++this.position;
        byte by2 = this.niobuffer.get();
        int n2 = by2 & 0x7F;
        if ((by2 & 0x80) != 0) {
            ++this.position;
            by2 = this.niobuffer.get();
            n2 |= (by2 & 0x7F) << 7;
            if ((by2 & 0x80) != 0) {
                ++this.position;
                by2 = this.niobuffer.get();
                n2 |= (by2 & 0x7F) << 14;
                if ((by2 & 0x80) != 0) {
                    ++this.position;
                    by2 = this.niobuffer.get();
                    n2 |= (by2 & 0x7F) << 21;
                    if ((by2 & 0x80) != 0) {
                        ++this.position;
                        by2 = this.niobuffer.get();
                        n2 |= (by2 & 0x7F) << 28;
                    }
                }
            }
        }
        return bl2 ? n2 : n2 >>> 1 ^ -(n2 & 1);
    }

    private int readInt_slow(boolean bl2) {
        ++this.position;
        byte by2 = this.niobuffer.get();
        int n2 = by2 & 0x7F;
        if ((by2 & 0x80) != 0) {
            this.require(1);
            ++this.position;
            by2 = this.niobuffer.get();
            n2 |= (by2 & 0x7F) << 7;
            if ((by2 & 0x80) != 0) {
                this.require(1);
                ++this.position;
                by2 = this.niobuffer.get();
                n2 |= (by2 & 0x7F) << 14;
                if ((by2 & 0x80) != 0) {
                    this.require(1);
                    ++this.position;
                    by2 = this.niobuffer.get();
                    n2 |= (by2 & 0x7F) << 21;
                    if ((by2 & 0x80) != 0) {
                        this.require(1);
                        ++this.position;
                        by2 = this.niobuffer.get();
                        n2 |= (by2 & 0x7F) << 28;
                    }
                }
            }
        }
        return bl2 ? n2 : n2 >>> 1 ^ -(n2 & 1);
    }

    @Override
    public String readString() {
        this.niobuffer.position(this.position);
        int n2 = this.require(1);
        ++this.position;
        byte by2 = this.niobuffer.get();
        if ((by2 & 0x80) == 0) {
            return this.readAscii();
        }
        int n3 = n2 >= 5 ? this.readUtf8Length(by2) : this.readUtf8Length_slow(by2);
        switch (n3) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
        }
        if (this.chars.length < --n3) {
            this.chars = new char[n3];
        }
        this.readUtf8(n3);
        return new String(this.chars, 0, n3);
    }

    private int readUtf8Length(int n2) {
        int n3 = n2 & 0x3F;
        if ((n2 & 0x40) != 0) {
            ++this.position;
            n2 = this.niobuffer.get();
            n3 |= (n2 & 0x7F) << 6;
            if ((n2 & 0x80) != 0) {
                ++this.position;
                n2 = this.niobuffer.get();
                n3 |= (n2 & 0x7F) << 13;
                if ((n2 & 0x80) != 0) {
                    ++this.position;
                    n2 = this.niobuffer.get();
                    n3 |= (n2 & 0x7F) << 20;
                    if ((n2 & 0x80) != 0) {
                        ++this.position;
                        n2 = this.niobuffer.get();
                        n3 |= (n2 & 0x7F) << 27;
                    }
                }
            }
        }
        return n3;
    }

    private int readUtf8Length_slow(int n2) {
        int n3 = n2 & 0x3F;
        if ((n2 & 0x40) != 0) {
            this.require(1);
            ++this.position;
            n2 = this.niobuffer.get();
            n3 |= (n2 & 0x7F) << 6;
            if ((n2 & 0x80) != 0) {
                this.require(1);
                ++this.position;
                n2 = this.niobuffer.get();
                n3 |= (n2 & 0x7F) << 13;
                if ((n2 & 0x80) != 0) {
                    this.require(1);
                    ++this.position;
                    n2 = this.niobuffer.get();
                    n3 |= (n2 & 0x7F) << 20;
                    if ((n2 & 0x80) != 0) {
                        this.require(1);
                        ++this.position;
                        n2 = this.niobuffer.get();
                        n3 |= (n2 & 0x7F) << 27;
                    }
                }
            }
        }
        return n3;
    }

    private void readUtf8(int n2) {
        char[] cArray = this.chars;
        int n3 = 0;
        int n4 = Math.min(this.require(1), n2);
        int n5 = this.position;
        while (n3 < n4) {
            ++n5;
            byte by2 = this.niobuffer.get();
            if (by2 < 0) {
                --n5;
                break;
            }
            cArray[n3++] = (char)by2;
        }
        this.position = n5;
        if (n3 < n2) {
            this.niobuffer.position(n5);
            this.readUtf8_slow(n2, n3);
        }
    }

    private void readUtf8_slow(int n2, int n3) {
        char[] cArray = this.chars;
        while (n3 < n2) {
            if (this.position == this.limit) {
                this.require(1);
            }
            ++this.position;
            int n4 = this.niobuffer.get() & 0xFF;
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n3] = (char)n4;
                    break;
                }
                case 12: 
                case 13: {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    ++this.position;
                    cArray[n3] = (char)((n4 & 0x1F) << 6 | this.niobuffer.get() & 0x3F);
                    break;
                }
                case 14: {
                    this.require(2);
                    this.position += 2;
                    byte by2 = this.niobuffer.get();
                    byte by3 = this.niobuffer.get();
                    cArray[n3] = (char)((n4 & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
                }
            }
            ++n3;
        }
    }

    private String readAscii() {
        byte by2;
        int n2 = this.position;
        int n3 = n2 - 1;
        int n4 = this.limit;
        do {
            if (n2 == n4) {
                return this.readAscii_slow();
            }
            ++n2;
        } while (((by2 = this.niobuffer.get()) & 0x80) == 0);
        this.niobuffer.put(n2 - 1, (byte)(this.niobuffer.get(n2 - 1) & 0x7F));
        byte[] byArray = new byte[n2 - n3];
        this.niobuffer.position(n3);
        this.niobuffer.get(byArray);
        String string = new String(byArray, 0, 0, n2 - n3);
        this.niobuffer.put(n2 - 1, (byte)(this.niobuffer.get(n2 - 1) | 0x80));
        this.position = n2;
        this.niobuffer.position(this.position);
        return string;
    }

    private String readAscii_slow() {
        --this.position;
        int n2 = this.limit - this.position;
        if (n2 > this.chars.length) {
            this.chars = new char[n2 * 2];
        }
        char[] cArray = this.chars;
        int n3 = this.position;
        int n4 = 0;
        int n5 = this.limit;
        while (n3 < n5) {
            cArray[n4] = (char)this.niobuffer.get(n3);
            ++n3;
            ++n4;
        }
        this.position = this.limit;
        while (true) {
            this.require(1);
            ++this.position;
            n3 = this.niobuffer.get();
            if (n2 == cArray.length) {
                char[] cArray2 = new char[n2 * 2];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
                cArray = cArray2;
                this.chars = cArray2;
            }
            if ((n3 & 0x80) == 128) break;
            cArray[n2++] = (char)n3;
        }
        cArray[n2++] = (char)(n3 & 0x7F);
        return new String(cArray, 0, n2);
    }

    @Override
    public StringBuilder readStringBuilder() {
        this.niobuffer.position(this.position);
        int n2 = this.require(1);
        ++this.position;
        byte by2 = this.niobuffer.get();
        if ((by2 & 0x80) == 0) {
            return new StringBuilder(this.readAscii());
        }
        int n3 = n2 >= 5 ? this.readUtf8Length(by2) : this.readUtf8Length_slow(by2);
        switch (n3) {
            case 0: {
                return null;
            }
            case 1: {
                return new StringBuilder("");
            }
        }
        if (this.chars.length < --n3) {
            this.chars = new char[n3];
        }
        this.readUtf8(n3);
        StringBuilder stringBuilder = new StringBuilder(n3);
        stringBuilder.append(this.chars, 0, n3);
        return stringBuilder;
    }

    @Override
    public float readFloat() throws KryoException {
        this.require(4);
        this.position += 4;
        return this.niobuffer.getFloat();
    }

    @Override
    public short readShort() throws KryoException {
        this.require(2);
        this.position += 2;
        return this.niobuffer.getShort();
    }

    @Override
    public long readLong() throws KryoException {
        this.require(8);
        this.position += 8;
        return this.niobuffer.getLong();
    }

    @Override
    public long readLong(boolean bl2) throws KryoException {
        if (this.varIntsEnabled) {
            return this.readVarLong(bl2);
        }
        return this.readLong();
    }

    @Override
    public long readVarLong(boolean bl2) throws KryoException {
        this.niobuffer.position(this.position);
        if (this.require(1) < 9) {
            return this.readLong_slow(bl2);
        }
        ++this.position;
        byte by2 = this.niobuffer.get();
        long l2 = by2 & 0x7F;
        if ((by2 & 0x80) != 0) {
            ++this.position;
            by2 = this.niobuffer.get();
            l2 |= (long)((by2 & 0x7F) << 7);
            if ((by2 & 0x80) != 0) {
                ++this.position;
                by2 = this.niobuffer.get();
                l2 |= (long)((by2 & 0x7F) << 14);
                if ((by2 & 0x80) != 0) {
                    ++this.position;
                    by2 = this.niobuffer.get();
                    l2 |= (long)((by2 & 0x7F) << 21);
                    if ((by2 & 0x80) != 0) {
                        ++this.position;
                        by2 = this.niobuffer.get();
                        l2 |= (long)(by2 & 0x7F) << 28;
                        if ((by2 & 0x80) != 0) {
                            ++this.position;
                            by2 = this.niobuffer.get();
                            l2 |= (long)(by2 & 0x7F) << 35;
                            if ((by2 & 0x80) != 0) {
                                ++this.position;
                                by2 = this.niobuffer.get();
                                l2 |= (long)(by2 & 0x7F) << 42;
                                if ((by2 & 0x80) != 0) {
                                    ++this.position;
                                    by2 = this.niobuffer.get();
                                    l2 |= (long)(by2 & 0x7F) << 49;
                                    if ((by2 & 0x80) != 0) {
                                        ++this.position;
                                        by2 = this.niobuffer.get();
                                        l2 |= (long)by2 << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!bl2) {
            l2 = l2 >>> 1 ^ -(l2 & 1L);
        }
        return l2;
    }

    private long readLong_slow(boolean bl2) {
        ++this.position;
        byte by2 = this.niobuffer.get();
        long l2 = by2 & 0x7F;
        if ((by2 & 0x80) != 0) {
            this.require(1);
            ++this.position;
            by2 = this.niobuffer.get();
            l2 |= (long)((by2 & 0x7F) << 7);
            if ((by2 & 0x80) != 0) {
                this.require(1);
                ++this.position;
                by2 = this.niobuffer.get();
                l2 |= (long)((by2 & 0x7F) << 14);
                if ((by2 & 0x80) != 0) {
                    this.require(1);
                    ++this.position;
                    by2 = this.niobuffer.get();
                    l2 |= (long)((by2 & 0x7F) << 21);
                    if ((by2 & 0x80) != 0) {
                        this.require(1);
                        ++this.position;
                        by2 = this.niobuffer.get();
                        l2 |= (long)(by2 & 0x7F) << 28;
                        if ((by2 & 0x80) != 0) {
                            this.require(1);
                            ++this.position;
                            by2 = this.niobuffer.get();
                            l2 |= (long)(by2 & 0x7F) << 35;
                            if ((by2 & 0x80) != 0) {
                                this.require(1);
                                ++this.position;
                                by2 = this.niobuffer.get();
                                l2 |= (long)(by2 & 0x7F) << 42;
                                if ((by2 & 0x80) != 0) {
                                    this.require(1);
                                    ++this.position;
                                    by2 = this.niobuffer.get();
                                    l2 |= (long)(by2 & 0x7F) << 49;
                                    if ((by2 & 0x80) != 0) {
                                        this.require(1);
                                        ++this.position;
                                        by2 = this.niobuffer.get();
                                        l2 |= (long)by2 << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!bl2) {
            l2 = l2 >>> 1 ^ -(l2 & 1L);
        }
        return l2;
    }

    @Override
    public boolean readBoolean() throws KryoException {
        this.require(1);
        ++this.position;
        return this.niobuffer.get() == 1;
    }

    @Override
    public char readChar() throws KryoException {
        this.require(2);
        this.position += 2;
        return this.niobuffer.getChar();
    }

    @Override
    public double readDouble() throws KryoException {
        this.require(8);
        this.position += 8;
        return this.niobuffer.getDouble();
    }

    @Override
    public float[] readFloats(int n2) throws KryoException {
        if (this.capacity - this.position >= n2 * 4 && this.isNativeOrder()) {
            float[] fArray = new float[n2];
            FloatBuffer floatBuffer = this.niobuffer.asFloatBuffer();
            floatBuffer.get(fArray);
            this.position += n2 * 4;
            this.niobuffer.position(this.position);
            return fArray;
        }
        return super.readFloats(n2);
    }

    @Override
    public short[] readShorts(int n2) throws KryoException {
        if (this.capacity - this.position >= n2 * 2 && this.isNativeOrder()) {
            short[] sArray = new short[n2];
            ShortBuffer shortBuffer = this.niobuffer.asShortBuffer();
            shortBuffer.get(sArray);
            this.position += n2 * 2;
            this.niobuffer.position(this.position);
            return sArray;
        }
        return super.readShorts(n2);
    }

    @Override
    public char[] readChars(int n2) throws KryoException {
        if (this.capacity - this.position >= n2 * 2 && this.isNativeOrder()) {
            char[] cArray = new char[n2];
            CharBuffer charBuffer = this.niobuffer.asCharBuffer();
            charBuffer.get(cArray);
            this.position += n2 * 2;
            this.niobuffer.position(this.position);
            return cArray;
        }
        return super.readChars(n2);
    }

    @Override
    public double[] readDoubles(int n2) throws KryoException {
        if (this.capacity - this.position >= n2 * 8 && this.isNativeOrder()) {
            double[] dArray = new double[n2];
            DoubleBuffer doubleBuffer = this.niobuffer.asDoubleBuffer();
            doubleBuffer.get(dArray);
            this.position += n2 * 8;
            this.niobuffer.position(this.position);
            return dArray;
        }
        return super.readDoubles(n2);
    }

    private boolean isNativeOrder() {
        return this.byteOrder == nativeOrder;
    }
}

