/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.io;

import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.KryoException;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class ByteBufferOutput
extends Output {
    protected ByteBuffer niobuffer;
    protected boolean varIntsEnabled = true;
    ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected static final ByteOrder nativeOrder = ByteOrder.nativeOrder();

    public ByteBufferOutput() {
    }

    public ByteBufferOutput(int n2) {
        this(n2, n2);
    }

    public ByteBufferOutput(int n2, int n3) {
        if (n3 < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + n3);
        }
        this.capacity = n2;
        this.maxCapacity = n3 == -1 ? 0x7FFFFFF7 : n3;
        this.niobuffer = ByteBuffer.allocateDirect(n2);
        this.niobuffer.order(this.byteOrder);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setBuffer(ByteBuffer byteBuffer, int n2) {
        if (byteBuffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        if (n2 < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + n2);
        }
        this.niobuffer = byteBuffer;
        this.maxCapacity = n2 == -1 ? 0x7FFFFFF7 : n2;
        this.byteOrder = byteBuffer.order();
        this.capacity = byteBuffer.capacity();
        this.position = byteBuffer.position();
        this.total = 0L;
        this.outputStream = null;
    }

    public ByteBuffer getByteBuffer() {
        this.niobuffer.position(this.position);
        return this.niobuffer;
    }

    @Override
    public byte[] toBytes() {
        byte[] byArray = new byte[this.position];
        this.niobuffer.position(0);
        this.niobuffer.get(byArray, 0, this.position);
        return byArray;
    }

    @Override
    protected boolean require(int n2) throws KryoException {
        if (this.capacity - this.position >= n2) {
            return false;
        }
        if (n2 > this.maxCapacity) {
            this.niobuffer.order(this.byteOrder);
            throw new KryoException("Buffer overflow. Max capacity: " + this.maxCapacity + ", required: " + n2);
        }
        this.flush();
        while (this.capacity - this.position < n2) {
            if (this.capacity == this.maxCapacity) {
                this.niobuffer.order(this.byteOrder);
                throw new KryoException("Buffer overflow. Available: " + (this.capacity - this.position) + ", required: " + n2);
            }
            if (this.capacity == 0) {
                this.capacity = 1;
            }
            this.capacity = Math.min(this.capacity * 2, this.maxCapacity);
            if (this.capacity < 0) {
                this.capacity = this.maxCapacity;
            }
            ByteBuffer byteBuffer = this.niobuffer != null && !this.niobuffer.isDirect() ? ByteBuffer.allocate(this.capacity) : ByteBuffer.allocateDirect(this.capacity);
            this.niobuffer.position(0);
            this.niobuffer.limit(this.position);
            byteBuffer.put(this.niobuffer);
            byteBuffer.order(this.niobuffer.order());
            ByteOrder byteOrder = this.byteOrder;
            this.setBuffer(byteBuffer, this.maxCapacity);
            this.byteOrder = byteOrder;
        }
        return true;
    }

    @Override
    public void flush() throws KryoException {
        if (this.outputStream == null) {
            return;
        }
        try {
            byte[] byArray = new byte[this.position];
            this.niobuffer.position(0);
            this.niobuffer.get(byArray);
            this.niobuffer.position(0);
            this.outputStream.write(byArray, 0, this.position);
        }
        catch (IOException iOException) {
            throw new KryoException(iOException);
        }
        this.total += (long)this.position;
        this.position = 0;
    }

    @Override
    public void close() throws KryoException {
        this.flush();
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void write(int n2) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.niobuffer.put((byte)n2);
        ++this.position;
    }

    @Override
    public void write(byte[] byArray) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws KryoException {
        this.writeBytes(byArray, n2, n3);
    }

    @Override
    public void writeByte(byte by2) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.niobuffer.put(by2);
        ++this.position;
    }

    @Override
    public void writeByte(int n2) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.niobuffer.put((byte)n2);
        ++this.position;
    }

    @Override
    public void writeBytes(byte[] byArray) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(byArray, 0, byArray.length);
    }

    @Override
    public void writeBytes(byte[] byArray, int n2, int n3) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int n4 = Math.min(this.capacity - this.position, n3);
        while (true) {
            this.niobuffer.put(byArray, n2, n4);
            this.position += n4;
            if ((n3 -= n4) == 0) {
                return;
            }
            n2 += n4;
            n4 = Math.min(this.capacity, n3);
            this.require(n4);
        }
    }

    @Override
    public void writeInt(int n2) throws KryoException {
        this.require(4);
        this.niobuffer.putInt(n2);
        this.position += 4;
    }

    @Override
    public int writeInt(int n2, boolean bl2) throws KryoException {
        if (!this.varIntsEnabled) {
            this.writeInt(n2);
            return 4;
        }
        return this.writeVarInt(n2, bl2);
    }

    @Override
    public int writeVarInt(int n2, boolean bl2) throws KryoException {
        this.niobuffer.position(this.position);
        int n3 = n2;
        if (!bl2) {
            n3 = n3 << 1 ^ n3 >> 31;
        }
        int n4 = 0;
        n4 = n3 & 0x7F;
        if ((n3 >>>= 7) == 0) {
            this.writeByte(n4);
            return 1;
        }
        n4 |= 0x80;
        n4 |= (n3 & 0x7F) << 8;
        if ((n3 >>>= 7) == 0) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(n4);
            this.niobuffer.order(this.byteOrder);
            this.position -= 2;
            this.niobuffer.position(this.position);
            return 2;
        }
        n4 |= 0x8000;
        n4 |= (n3 & 0x7F) << 16;
        if ((n3 >>>= 7) == 0) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(n4);
            this.niobuffer.order(this.byteOrder);
            --this.position;
            this.niobuffer.position(this.position);
            return 3;
        }
        n4 |= 0x800000;
        n4 |= (n3 & 0x7F) << 24;
        if ((n3 >>>= 7) == 0) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(n4);
            this.niobuffer.order(this.byteOrder);
            this.position -= 0;
            return 4;
        }
        long l2 = (long)(n4 |= Integer.MIN_VALUE) & 0xFFFFFFFFL | (long)n3 << 32;
        this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.writeLong(l2);
        this.niobuffer.order(this.byteOrder);
        this.position -= 3;
        this.niobuffer.position(this.position);
        return 5;
    }

    @Override
    public void writeString(String string) throws KryoException {
        int n2;
        int n3;
        this.niobuffer.position(this.position);
        if (string == null) {
            this.writeByte(128);
            return;
        }
        int n4 = string.length();
        if (n4 == 0) {
            this.writeByte(129);
            return;
        }
        boolean bl2 = false;
        if (n4 > 1 && n4 < 64) {
            bl2 = true;
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = string.charAt(n3);
                if (n2 <= 127) continue;
                bl2 = false;
                break;
            }
        }
        if (bl2) {
            if (this.capacity - this.position < n4) {
                this.writeAscii_slow(string, n4);
            } else {
                byte[] byArray = string.getBytes();
                this.niobuffer.put(byArray, 0, byArray.length);
                this.position += n4;
            }
            this.niobuffer.put(this.position - 1, (byte)(this.niobuffer.get(this.position - 1) | 0x80));
        } else {
            this.writeUtf8Length(n4 + 1);
            if (this.capacity - this.position >= n4) {
                char c2;
                n2 = this.position;
                for (n3 = 0; n3 < n4 && (c2 = string.charAt(n3)) <= '\u007f'; ++n3) {
                    this.niobuffer.put(n2++, (byte)c2);
                }
                this.position = n2;
                this.niobuffer.position(n2);
            }
            if (n3 < n4) {
                this.writeString_slow(string, n4, n3);
            }
            this.niobuffer.position(this.position);
        }
    }

    @Override
    public void writeString(CharSequence charSequence) throws KryoException {
        int n2;
        if (charSequence == null) {
            this.writeByte(128);
            return;
        }
        int n3 = charSequence.length();
        if (n3 == 0) {
            this.writeByte(129);
            return;
        }
        this.writeUtf8Length(n3 + 1);
        if (this.capacity - this.position >= n3) {
            char c2;
            int n4 = this.position;
            for (n2 = 0; n2 < n3 && (c2 = charSequence.charAt(n2)) <= '\u007f'; ++n2) {
                this.niobuffer.put(n4++, (byte)c2);
            }
            this.position = n4;
            this.niobuffer.position(n4);
        }
        if (n2 < n3) {
            this.writeString_slow(charSequence, n3, n2);
        }
        this.niobuffer.position(this.position);
    }

    @Override
    public void writeAscii(String string) throws KryoException {
        if (string == null) {
            this.writeByte(128);
            return;
        }
        int n2 = string.length();
        if (n2 == 0) {
            this.writeByte(129);
            return;
        }
        if (this.capacity - this.position < n2) {
            this.writeAscii_slow(string, n2);
        } else {
            byte[] byArray = string.getBytes();
            this.niobuffer.put(byArray, 0, byArray.length);
            this.position += n2;
        }
        this.niobuffer.put(this.position - 1, (byte)(this.niobuffer.get(this.position - 1) | 0x80));
    }

    private void writeUtf8Length(int n2) {
        if (n2 >>> 6 == 0) {
            this.require(1);
            this.niobuffer.put((byte)(n2 | 0x80));
            ++this.position;
        } else if (n2 >>> 13 == 0) {
            this.require(2);
            this.niobuffer.put((byte)(n2 | 0x40 | 0x80));
            this.niobuffer.put((byte)(n2 >>> 6));
            this.position += 2;
        } else if (n2 >>> 20 == 0) {
            this.require(3);
            this.niobuffer.put((byte)(n2 | 0x40 | 0x80));
            this.niobuffer.put((byte)(n2 >>> 6 | 0x80));
            this.niobuffer.put((byte)(n2 >>> 13));
            this.position += 3;
        } else if (n2 >>> 27 == 0) {
            this.require(4);
            this.niobuffer.put((byte)(n2 | 0x40 | 0x80));
            this.niobuffer.put((byte)(n2 >>> 6 | 0x80));
            this.niobuffer.put((byte)(n2 >>> 13 | 0x80));
            this.niobuffer.put((byte)(n2 >>> 20));
            this.position += 4;
        } else {
            this.require(5);
            this.niobuffer.put((byte)(n2 | 0x40 | 0x80));
            this.niobuffer.put((byte)(n2 >>> 6 | 0x80));
            this.niobuffer.put((byte)(n2 >>> 13 | 0x80));
            this.niobuffer.put((byte)(n2 >>> 20 | 0x80));
            this.niobuffer.put((byte)(n2 >>> 27));
            this.position += 5;
        }
    }

    private void writeString_slow(CharSequence charSequence, int n2, int n3) {
        while (n3 < n2) {
            char c2;
            if (this.position == this.capacity) {
                this.require(Math.min(this.capacity, n2 - n3));
            }
            if ((c2 = charSequence.charAt(n3)) <= '\u007f') {
                this.niobuffer.put(this.position++, (byte)c2);
            } else if (c2 > '\u07ff') {
                this.niobuffer.put(this.position++, (byte)(0xE0 | c2 >> 12 & 0xF));
                this.require(2);
                this.niobuffer.put(this.position++, (byte)(0x80 | c2 >> 6 & 0x3F));
                this.niobuffer.put(this.position++, (byte)(0x80 | c2 & 0x3F));
            } else {
                this.niobuffer.put(this.position++, (byte)(0xC0 | c2 >> 6 & 0x1F));
                this.require(1);
                this.niobuffer.put(this.position++, (byte)(0x80 | c2 & 0x3F));
            }
            ++n3;
        }
    }

    private void writeAscii_slow(String string, int n2) throws KryoException {
        ByteBuffer byteBuffer = this.niobuffer;
        int n3 = 0;
        int n4 = Math.min(n2, this.capacity - this.position);
        while (n3 < n2) {
            byte[] byArray = new byte[n2];
            string.getBytes(n3, n3 + n4, byArray, 0);
            byteBuffer.put(byArray, 0, n4);
            this.position += n4;
            if (!this.require(n4 = Math.min(n2 - (n3 += n4), this.capacity))) continue;
            byteBuffer = this.niobuffer;
        }
    }

    @Override
    public void writeFloat(float f2) throws KryoException {
        this.require(4);
        this.niobuffer.putFloat(f2);
        this.position += 4;
    }

    @Override
    public void writeShort(int n2) throws KryoException {
        this.require(2);
        this.niobuffer.putShort((short)n2);
        this.position += 2;
    }

    @Override
    public void writeLong(long l2) throws KryoException {
        this.require(8);
        this.niobuffer.putLong(l2);
        this.position += 8;
    }

    @Override
    public int writeLong(long l2, boolean bl2) throws KryoException {
        if (!this.varIntsEnabled) {
            this.writeLong(l2);
            return 8;
        }
        return this.writeVarLong(l2, bl2);
    }

    @Override
    public int writeVarLong(long l2, boolean bl2) throws KryoException {
        if (!bl2) {
            l2 = l2 << 1 ^ l2 >> 63;
        }
        int n2 = 0;
        n2 = (int)(l2 & 0x7FL);
        if ((l2 >>>= 7) == 0L) {
            this.writeByte(n2);
            return 1;
        }
        n2 |= 0x80;
        n2 = (int)((long)n2 | (l2 & 0x7FL) << 8);
        if ((l2 >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(n2);
            this.niobuffer.order(this.byteOrder);
            this.position -= 2;
            this.niobuffer.position(this.position);
            return 2;
        }
        n2 |= 0x8000;
        n2 = (int)((long)n2 | (l2 & 0x7FL) << 16);
        if ((l2 >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(n2);
            this.niobuffer.order(this.byteOrder);
            --this.position;
            this.niobuffer.position(this.position);
            return 3;
        }
        n2 |= 0x800000;
        n2 = (int)((long)n2 | (l2 & 0x7FL) << 24);
        if ((l2 >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(n2);
            this.niobuffer.order(this.byteOrder);
            this.position -= 0;
            return 4;
        }
        long l3 = (long)(n2 |= Integer.MIN_VALUE) & 0xFFFFFFFFL;
        l3 |= (l2 & 0x7FL) << 32;
        if ((l2 >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeLong(l3);
            this.niobuffer.order(this.byteOrder);
            this.position -= 3;
            this.niobuffer.position(this.position);
            return 5;
        }
        l3 |= 0x8000000000L;
        l3 |= (l2 & 0x7FL) << 40;
        if ((l2 >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeLong(l3);
            this.niobuffer.order(this.byteOrder);
            this.position -= 2;
            this.niobuffer.position(this.position);
            return 6;
        }
        l3 |= 0x800000000000L;
        l3 |= (l2 & 0x7FL) << 48;
        if ((l2 >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeLong(l3);
            this.niobuffer.order(this.byteOrder);
            --this.position;
            this.niobuffer.position(this.position);
            return 7;
        }
        l3 |= 0x80000000000000L;
        l3 |= (l2 & 0x7FL) << 56;
        if ((l2 >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeLong(l3);
            this.niobuffer.order(this.byteOrder);
            return 8;
        }
        this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.writeLong(l3 |= Long.MIN_VALUE);
        this.niobuffer.order(this.byteOrder);
        this.write((byte)l2);
        return 9;
    }

    @Override
    public void writeBoolean(boolean bl2) throws KryoException {
        this.require(1);
        this.niobuffer.put((byte)(bl2 ? 1 : 0));
        ++this.position;
    }

    @Override
    public void writeChar(char c2) throws KryoException {
        this.require(2);
        this.niobuffer.putChar(c2);
        this.position += 2;
    }

    @Override
    public void writeDouble(double d2) throws KryoException {
        this.require(8);
        this.niobuffer.putDouble(d2);
        this.position += 8;
    }

    @Override
    public void writeFloats(float[] fArray) throws KryoException {
        if (this.capacity - this.position >= fArray.length * 4 && this.isNativeOrder()) {
            FloatBuffer floatBuffer = this.niobuffer.asFloatBuffer();
            floatBuffer.put(fArray);
            this.position += fArray.length * 4;
        } else {
            super.writeFloats(fArray);
        }
    }

    @Override
    public void writeShorts(short[] sArray) throws KryoException {
        if (this.capacity - this.position >= sArray.length * 2 && this.isNativeOrder()) {
            ShortBuffer shortBuffer = this.niobuffer.asShortBuffer();
            shortBuffer.put(sArray);
            this.position += sArray.length * 2;
        } else {
            super.writeShorts(sArray);
        }
    }

    @Override
    public void writeChars(char[] cArray) throws KryoException {
        if (this.capacity - this.position >= cArray.length * 2 && this.isNativeOrder()) {
            CharBuffer charBuffer = this.niobuffer.asCharBuffer();
            charBuffer.put(cArray);
            this.position += cArray.length * 2;
        } else {
            super.writeChars(cArray);
        }
    }

    @Override
    public void writeDoubles(double[] dArray) throws KryoException {
        if (this.capacity - this.position >= dArray.length * 8 && this.isNativeOrder()) {
            DoubleBuffer doubleBuffer = this.niobuffer.asDoubleBuffer();
            doubleBuffer.put(dArray);
            this.position += dArray.length * 8;
        } else {
            super.writeDoubles(dArray);
        }
    }

    private boolean isNativeOrder() {
        return this.byteOrder == nativeOrder;
    }
}

