/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.serializers;

import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.Kryo;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.Serializer;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.io.Input;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.io.Output;
import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.util.Util;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class TimeSerializers {
    public static void addDefaultSerializers(Kryo kryo) {
        if (Util.isClassAvailable("java.time.Duration")) {
            kryo.addDefaultSerializer(Duration.class, new DurationSerializer());
        }
        if (Util.isClassAvailable("java.time.Instant")) {
            kryo.addDefaultSerializer(Instant.class, new InstantSerializer());
        }
        if (Util.isClassAvailable("java.time.LocalDate")) {
            kryo.addDefaultSerializer(LocalDate.class, new LocalDateSerializer());
        }
        if (Util.isClassAvailable("java.time.LocalTime")) {
            kryo.addDefaultSerializer(LocalTime.class, new LocalTimeSerializer());
        }
        if (Util.isClassAvailable("java.time.LocalDateTime")) {
            kryo.addDefaultSerializer(LocalDateTime.class, new LocalDateTimeSerializer());
        }
        if (Util.isClassAvailable("java.time.ZoneOffset")) {
            kryo.addDefaultSerializer(ZoneOffset.class, new ZoneOffsetSerializer());
        }
        if (Util.isClassAvailable("java.time.ZoneId")) {
            kryo.addDefaultSerializer(ZoneId.class, new ZoneIdSerializer());
        }
        if (Util.isClassAvailable("java.time.OffsetTime")) {
            kryo.addDefaultSerializer(OffsetTime.class, new OffsetTimeSerializer());
        }
        if (Util.isClassAvailable("java.time.OffsetDateTime")) {
            kryo.addDefaultSerializer(OffsetDateTime.class, new OffsetDateTimeSerializer());
        }
        if (Util.isClassAvailable("java.time.ZonedDateTime")) {
            kryo.addDefaultSerializer(ZonedDateTime.class, new ZonedDateTimeSerializer());
        }
        if (Util.isClassAvailable("java.time.Year")) {
            kryo.addDefaultSerializer(Year.class, new YearSerializer());
        }
        if (Util.isClassAvailable("java.time.YearMonth")) {
            kryo.addDefaultSerializer(YearMonth.class, new YearMonthSerializer());
        }
        if (Util.isClassAvailable("java.time.MonthDay")) {
            kryo.addDefaultSerializer(MonthDay.class, new MonthDaySerializer());
        }
        if (Util.isClassAvailable("java.time.Period")) {
            kryo.addDefaultSerializer(Period.class, new PeriodSerializer());
        }
    }

    private static class PeriodSerializer
    extends Serializer<Period> {
        private PeriodSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Period period) {
            output.writeInt(period.getYears(), true);
            output.writeInt(period.getMonths(), true);
            output.writeInt(period.getDays(), true);
        }

        @Override
        public Period read(Kryo kryo, Input input, Class<Period> clazz) {
            int n2 = input.readInt(true);
            int n3 = input.readInt(true);
            int n4 = input.readInt(true);
            return Period.of(n2, n3, n4);
        }
    }

    private static class MonthDaySerializer
    extends Serializer<MonthDay> {
        private MonthDaySerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, MonthDay monthDay) {
            output.writeByte(monthDay.getMonthValue());
            output.writeByte(monthDay.getDayOfMonth());
        }

        @Override
        public MonthDay read(Kryo kryo, Input input, Class<MonthDay> clazz) {
            byte by2 = input.readByte();
            byte by3 = input.readByte();
            return MonthDay.of(by2, (int)by3);
        }
    }

    private static class YearMonthSerializer
    extends Serializer<YearMonth> {
        private YearMonthSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, YearMonth yearMonth) {
            output.writeInt(yearMonth.getYear(), true);
            output.writeByte(yearMonth.getMonthValue());
        }

        @Override
        public YearMonth read(Kryo kryo, Input input, Class<YearMonth> clazz) {
            int n2 = input.readInt(true);
            byte by2 = input.readByte();
            return YearMonth.of(n2, by2);
        }
    }

    private static class YearSerializer
    extends Serializer<Year> {
        private YearSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Year year) {
            output.writeInt(year.getValue(), true);
        }

        @Override
        public Year read(Kryo kryo, Input input, Class<Year> clazz) {
            return Year.of(input.readInt(true));
        }
    }

    private static class ZonedDateTimeSerializer
    extends Serializer<ZonedDateTime> {
        private ZonedDateTimeSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, ZonedDateTime zonedDateTime) {
            LocalDateSerializer.write(output, zonedDateTime.toLocalDate());
            LocalTimeSerializer.write(output, zonedDateTime.toLocalTime());
            ZoneIdSerializer.write(output, zonedDateTime.getZone());
        }

        @Override
        public ZonedDateTime read(Kryo kryo, Input input, Class<ZonedDateTime> clazz) {
            LocalDate localDate = LocalDateSerializer.read(input);
            LocalTime localTime = LocalTimeSerializer.read(input);
            ZoneId zoneId = ZoneIdSerializer.read(input);
            return ZonedDateTime.of(localDate, localTime, zoneId);
        }
    }

    private static class OffsetDateTimeSerializer
    extends Serializer<OffsetDateTime> {
        private OffsetDateTimeSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, OffsetDateTime offsetDateTime) {
            LocalDateSerializer.write(output, offsetDateTime.toLocalDate());
            LocalTimeSerializer.write(output, offsetDateTime.toLocalTime());
            ZoneOffsetSerializer.write(output, offsetDateTime.getOffset());
        }

        @Override
        public OffsetDateTime read(Kryo kryo, Input input, Class<OffsetDateTime> clazz) {
            LocalDate localDate = LocalDateSerializer.read(input);
            LocalTime localTime = LocalTimeSerializer.read(input);
            ZoneOffset zoneOffset = ZoneOffsetSerializer.read(input);
            return OffsetDateTime.of(localDate, localTime, zoneOffset);
        }
    }

    private static class OffsetTimeSerializer
    extends Serializer<OffsetTime> {
        private OffsetTimeSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, OffsetTime offsetTime) {
            LocalTimeSerializer.write(output, offsetTime.toLocalTime());
            ZoneOffsetSerializer.write(output, offsetTime.getOffset());
        }

        @Override
        public OffsetTime read(Kryo kryo, Input input, Class<OffsetTime> clazz) {
            LocalTime localTime = LocalTimeSerializer.read(input);
            ZoneOffset zoneOffset = ZoneOffsetSerializer.read(input);
            return OffsetTime.of(localTime, zoneOffset);
        }
    }

    private static class ZoneIdSerializer
    extends Serializer<ZoneId> {
        private ZoneIdSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, ZoneId zoneId) {
            ZoneIdSerializer.write(output, zoneId);
        }

        static void write(Output output, ZoneId zoneId) {
            output.writeString(zoneId.getId());
        }

        @Override
        public ZoneId read(Kryo kryo, Input input, Class<ZoneId> clazz) {
            return ZoneIdSerializer.read(input);
        }

        static ZoneId read(Input input) {
            String string = input.readString();
            return ZoneId.of(string);
        }
    }

    private static class ZoneOffsetSerializer
    extends Serializer<ZoneOffset> {
        private ZoneOffsetSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, ZoneOffset zoneOffset) {
            ZoneOffsetSerializer.write(output, zoneOffset);
        }

        static void write(Output output, ZoneOffset zoneOffset) {
            int n2 = zoneOffset.getTotalSeconds();
            int n3 = n2 % 900 == 0 ? n2 / 900 : 127;
            output.writeByte(n3);
            if (n3 == 127) {
                output.writeInt(n2);
            }
        }

        @Override
        public ZoneOffset read(Kryo kryo, Input input, Class<ZoneOffset> clazz) {
            return ZoneOffsetSerializer.read(input);
        }

        static ZoneOffset read(Input input) {
            byte by2 = input.readByte();
            return by2 == 127 ? ZoneOffset.ofTotalSeconds(input.readInt()) : ZoneOffset.ofTotalSeconds(by2 * 900);
        }
    }

    private static class LocalTimeSerializer
    extends Serializer<LocalTime> {
        private LocalTimeSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, LocalTime localTime) {
            LocalTimeSerializer.write(output, localTime);
        }

        static void write(Output output, LocalTime localTime) {
            if (localTime.getNano() == 0) {
                if (localTime.getSecond() == 0) {
                    if (localTime.getMinute() == 0) {
                        output.writeByte(~localTime.getHour());
                    } else {
                        output.writeByte(localTime.getHour());
                        output.writeByte(~localTime.getMinute());
                    }
                } else {
                    output.writeByte(localTime.getHour());
                    output.writeByte(localTime.getMinute());
                    output.writeByte(~localTime.getSecond());
                }
            } else {
                output.writeByte(localTime.getHour());
                output.writeByte(localTime.getMinute());
                output.writeByte(localTime.getSecond());
                output.writeInt(localTime.getNano(), true);
            }
        }

        @Override
        public LocalTime read(Kryo kryo, Input input, Class<LocalTime> clazz) {
            return LocalTimeSerializer.read(input);
        }

        static LocalTime read(Input input) {
            int n2 = input.readByte();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (n2 < 0) {
                n2 ^= 0xFFFFFFFF;
            } else {
                n3 = input.readByte();
                if (n3 < 0) {
                    n3 ^= 0xFFFFFFFF;
                } else {
                    n4 = input.readByte();
                    if (n4 < 0) {
                        n4 ^= 0xFFFFFFFF;
                    } else {
                        n5 = input.readInt(true);
                    }
                }
            }
            return LocalTime.of(n2, n3, n4, n5);
        }
    }

    private static class LocalDateTimeSerializer
    extends Serializer<LocalDateTime> {
        private LocalDateTimeSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, LocalDateTime localDateTime) {
            LocalDateSerializer.write(output, localDateTime.toLocalDate());
            LocalTimeSerializer.write(output, localDateTime.toLocalTime());
        }

        @Override
        public LocalDateTime read(Kryo kryo, Input input, Class<LocalDateTime> clazz) {
            LocalDate localDate = LocalDateSerializer.read(input);
            LocalTime localTime = LocalTimeSerializer.read(input);
            return LocalDateTime.of(localDate, localTime);
        }
    }

    private static class LocalDateSerializer
    extends Serializer<LocalDate> {
        private LocalDateSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, LocalDate localDate) {
            LocalDateSerializer.write(output, localDate);
        }

        static void write(Output output, LocalDate localDate) {
            output.writeInt(localDate.getYear(), true);
            output.writeByte(localDate.getMonthValue());
            output.writeByte(localDate.getDayOfMonth());
        }

        @Override
        public LocalDate read(Kryo kryo, Input input, Class<LocalDate> clazz) {
            return LocalDateSerializer.read(input);
        }

        static LocalDate read(Input input) {
            int n2 = input.readInt(true);
            byte by2 = input.readByte();
            byte by3 = input.readByte();
            return LocalDate.of(n2, by2, (int)by3);
        }
    }

    private static class InstantSerializer
    extends Serializer<Instant> {
        private InstantSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Instant instant) {
            output.writeLong(instant.getEpochSecond(), true);
            output.writeInt(instant.getNano(), true);
        }

        @Override
        public Instant read(Kryo kryo, Input input, Class<Instant> clazz) {
            long l2 = input.readLong(true);
            int n2 = input.readInt(true);
            return Instant.ofEpochSecond(l2, n2);
        }
    }

    private static class DurationSerializer
    extends Serializer<Duration> {
        private DurationSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Duration duration) {
            output.writeLong(duration.getSeconds());
            output.writeInt(duration.getNano(), true);
        }

        @Override
        public Duration read(Kryo kryo, Input input, Class<Duration> clazz) {
            long l2 = input.readLong();
            int n2 = input.readInt(true);
            return Duration.ofSeconds(l2, n2);
        }
    }
}

